/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.DiscoveryV1;
import com.sun.jini.discovery.DiscoveryV2;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementDecoder;
import com.sun.jini.discovery.MulticastAnnouncementEncoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestDecoder;
import com.sun.jini.discovery.MulticastRequestEncoder;
import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastDiscoveryServer;
import com.sun.jini.discovery.UnicastResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Socket;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;

public abstract class Discovery {
    public static final int PROTOCOL_VERSION_1 = 1;
    public static final int PROTOCOL_VERSION_2 = 2;
    static final int MIN_MAX_PACKET_SIZE = 512;

    public static Discovery getProtocol1() {
        return DiscoveryV1.getInstance();
    }

    public static Discovery getProtocol2(ClassLoader classLoader) {
        return DiscoveryV2.getInstance(classLoader);
    }

    public static Discovery getProtocol2(MulticastRequestEncoder[] multicastRequestEncoderArray, MulticastRequestDecoder[] multicastRequestDecoderArray, MulticastAnnouncementEncoder[] multicastAnnouncementEncoderArray, MulticastAnnouncementDecoder[] multicastAnnouncementDecoderArray, UnicastDiscoveryClient[] unicastDiscoveryClientArray, UnicastDiscoveryServer[] unicastDiscoveryServerArray) {
        return DiscoveryV2.getInstance(multicastRequestEncoderArray, multicastRequestDecoderArray, multicastAnnouncementEncoderArray, multicastAnnouncementDecoderArray, unicastDiscoveryClientArray, unicastDiscoveryServerArray);
    }

    public abstract EncodeIterator encodeMulticastRequest(MulticastRequest var1, int var2, InvocationConstraints var3);

    public abstract MulticastRequest decodeMulticastRequest(DatagramPacket var1, InvocationConstraints var2, ClientSubjectChecker var3) throws IOException;

    public abstract EncodeIterator encodeMulticastAnnouncement(MulticastAnnouncement var1, int var2, InvocationConstraints var3);

    public abstract MulticastAnnouncement decodeMulticastAnnouncement(DatagramPacket var1, InvocationConstraints var2) throws IOException;

    public abstract UnicastResponse doUnicastDiscovery(Socket var1, InvocationConstraints var2, ClassLoader var3, ClassLoader var4, Collection var5) throws IOException, ClassNotFoundException;

    public abstract void handleUnicastDiscovery(UnicastResponse var1, Socket var2, InvocationConstraints var3, ClientSubjectChecker var4, Collection var5) throws IOException;
}

