/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.HttpClientManager;
import com.sun.jini.jeri.internal.http.HttpClientSocketFactory;
import com.sun.jini.jeri.internal.http.HttpParseException;
import com.sun.jini.jeri.internal.http.MessageReader;
import com.sun.jini.jeri.internal.http.MessageWriter;
import com.sun.jini.jeri.internal.http.Request;
import com.sun.jini.jeri.internal.http.ServerInfo;
import com.sun.jini.jeri.internal.http.StartLine;
import com.sun.jini.jeri.internal.http.TimedConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.OutboundRequest;

public class HttpClientConnection
implements TimedConnection {
    private static final int HTTP_MAJOR = 1;
    private static final int HTTP_MINOR = 1;
    private static final String clientString = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return "Java/" + System.getProperty("java.version", "???") + " " + (class$com$sun$jini$jeri$internal$http$HttpClientConnection == null ? (class$com$sun$jini$jeri$internal$http$HttpClientConnection = HttpClientConnection.class$("com.sun.jini.jeri.internal.http.HttpClientConnection")) : class$com$sun$jini$jeri$internal$http$HttpClientConnection).getName();
        }
    });
    private static final int DIRECT = 0;
    private static final int PROXIED = 1;
    private static final int TUNNELED = 2;
    private static final int IDLE = 0;
    private static final int BUSY = 1;
    private static final int CLOSED = 2;
    private final int mode;
    private final Object stateLock = new Object();
    private int state = 0;
    private final HttpClientManager manager;
    private ServerInfo targetInfo;
    private ServerInfo proxyInfo;
    private String[] acks;
    private Socket sock;
    private OutputStream out;
    private InputStream in;
    static /* synthetic */ Class class$com$sun$jini$jeri$internal$http$HttpClientConnection;

    public HttpClientConnection(String string, int n, HttpClientSocketFactory httpClientSocketFactory, HttpClientManager httpClientManager) throws IOException {
        this.manager = httpClientManager;
        this.mode = 0;
        this.targetInfo = httpClientManager.getServerInfo(string, n);
        this.setupConnection(httpClientSocketFactory);
    }

    public HttpClientConnection(String string, int n, String string2, int n2, boolean bl, HttpClientSocketFactory httpClientSocketFactory, HttpClientManager httpClientManager) throws IOException {
        this.manager = httpClientManager;
        this.mode = bl ? 2 : 1;
        this.targetInfo = httpClientManager.getServerInfo(string, n);
        this.proxyInfo = httpClientManager.getServerInfo(string2, n2);
        this.setupConnection(httpClientSocketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping() throws IOException {
        this.markBusy();
        this.fetchServerInfo();
        try {
            boolean bl = this.ping(false);
            Object var3_2 = null;
            this.markIdle();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.markIdle();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundRequest newRequest() throws IOException {
        OutboundRequestImpl outboundRequestImpl = null;
        this.markBusy();
        this.fetchServerInfo();
        try {
            OutboundRequestImpl outboundRequestImpl2 = outboundRequestImpl = new OutboundRequestImpl();
            Object var4_3 = null;
            if (outboundRequestImpl == null) {
                this.markIdle();
            }
            return outboundRequestImpl2;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (outboundRequestImpl != null) break block3;
                this.markIdle();
            }
            throw throwable;
        }
    }

    protected void idle() {
    }

    public Socket getSocket() {
        return this.sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean bl) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return true;
            }
            if (!bl && this.state == 1) {
                return false;
            }
            this.state = 2;
        }
        this.disconnect();
        return true;
    }

    private void fetchServerInfo() {
        ServerInfo serverInfo = this.manager.getServerInfo(this.targetInfo.host, this.targetInfo.port);
        if (serverInfo.timestamp > this.targetInfo.timestamp) {
            this.targetInfo = serverInfo;
        }
        if (this.mode != 0) {
            serverInfo = this.manager.getServerInfo(this.proxyInfo.host, this.proxyInfo.port);
            if (serverInfo.timestamp > this.proxyInfo.timestamp) {
                this.proxyInfo = serverInfo;
            }
        }
    }

    private void flushServerInfo() {
        this.manager.cacheServerInfo(this.targetInfo);
        if (this.mode != 0) {
            this.manager.cacheServerInfo(this.proxyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBusy() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                throw new IOException("connection busy");
            }
            if (this.state == 2) {
                throw new IOException("connection closed");
            }
            this.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markIdle() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return;
            }
            this.state = 0;
        }
        this.idle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupConnection(HttpClientSocketFactory httpClientSocketFactory) throws IOException {
        boolean bl = false;
        try {
            for (int i = 0; i < 4; ++i) {
                if (this.sock == null) {
                    this.connect(httpClientSocketFactory);
                }
                if (this.mode == 1 && this.proxyInfo.timestamp == -1L) {
                    this.requestProxyOptions();
                    continue;
                }
                if (this.targetInfo.timestamp == -1L) {
                    this.ping(true);
                    continue;
                }
                bl = true;
                Object var5_4 = null;
                if (!bl) {
                    this.disconnect();
                }
                return;
            }
            Object var5_5 = null;
            if (!bl) {
                this.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!bl) {
                this.disconnect();
            }
            throw throwable;
        }
        throw new ConnectException("failed to establish HTTP connection");
    }

    private void connect(HttpClientSocketFactory httpClientSocketFactory) throws IOException {
        this.disconnect();
        for (int i = 0; i < 2; ++i) {
            if (this.sock == null) {
                ServerInfo serverInfo = this.mode == 0 ? this.targetInfo : this.proxyInfo;
                this.sock = httpClientSocketFactory.createSocket(serverInfo.host, serverInfo.port);
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.in = new BufferedInputStream(this.sock.getInputStream());
            }
            if (this.mode != 2) {
                return;
            }
            if (!this.requestProxyConnect()) continue;
            this.sock = httpClientSocketFactory.createTunnelSocket(this.sock);
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.in = new BufferedInputStream(this.sock.getInputStream());
            return;
        }
        throw new ConnectException("failed to establish proxy tunnel");
    }

    private void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
            this.out = null;
            this.in = null;
        }
    }

    private boolean ping(boolean bl) throws IOException {
        Header header;
        StartLine startLine;
        StartLine startLine2 = this.createPostLine();
        Header header2 = this.createPostHeader(startLine2);
        header2.setField("RMI-Request-Type", "ping");
        MessageWriter messageWriter = new MessageWriter(this.out, false);
        messageWriter.writeStartLine(startLine2);
        messageWriter.writeHeader(header2);
        messageWriter.writeTrailer(null);
        do {
            MessageReader messageReader = new MessageReader(this.in, false);
            startLine = messageReader.readStartLine();
            header = messageReader.readHeader();
            header.merge(messageReader.readTrailer());
        } while (startLine.status / 100 == 1);
        this.analyzePostResponse(startLine, header);
        if (!HttpClientConnection.supportsPersist(startLine, header)) {
            if (bl) {
                this.disconnect();
            } else {
                this.shutdown(true);
            }
        }
        return startLine.status / 100 == 2;
    }

    private boolean requestProxyOptions() throws IOException {
        Header header;
        StartLine startLine;
        MessageWriter messageWriter = new MessageWriter(this.out, false);
        messageWriter.writeStartLine(new StartLine(1, 1, "OPTIONS", "*"));
        messageWriter.writeHeader(this.createProxyHeader());
        messageWriter.writeTrailer(null);
        do {
            MessageReader messageReader = new MessageReader(this.in, false);
            startLine = messageReader.readStartLine();
            header = messageReader.readHeader();
            header.merge(messageReader.readTrailer());
        } while (startLine.status / 100 == 1);
        this.analyzeProxyResponse(startLine, header);
        if (!HttpClientConnection.supportsPersist(startLine, header)) {
            this.disconnect();
        }
        return startLine.status / 100 == 2;
    }

    private boolean requestProxyConnect() throws IOException {
        Header header;
        StartLine startLine;
        StartLine startLine2 = new StartLine(1, 1, "CONNECT", this.targetInfo.host + ":" + this.targetInfo.port);
        Header header2 = this.createProxyHeader();
        String string = this.proxyInfo.getAuthString("http", startLine2.method, startLine2.uri);
        if (string != null) {
            header2.setField("Proxy-Authorization", string);
        }
        MessageWriter messageWriter = new MessageWriter(this.out, false);
        messageWriter.writeStartLine(startLine2);
        messageWriter.writeHeader(header2);
        messageWriter.writeTrailer(null);
        do {
            MessageReader messageReader = new MessageReader(this.in, true);
            startLine = messageReader.readStartLine();
            header = messageReader.readHeader();
            header.merge(messageReader.readTrailer());
        } while (startLine.status / 100 == 1);
        this.analyzeProxyResponse(startLine, header);
        if (startLine.status / 100 == 2) {
            return true;
        }
        if (!HttpClientConnection.supportsPersist(startLine, header)) {
            this.disconnect();
        }
        return false;
    }

    private StartLine createPostLine() {
        String string = this.mode == 1 ? "http://" + this.targetInfo.host + ":" + this.targetInfo.port + "/" : "/";
        return new StartLine(1, 1, "POST", string);
    }

    private Header createBaseHeader() {
        Header header = new Header();
        long l = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(l));
        header.setField("User-Agent", clientString);
        return header;
    }

    private Header createProxyHeader() {
        Header header = this.createBaseHeader();
        header.setField("Host", this.proxyInfo.host + ":" + this.proxyInfo.port);
        return header;
    }

    private Header createPostHeader(StartLine startLine) {
        Header header = this.createBaseHeader();
        header.setField("Host", this.targetInfo.host + ":" + this.targetInfo.port);
        header.setField("Connection", "TE");
        header.setField("TE", "trailers");
        String string = this.targetInfo.getAuthString("http", startLine.method, startLine.uri);
        if (string != null) {
            header.setField("Authorization", string);
        }
        if (this.mode == 1 && (string = this.proxyInfo.getAuthString("http", startLine.method, startLine.uri)) != null) {
            header.setField("Proxy-Authorization", string);
        }
        this.acks = this.manager.getUnsentAcks(this.targetInfo.host, this.targetInfo.port);
        if (this.acks.length > 0) {
            String string2 = this.acks[0];
            for (int i = 1; i < this.acks.length; ++i) {
                string2 = string2 + ", " + this.acks[i];
            }
            header.setField("RMI-Response-Ack", string2);
        }
        return header;
    }

    private void analyzePostResponse(StartLine startLine, Header header) {
        long l = System.currentTimeMillis();
        String string = header.getField("WWW-Authenticate");
        if (string != null) {
            try {
                this.targetInfo.setAuthInfo(string);
            }
            catch (HttpParseException httpParseException) {
                // empty catch block
            }
            this.targetInfo.timestamp = l;
        } else {
            string = header.getField("Authentication-Info");
            if (string != null) {
                try {
                    this.targetInfo.updateAuthInfo(string);
                }
                catch (HttpParseException httpParseException) {
                    // empty catch block
                }
                this.targetInfo.timestamp = l;
            }
        }
        if (this.mode != 0) {
            string = header.getField("Proxy-Authenticate");
            if (string != null) {
                try {
                    this.proxyInfo.setAuthInfo(string);
                }
                catch (HttpParseException httpParseException) {
                    // empty catch block
                }
                this.proxyInfo.timestamp = l;
            } else {
                string = header.getField("Proxy-Authentication-Info");
                if (string != null) {
                    try {
                        this.proxyInfo.updateAuthInfo(string);
                    }
                    catch (HttpParseException httpParseException) {
                        // empty catch block
                    }
                    this.proxyInfo.timestamp = l;
                }
            }
        }
        if (this.mode != 1) {
            this.targetInfo.major = startLine.major;
            this.targetInfo.minor = startLine.minor;
            this.targetInfo.timestamp = l;
        } else {
            if (startLine.status == 407) {
                this.proxyInfo.major = startLine.major;
                this.proxyInfo.minor = startLine.minor;
            }
            this.proxyInfo.timestamp = l;
        }
        if (startLine.status / 100 == 2) {
            this.manager.clearUnsentAcks(this.targetInfo.host, this.targetInfo.port, this.acks);
            this.targetInfo.timestamp = l;
        }
        this.flushServerInfo();
    }

    private void analyzeProxyResponse(StartLine startLine, Header header) {
        this.proxyInfo.major = startLine.major;
        this.proxyInfo.minor = startLine.minor;
        this.proxyInfo.timestamp = System.currentTimeMillis();
        String string = header.getField("Proxy-Authenticate");
        if (string != null) {
            try {
                this.proxyInfo.setAuthInfo(string);
            }
            catch (HttpParseException httpParseException) {}
        } else {
            string = header.getField("Proxy-Authentication-Info");
            if (string != null) {
                try {
                    this.proxyInfo.updateAuthInfo(string);
                }
                catch (HttpParseException httpParseException) {
                    // empty catch block
                }
            }
        }
        this.flushServerInfo();
    }

    private boolean supportsChunking() {
        ServerInfo serverInfo = this.mode == 1 ? this.proxyInfo : this.targetInfo;
        return StartLine.compareVersions(serverInfo.major, serverInfo.minor, 1, 1) >= 0;
    }

    private static boolean supportsPersist(StartLine startLine, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int n = StartLine.compareVersions(startLine.major, startLine.minor, 1, 1);
        return n >= 0;
    }

    private class OutboundRequestImpl
    extends Request
    implements OutboundRequest {
        private final MessageWriter writer;
        private MessageReader reader;
        private StartLine inLine;
        private Header inHeader;
        private boolean persist = false;

        OutboundRequestImpl() throws IOException {
            StartLine startLine = HttpClientConnection.this.createPostLine();
            Header header = HttpClientConnection.this.createPostHeader(startLine);
            header.setField("RMI-Request-Type", "standard");
            this.writer = new MessageWriter(HttpClientConnection.this.out, HttpClientConnection.this.supportsChunking());
            this.writer.writeStartLine(startLine);
            this.writer.writeHeader(header);
            this.writer.flush();
        }

        public void populateContext(Collection collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        public InvocationConstraints getUnfulfilledConstraints() {
            throw new AssertionError();
        }

        public OutputStream getRequestOutputStream() {
            return this.getOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.getInputStream();
        }

        void startOutput() throws IOException {
        }

        void write(byte[] byArray, int n, int n2) throws IOException {
            this.writer.writeContent(byArray, n, n2);
        }

        void endOutput() throws IOException {
            this.writer.writeTrailer(null);
        }

        boolean startInput() throws IOException {
            while (true) {
                this.reader = new MessageReader(HttpClientConnection.this.in, false);
                this.inLine = this.reader.readStartLine();
                this.inHeader = this.reader.readHeader();
                if (this.inLine.status / 100 != 1) {
                    return this.inLine.status / 100 == 2;
                }
                this.reader.readTrailer();
            }
        }

        int read(byte[] byArray, int n, int n2) throws IOException {
            return this.reader.readContent(byArray, n, n2);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
            this.inHeader.merge(this.reader.readTrailer());
            HttpClientConnection.this.analyzePostResponse(this.inLine, this.inHeader);
            this.persist = HttpClientConnection.supportsPersist(this.inLine, this.inHeader);
        }

        void addAckListener(AcknowledgmentSource.Listener listener) {
            throw new UnsupportedOperationException();
        }

        void done(boolean bl) {
            if (bl || !this.persist) {
                HttpClientConnection.this.shutdown(true);
            } else {
                HttpClientConnection.this.markIdle();
            }
        }
    }
}

