/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.logging;

import com.sun.jini.logging.Levels;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogManager
extends java.util.logging.LogManager {
    private Probe probe = null;

    public LogManager() {
        Levels.FAILED.toString();
        Levels.HANDLED.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream inputStream) throws IOException {
        super.readConfiguration(inputStream);
        LogManager logManager = this;
        synchronized (logManager) {
            long l;
            if (this.probe == null && (l = this.getInterval()) > 0L) {
                this.probe = new Probe(l);
                this.probe.start();
            }
        }
    }

    private long getInterval() {
        String string = this.getProperty("com.sun.jini.logging.interval");
        if (string != null) {
            try {
                return Long.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static File getFile() {
        String string = System.getProperty("java.util.logging.config.file");
        if (string != null) {
            return new File(string);
        }
        return new File(System.getProperty("java.home"), "lib" + File.separator + "logging.properties");
    }

    private class Probe
    extends Thread {
        private long interval;
        private File prevFile;
        private long prevModified;

        Probe(long l) {
            super("LogManager config file probe");
            this.setDaemon(true);
            this.interval = l;
            this.prevFile = LogManager.getFile();
            this.prevModified = this.prevFile.lastModified();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Logger logger = Logger.getLogger("com.sun.jini.logging.LogManager");
            try {
                try {}
                catch (InterruptedException interruptedException) {
                    Object var7_7 = null;
                    LogManager logManager3 = LogManager.this;
                    synchronized (logManager3) {
                        LogManager.this.probe = null;
                    }
                    logger.config("logging config file probe terminating");
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                LogManager logManager2 = LogManager.this;
                synchronized (logManager2) {
                    LogManager.this.probe = null;
                }
                logger.config("logging config file probe terminating");
                throw throwable;
            }
            while (this.interval > 0L) {
                Thread.sleep(this.interval);
                File file = LogManager.getFile();
                long l = file.lastModified();
                if (l <= 0L || file.equals(this.prevFile) && l == this.prevModified) continue;
                try {
                    LogManager.this.readConfiguration();
                    this.interval = LogManager.this.getInterval();
                    logger.log(Level.CONFIG, "logging config file reread complete, new interval is {0}", new Long(this.interval));
                }
                catch (Throwable throwable) {
                    logger.log(Level.WARNING, "exception reading logging config file", throwable);
                }
                this.prevFile = file;
                this.prevModified = l;
            }
            Object var7_6 = null;
            LogManager logManager = LogManager.this;
            synchronized (logManager) {
                LogManager.this.probe = null;
            }
            logger.config("logging config file probe terminating");
        }
    }
}

