/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.export.ExportPermission;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.Security;

public abstract class AbstractILFactory
implements InvocationLayerFactory {
    private static final Permission getClassLoaderPermission = new RuntimePermission("getClassLoader");
    private final ClassLoader loader;

    protected AbstractILFactory() {
        this(null);
    }

    protected AbstractILFactory(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    private static Class[] combineInterfaces(Class[] classArray, Class[] classArray2) {
        ArrayList arrayList = new ArrayList(classArray.length + classArray2.length);
        AbstractILFactory.addInterfaces(arrayList, classArray);
        AbstractILFactory.addInterfaces(arrayList, classArray2);
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private static void addInterfaces(ArrayList arrayList, Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            if (clazz == null) {
                throw new NullPointerException("array contains null element");
            }
            if (arrayList.contains(clazz)) continue;
            arrayList.add(clazz);
        }
    }

    protected final ClassLoader getClassLoader() {
        return this.loader;
    }

    protected Class[] getProxyInterfaces(Remote remote) throws ExportException {
        return AbstractILFactory.combineInterfaces(this.getRemoteInterfaces(remote), this.getExtraProxyInterfaces(remote));
    }

    protected Class[] getRemoteInterfaces(Remote remote) throws ExportException {
        if (remote == null) {
            throw new NullPointerException("impl is null");
        }
        try {
            return Util.getRemoteInterfaces(remote.getClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExportException("cannot get proxy interfaces", illegalArgumentException);
        }
    }

    protected Class[] getExtraProxyInterfaces(Remote remote) throws ExportException {
        if (remote == null) {
            throw new NullPointerException("impl is null");
        }
        return new Class[]{RemoteMethodControl.class};
    }

    protected Collection getInvocationDispatcherMethods(Remote remote) throws ExportException {
        Class[] classArray = this.getRemoteInterfaces(remote);
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (int i = classArray.length - 1; i >= 0; --i) {
            Class clazz = classArray[i];
            boolean bl = AbstractILFactory.checkNonPublicInterface(clazz);
            Util.checkPackageAccess(clazz);
            Method[] methodArray = clazz.getMethods();
            for (int j = methodArray.length - 1; j >= 0; --j) {
                final Method method = methodArray[j];
                if (bl) {
                    Security.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            method.setAccessible(true);
                            return null;
                        }
                    });
                }
                hashMap.put(Util.getMethodNameAndDescriptor(method), method);
            }
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(hashMap.values());
        return hashSet;
    }

    private static boolean checkNonPublicInterface(Class clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                String string = "exportRemoteInterface." + clazz.getName();
                securityManager.checkPermission(new ExportPermission(string));
            }
            return true;
        }
        return false;
    }

    protected abstract InvocationHandler createInvocationHandler(Class[] var1, Remote var2, ObjectEndpoint var3) throws ExportException;

    protected abstract InvocationDispatcher createInvocationDispatcher(Collection var1, Remote var2, ServerCapabilities var3) throws ExportException;

    public InvocationLayerFactory.Instances createInstances(Remote remote, ObjectEndpoint objectEndpoint, ServerCapabilities serverCapabilities) throws ExportException {
        Remote remote2;
        ClassLoader classLoader;
        if (remote == null || objectEndpoint == null || serverCapabilities == null) {
            throw new NullPointerException();
        }
        Class[] classArray = this.getProxyInterfaces(remote);
        InvocationHandler invocationHandler = this.createInvocationHandler(classArray, remote, objectEndpoint);
        if (this.loader != null) {
            classLoader = this.loader;
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(getClassLoaderPermission);
            }
            classLoader = remote.getClass().getClassLoader();
        }
        for (int i = 0; i < classArray.length; ++i) {
            Util.checkPackageAccess(classArray[i].getClass());
        }
        try {
            remote2 = (Remote)Proxy.newProxyInstance(classLoader, classArray, invocationHandler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExportException("unable to create proxy", illegalArgumentException);
        }
        InvocationDispatcher invocationDispatcher = this.createInvocationDispatcher(this.getInvocationDispatcherMethods(remote), remote, serverCapabilities);
        return new InvocationLayerFactory.Instances(remote2, invocationDispatcher);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass() == this.getClass() && ((AbstractILFactory)object).loader == this.loader;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }
}

