/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.kerberos;

import com.sun.jini.logging.Levels;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConnectionRelativeTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;
import net.jini.security.AuthenticationPermission;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

class KerberosUtil {
    static final Oid krb5MechOid;
    static final Oid krb5NameType;
    static final InvocationConstraints INTEGRITY_REQUIRED_CONSTRAINTS;
    static final InvocationConstraints INTEGRITY_PREFERRED_CONSTRAINTS;
    private static final boolean[] BOOL_TABLE;
    private static final Map depends;

    private KerberosUtil() {
    }

    static boolean canGetSubject() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AuthPermission("getSubject"));
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean isSupportedConstraintType(InvocationConstraint invocationConstraint) {
        return depends.get(invocationConstraint.getClass()) != null;
    }

    static boolean isSupportableConstraint(InvocationConstraint invocationConstraint) {
        if (invocationConstraint instanceof ConstraintAlternatives) {
            Set set = ((ConstraintAlternatives)invocationConstraint).elements();
            Class<?> clazz = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                InvocationConstraint invocationConstraint2 = (InvocationConstraint)iterator.next();
                if (clazz == null) {
                    clazz = invocationConstraint2.getClass();
                } else if (clazz != invocationConstraint2.getClass()) {
                    return false;
                }
                if (!KerberosUtil.isSupportableConstraint(invocationConstraint2)) continue;
                return true;
            }
            return false;
        }
        if (!KerberosUtil.isSupportedConstraintType(invocationConstraint)) {
            return false;
        }
        if (invocationConstraint instanceof Integrity) {
            return invocationConstraint == Integrity.YES;
        }
        if (invocationConstraint instanceof ClientAuthentication) {
            return invocationConstraint == ClientAuthentication.YES;
        }
        if (invocationConstraint instanceof ServerAuthentication) {
            return invocationConstraint == ServerAuthentication.YES;
        }
        if (invocationConstraint instanceof ClientMinPrincipal) {
            Set set = ((ClientMinPrincipal)invocationConstraint).elements();
            if (set.size() > 1) {
                return false;
            }
            return set.iterator().next() instanceof KerberosPrincipal;
        }
        if (invocationConstraint instanceof ClientMinPrincipalType) {
            Set set = ((ClientMinPrincipalType)invocationConstraint).elements();
            if (set.size() > 1) {
                return false;
            }
            return set.contains(KerberosPrincipal.class);
        }
        if (invocationConstraint instanceof ClientMaxPrincipal) {
            Set set = ((ClientMaxPrincipal)invocationConstraint).elements();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof KerberosPrincipal)) continue;
                return true;
            }
            return false;
        }
        if (invocationConstraint instanceof ClientMaxPrincipalType) {
            Set set = ((ClientMaxPrincipalType)invocationConstraint).elements();
            return set.contains(KerberosPrincipal.class);
        }
        if (invocationConstraint instanceof ServerMinPrincipal) {
            Set set = ((ServerMinPrincipal)invocationConstraint).elements();
            if (set.size() > 1) {
                return false;
            }
            return set.iterator().next() instanceof KerberosPrincipal;
        }
        return true;
    }

    static boolean isSatisfiable(Config config, InvocationConstraint invocationConstraint) {
        if (invocationConstraint instanceof ConstraintAlternatives) {
            Set set = ((ConstraintAlternatives)invocationConstraint).elements();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                InvocationConstraint invocationConstraint2 = (InvocationConstraint)iterator.next();
                if (!KerberosUtil.isSatisfiable(config, invocationConstraint2)) continue;
                return true;
            }
            return false;
        }
        if (!KerberosUtil.isSupportedConstraintType(invocationConstraint)) {
            return false;
        }
        if (invocationConstraint instanceof Integrity) {
            return invocationConstraint == Integrity.YES;
        }
        if (invocationConstraint instanceof Confidentiality) {
            return config.encry == (invocationConstraint == Confidentiality.YES);
        }
        if (invocationConstraint instanceof ClientAuthentication) {
            return invocationConstraint == ClientAuthentication.YES;
        }
        if (invocationConstraint instanceof ServerAuthentication) {
            return invocationConstraint == ServerAuthentication.YES;
        }
        if (invocationConstraint instanceof Delegation) {
            return config.deleg == (invocationConstraint == Delegation.YES);
        }
        if (invocationConstraint instanceof ClientMinPrincipal) {
            Set set = ((ClientMinPrincipal)invocationConstraint).elements();
            if (set.size() > 1) {
                return false;
            }
            return set.contains(config.clientPrincipal);
        }
        if (invocationConstraint instanceof ClientMinPrincipalType) {
            Set set = ((ClientMinPrincipalType)invocationConstraint).elements();
            if (set.size() > 1) {
                return false;
            }
            return set.contains(KerberosPrincipal.class);
        }
        if (invocationConstraint instanceof ClientMaxPrincipal) {
            Set set = ((ClientMaxPrincipal)invocationConstraint).elements();
            return set.contains(config.clientPrincipal);
        }
        if (invocationConstraint instanceof ClientMaxPrincipalType) {
            Set set = ((ClientMaxPrincipalType)invocationConstraint).elements();
            return set.contains(KerberosPrincipal.class);
        }
        if (invocationConstraint instanceof ServerMinPrincipal) {
            Set set = ((ServerMinPrincipal)invocationConstraint).elements();
            if (set.size() > 1) {
                return false;
            }
            return set.contains(config.serverPrincipal);
        }
        return true;
    }

    static boolean collectCpCandidates(InvocationConstraint invocationConstraint, Set set) {
        boolean bl = false;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (invocationConstraint instanceof ConstraintAlternatives) {
            Set set2 = ((ConstraintAlternatives)invocationConstraint).elements();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                Object object;
                Set set3;
                invocationConstraint = (InvocationConstraint)iterator.next();
                if (invocationConstraint instanceof ClientMinPrincipal) {
                    bl = true;
                    set3 = ((ClientMinPrincipal)invocationConstraint).elements();
                    object = set3.iterator().next();
                    if (set3.size() > 1 || !(object instanceof KerberosPrincipal)) continue;
                    hashSet.add(object);
                    continue;
                }
                if (!(invocationConstraint instanceof ClientMaxPrincipal)) continue;
                bl = true;
                set3 = ((ClientMaxPrincipal)invocationConstraint).elements();
                object = set3.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (!(e instanceof KerberosPrincipal)) continue;
                    hashSet.add(e);
                }
            }
        } else if (invocationConstraint instanceof ClientMinPrincipal) {
            bl = true;
            Set set4 = ((ClientMinPrincipal)invocationConstraint).elements();
            Object e = set4.iterator().next();
            if (set4.size() > 1 || !(e instanceof KerberosPrincipal)) {
                return false;
            }
            hashSet.add(e);
        } else if (invocationConstraint instanceof ClientMaxPrincipal) {
            bl = true;
            Set set5 = ((ClientMaxPrincipal)invocationConstraint).elements();
            Iterator iterator = set5.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof KerberosPrincipal)) continue;
                hashSet.add(e);
            }
        }
        if (bl) {
            if (set.size() == 0) {
                if (hashSet.size() > 0) {
                    set.addAll(hashSet);
                    return true;
                }
                return false;
            }
            set.retainAll(hashSet);
            return set.size() > 0;
        }
        return true;
    }

    static void checkAuthPermission(KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Set<KerberosPrincipal> set = Collections.singleton(kerberosPrincipal);
            Set<KerberosPrincipal> set2 = null;
            if (kerberosPrincipal2 != null) {
                set2 = Collections.singleton(kerberosPrincipal2);
            }
            AuthenticationPermission authenticationPermission = new AuthenticationPermission(set, set2, string);
            securityManager.checkPermission(authenticationPermission);
        }
    }

    static void checkAuthPermission(AuthenticationPermission authenticationPermission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(authenticationPermission);
        }
    }

    static boolean containsConstraint(Set set, InvocationConstraint invocationConstraint) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            InvocationConstraint invocationConstraint2 = (InvocationConstraint)iterator.next();
            if (invocationConstraint2 instanceof ConstraintAlternatives) {
                Set set2 = ((ConstraintAlternatives)invocationConstraint2).elements();
                return set2.contains(invocationConstraint);
            }
            if (!invocationConstraint2.equals(invocationConstraint)) continue;
            return true;
        }
        return false;
    }

    static GSSCredential getGSSCredential(Subject subject, final KerberosPrincipal kerberosPrincipal, final GSSManager gSSManager, final int n) throws GSSException {
        try {
            return (GSSCredential)Subject.doAs(subject, new PrivilegedExceptionAction(){

                public Object run() throws GSSException {
                    GSSName gSSName = gSSManager.createName(kerberosPrincipal.getName(), krb5NameType);
                    return gSSManager.createCredential(gSSName, Integer.MAX_VALUE, krb5MechOid, n);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (GSSException)privilegedActionException.getException();
        }
    }

    static void secureThrow(Exception exception, UnsupportedConstraintException unsupportedConstraintException) throws UnsupportedConstraintException {
        if (KerberosUtil.canGetSubject()) {
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            throw (UnsupportedConstraintException)exception;
        }
        throw unsupportedConstraintException;
    }

    static void logThrow(Logger logger, Level level, Class clazz, String string, String string2, Object[] objectArray, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string2);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(clazz.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    static {
        try {
            krb5MechOid = new Oid("1.2.840.113554.1.2.2");
            krb5NameType = new Oid("1.2.840.113554.1.2.2.1");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        INTEGRITY_REQUIRED_CONSTRAINTS = new InvocationConstraints(Integrity.YES, null);
        INTEGRITY_PREFERRED_CONSTRAINTS = new InvocationConstraints(null, Integrity.YES);
        BOOL_TABLE = new boolean[]{false, true};
        depends = new HashMap();
        InvocationConstraint[] invocationConstraintArray = new InvocationConstraint[]{};
        depends.put(ConnectionAbsoluteTime.class, invocationConstraintArray);
        depends.put(ConnectionRelativeTime.class, invocationConstraintArray);
        depends.put(Integrity.class, invocationConstraintArray);
        depends.put(Confidentiality.class, invocationConstraintArray);
        depends.put(ClientAuthentication.class, invocationConstraintArray);
        depends.put(ServerAuthentication.class, invocationConstraintArray);
        invocationConstraintArray = new InvocationConstraint[]{ClientAuthentication.YES};
        depends.put(ClientMinPrincipal.class, invocationConstraintArray);
        depends.put(ClientMinPrincipalType.class, invocationConstraintArray);
        depends.put(ClientMaxPrincipal.class, invocationConstraintArray);
        depends.put(ClientMaxPrincipalType.class, invocationConstraintArray);
        depends.put(Delegation.class, invocationConstraintArray);
        invocationConstraintArray = new InvocationConstraint[]{ServerAuthentication.YES};
        depends.put(ServerMinPrincipal.class, invocationConstraintArray);
    }

    static class SoftCache {
        private final LRUHashMap hash;
        private ReferenceQueue queue = new ReferenceQueue();

        SoftCache() {
            this(Integer.MAX_VALUE, 8);
        }

        SoftCache(int n) {
            this(n, 8);
        }

        SoftCache(int n, int n2) {
            this.hash = new LRUHashMap(n, n2);
        }

        public synchronized Object put(Object object, Object object2) {
            this.processQueue();
            ValueCell valueCell = ValueCell.create(object, object2, this.queue);
            return ValueCell.strip(this.hash.put(object, valueCell), true);
        }

        public synchronized Object get(Object object) {
            this.processQueue();
            return ValueCell.strip(this.hash.get(object), false);
        }

        public synchronized Object remove(Object object) {
            this.processQueue();
            return ValueCell.strip(this.hash.remove(object), true);
        }

        public synchronized void clear() {
            this.processQueue();
            this.hash.clear();
        }

        private void processQueue() {
            ValueCell valueCell;
            while ((valueCell = (ValueCell)this.queue.poll()) != null) {
                if (!valueCell.isValid()) continue;
                this.hash.remove(valueCell.key);
            }
        }

        private static class ValueCell
        extends SoftReference {
            private static Object INVALID_KEY = new Object();
            private Object key;

            private ValueCell(Object object, Object object2, ReferenceQueue referenceQueue) {
                super(object2, referenceQueue);
                this.key = object;
            }

            private static ValueCell create(Object object, Object object2, ReferenceQueue referenceQueue) {
                if (object2 == null) {
                    return null;
                }
                return new ValueCell(object, object2, referenceQueue);
            }

            private static Object strip(Object object, boolean bl) {
                if (object == null) {
                    return null;
                }
                ValueCell valueCell = (ValueCell)object;
                Object t = valueCell.get();
                if (bl) {
                    valueCell.drop();
                }
                return t;
            }

            private boolean isValid() {
                return this.key != INVALID_KEY;
            }

            private void drop() {
                this.clear();
                this.key = INVALID_KEY;
            }
        }

        private class LRUHashMap
        extends LinkedHashMap {
            private int maxCacheSize;

            LRUHashMap(int n, int n2) {
                super(n2, 0.75f, true);
                if (n < 0) {
                    throw new IllegalArgumentException("negative cache size");
                }
                this.maxCacheSize = n;
            }

            protected boolean removeEldestEntry(Map.Entry entry) {
                if (this.size() > this.maxCacheSize) {
                    ValueCell.strip(entry.getValue(), true);
                    return true;
                }
                return false;
            }
        }
    }

    static class ConnectionOutputStream
    extends OutputStream {
        private static final int bufSize = 8000;
        private final byte[] buf = new byte[8000];
        private int curLen = 0;
        private final Connection connection;

        ConnectionOutputStream(Connection connection) {
            this.connection = connection;
        }

        public synchronized void write(int n) throws IOException {
            if (this.curLen == 8000) {
                this.connection.write(this.buf, 0, this.curLen);
                this.curLen = 0;
            }
            this.buf[this.curLen++] = (byte)n;
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.curLen + n2 >= 8000) {
                int n3 = 8000 - this.curLen;
                System.arraycopy(byArray, n, this.buf, this.curLen, n3);
                n += n3;
                n2 -= n3;
                this.connection.write(this.buf, 0, 8000);
                this.curLen = 0;
            }
            while (n2 > 8000) {
                this.connection.write(byArray, n, 8000);
                n += 8000;
                n2 -= 8000;
            }
            System.arraycopy(byArray, n, this.buf, this.curLen, n2);
            this.curLen += n2;
        }

        public synchronized void flush() throws IOException {
            if (this.curLen > 0) {
                this.connection.write(this.buf, 0, this.curLen);
                this.curLen = 0;
            }
            this.connection.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.flush();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.connection.dis.close();
                throw throwable;
            }
            this.connection.dis.close();
        }
    }

    static class ConnectionInputStream
    extends InputStream {
        private byte[] buf = new byte[0];
        private int offset = 0;
        private final Connection connection;

        ConnectionInputStream(Connection connection) {
            this.connection = connection;
        }

        public synchronized int read() throws IOException {
            if (this.offset == this.buf.length) {
                do {
                    this.buf = this.connection.read();
                } while (this.buf.length == 0);
                this.offset = 0;
            }
            return this.buf[this.offset++];
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.offset == this.buf.length) {
                do {
                    this.buf = this.connection.read();
                } while (this.buf.length == 0);
                this.offset = 0;
            }
            int n3 = Math.min(this.buf.length - this.offset, n2);
            System.arraycopy(this.buf, this.offset, byArray, n, n3);
            this.offset += n3;
            return n3;
        }

        public synchronized int available() throws IOException {
            return this.buf.length - this.offset;
        }

        public void close() throws IOException {
            this.connection.dis.close();
        }
    }

    static class Connection {
        protected static final int INTEGRITY_QOP = 2;
        protected static final int PRIVACY_QOP = 0;
        protected final Socket sock;
        protected final String peerHost;
        protected final int peerPort;
        protected DataInputStream dis;
        protected DataOutputStream dos;
        KerberosPrincipal clientPrincipal;
        protected GSSContext gssContext;
        protected boolean doEncryption;
        protected boolean doDelegation;
        protected Logger connectionLogger;

        Connection(Socket socket) throws IOException {
            this.sock = socket;
            this.peerHost = socket.getInetAddress().getHostName();
            this.peerPort = socket.getPort();
            this.dis = new DataInputStream(socket.getInputStream());
            this.dos = new DataOutputStream(socket.getOutputStream());
        }

        public void close() {
            this.connectionLogger.log(Level.FINE, "closing {0}", this);
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(byte[] byArray, int n, int n2) throws IOException {
            MessageProp messageProp = this.doEncryption ? new MessageProp(0, true) : new MessageProp(2, false);
            byte[] byArray2 = null;
            try {
                try {
                    GSSContext gSSContext = this.gssContext;
                    synchronized (gSSContext) {
                        byArray2 = this.gssContext.wrap(byArray, n, n2, messageProp);
                    }
                }
                catch (GSSException gSSException) {
                    IOException iOException = new IOException("Failed to wrap buf into GSS token.");
                    iOException.initCause(gSSException);
                    throw iOException;
                }
                if (this.doEncryption != messageProp.getPrivacy()) {
                    throw new IOException("Returned token encryption property is: " + messageProp.getPrivacy() + ",\nwhile connection " + "encryption requirement is: " + this.doEncryption);
                }
                if (this.connectionLogger.isLoggable(Level.FINEST)) {
                    this.connectionLogger.log(Level.FINEST, "wrapped " + n2 + " bytes (" + (this.doEncryption ? "" : "not ") + "encrypted) " + "into a " + byArray2.length + " bytes token and " + "sending it over the network");
                }
                this.dos.writeInt(byArray2.length);
                this.dos.write(byArray2);
            }
            catch (IOException iOException) {
                if (this.connectionLogger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(this.connectionLogger, Levels.FAILED, this.getClass(), "write", "failed to wrap buf of size {0} into a GSS token,\nconnection is {1},\nthrows ", new Object[]{new Integer(n2), this}, iOException);
                }
                throw iOException;
            }
        }

        void flush() throws IOException {
            this.dos.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] read() throws IOException {
            try {
                byte[] byArray;
                MessageProp messageProp = new MessageProp(0, false);
                byte[] byArray2 = new byte[this.dis.readInt()];
                this.dis.readFully(byArray2);
                try {
                    GSSContext gSSContext = this.gssContext;
                    synchronized (gSSContext) {
                        byArray = this.gssContext.unwrap(byArray2, 0, byArray2.length, messageProp);
                    }
                }
                catch (GSSException gSSException) {
                    IOException iOException = new IOException("Failed to unwrap a GSS token of length " + byArray2.length);
                    iOException.initCause(gSSException);
                    throw iOException;
                }
                this.doEncryption = messageProp.getPrivacy();
                if (this.connectionLogger.isLoggable(Level.FINEST)) {
                    this.connectionLogger.log(Level.FINEST, "received a " + byArray2.length + " bytes token (" + (this.doEncryption ? "" : "not ") + "encrypted), " + byArray.length + " bytes when " + "unwrapped");
                }
                return byArray;
            }
            catch (IOException iOException) {
                if (this.connectionLogger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(this.connectionLogger, Levels.FAILED, this.getClass(), "read", "read fails on connection {0}, throws", new Object[]{this}, iOException);
                }
                throw iOException;
            }
        }
    }

    static final class ConfigIter {
        private final Set clientPrincipals;
        private final KerberosPrincipal serverPrincipal;
        private Iterator cpIter;
        private final boolean canDeleg;
        private int configId;
        private int numConfigs;

        ConfigIter(Set set, KerberosPrincipal kerberosPrincipal, boolean bl) {
            this.clientPrincipals = set;
            this.serverPrincipal = kerberosPrincipal;
            this.canDeleg = bl;
            this.configId = 0;
            this.numConfigs = set.size() * 2;
            if (bl) {
                this.numConfigs *= 2;
            }
        }

        boolean hasNext() {
            return this.configId < this.numConfigs;
        }

        Config next() {
            Config config;
            if (this.configId >= this.numConfigs) {
                throw new NoSuchElementException();
            }
            if (this.configId % this.clientPrincipals.size() == 0) {
                this.cpIter = this.clientPrincipals.iterator();
            }
            KerberosPrincipal kerberosPrincipal = (KerberosPrincipal)this.cpIter.next();
            int n = this.configId / this.clientPrincipals.size() % 2;
            if (this.canDeleg) {
                int n2 = this.configId / this.clientPrincipals.size() / 2;
                config = new Config(kerberosPrincipal, this.serverPrincipal, BOOL_TABLE[n], BOOL_TABLE[n2]);
            } else {
                config = new Config(kerberosPrincipal, this.serverPrincipal, BOOL_TABLE[n], false);
            }
            ++this.configId;
            return config;
        }
    }

    static final class Config {
        KerberosPrincipal clientPrincipal;
        KerberosPrincipal serverPrincipal;
        boolean encry;
        boolean deleg;
        int prefCount;

        Config(KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, boolean bl, boolean bl2) {
            this.clientPrincipal = kerberosPrincipal;
            this.serverPrincipal = kerberosPrincipal2;
            this.encry = bl;
            this.deleg = bl2;
        }

        public String toString() {
            return "Config[clientPrincipal=" + this.clientPrincipal + " serverPrincipal=" + this.serverPrincipal + " encry=" + this.encry + " deleg=" + this.deleg + " prefCount=" + this.prefCount + "]";
        }
    }
}

