/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.tcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.ConnectionRelativeTime;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.RelativeTimeConstraint;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;

class Constraints {
    private static final int NO_SUPPORT = 0;
    private static final int FULL_SUPPORT = 1;
    private static final int PARTIAL_SUPPORT = 2;
    private static final Map supportedValues = new HashMap();
    private static final Map supportedClasses;
    static /* synthetic */ Class class$net$jini$jeri$tcp$Constraints;

    private static int getSupport(InvocationConstraint invocationConstraint) {
        Boolean bl = (Boolean)supportedValues.get(invocationConstraint);
        if (bl == null) {
            bl = (Boolean)supportedClasses.get(invocationConstraint.getClass());
        }
        return bl == null ? 0 : (bl != false ? 2 : 1);
    }

    static InvocationConstraints check(InvocationConstraints invocationConstraints, boolean bl) throws UnsupportedConstraintException {
        return Constraints.distill(invocationConstraints, bl).getUnfulfilledConstraints();
    }

    static Distilled distill(InvocationConstraints invocationConstraints, boolean bl) throws UnsupportedConstraintException {
        return new Distilled(invocationConstraints, bl);
    }

    private Constraints() {
        throw new AssertionError();
    }

    static {
        supportedValues.put(Integrity.NO, Boolean.TRUE);
        supportedValues.put(Confidentiality.NO, Boolean.FALSE);
        supportedValues.put(ClientAuthentication.NO, Boolean.FALSE);
        supportedValues.put(ServerAuthentication.NO, Boolean.FALSE);
        supportedValues.put(Delegation.NO, Boolean.FALSE);
        supportedClasses = new HashMap();
        supportedClasses.put(ConnectionAbsoluteTime.class, Boolean.FALSE);
        supportedClasses.put(ConnectionRelativeTime.class, Boolean.FALSE);
        supportedClasses.put(ClientMaxPrincipal.class, Boolean.FALSE);
        supportedClasses.put(ClientMaxPrincipalType.class, Boolean.FALSE);
        supportedClasses.put(ClientMinPrincipal.class, Boolean.FALSE);
        supportedClasses.put(ClientMinPrincipalType.class, Boolean.FALSE);
        supportedClasses.put(ServerMinPrincipal.class, Boolean.FALSE);
        supportedClasses.put(DelegationAbsoluteTime.class, Boolean.FALSE);
        supportedClasses.put(DelegationRelativeTime.class, Boolean.FALSE);
    }

    static class Distilled {
        private final boolean relativeOK;
        private Collection unfulfilledRequirements = null;
        private Collection unfulfilledPreferences = null;
        private boolean hasConnectDeadline = false;
        private long connectDeadline;
        static final /* synthetic */ boolean $assertionsDisabled;

        Distilled(InvocationConstraints invocationConstraints, boolean bl) throws UnsupportedConstraintException {
            this.relativeOK = bl;
            Iterator iterator = invocationConstraints.requirements().iterator();
            while (iterator.hasNext()) {
                this.addConstraint((InvocationConstraint)iterator.next(), true);
            }
            iterator = invocationConstraints.preferences().iterator();
            while (iterator.hasNext()) {
                this.addConstraint((InvocationConstraint)iterator.next(), false);
            }
        }

        InvocationConstraints getUnfulfilledConstraints() {
            if (this.unfulfilledRequirements == null && this.unfulfilledPreferences == null) {
                return InvocationConstraints.EMPTY;
            }
            return new InvocationConstraints(this.unfulfilledRequirements, this.unfulfilledPreferences);
        }

        boolean hasConnectDeadline() {
            return this.hasConnectDeadline;
        }

        long getConnectDeadline() {
            if (!$assertionsDisabled && !this.hasConnectDeadline) {
                throw new AssertionError();
            }
            return this.connectDeadline;
        }

        private void addConstraint(InvocationConstraint invocationConstraint, boolean bl) throws UnsupportedConstraintException {
            if (!(invocationConstraint instanceof ConstraintAlternatives)) {
                int n = Constraints.getSupport(invocationConstraint);
                if (n == 0 || !this.relativeOK && invocationConstraint instanceof RelativeTimeConstraint) {
                    if (bl) {
                        throw new UnsupportedConstraintException("cannot satisfy constraint: " + invocationConstraint);
                    }
                    return;
                }
                if (n == 2) {
                    if (bl) {
                        if (this.unfulfilledRequirements == null) {
                            this.unfulfilledRequirements = new ArrayList();
                        }
                        this.unfulfilledRequirements.add(invocationConstraint);
                    } else {
                        if (this.unfulfilledPreferences == null) {
                            this.unfulfilledPreferences = new ArrayList();
                        }
                        this.unfulfilledPreferences.add(invocationConstraint);
                    }
                }
                if (invocationConstraint instanceof ConnectionAbsoluteTime) {
                    this.addConnectDeadline(((ConnectionAbsoluteTime)invocationConstraint).getTime());
                }
            } else {
                this.addAlternatives((ConstraintAlternatives)invocationConstraint, bl);
            }
        }

        private void addAlternatives(ConstraintAlternatives constraintAlternatives, boolean bl) throws UnsupportedConstraintException {
            Set set = constraintAlternatives.elements();
            boolean bl2 = false;
            long l = Long.MIN_VALUE;
            ArrayList<InvocationConstraint> arrayList = null;
            boolean bl3 = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
                int n = Constraints.getSupport(invocationConstraint);
                if (n == 0 || !this.relativeOK && invocationConstraint instanceof RelativeTimeConstraint) continue;
                bl2 = true;
                if (!bl3) {
                    if (n == 2) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<InvocationConstraint>();
                        }
                        arrayList.add(invocationConstraint);
                    } else {
                        if (!$assertionsDisabled && n != 1) {
                            throw new AssertionError();
                        }
                        arrayList = null;
                        bl3 = true;
                    }
                }
                if (invocationConstraint instanceof ConnectionAbsoluteTime) {
                    if (!$assertionsDisabled && n != 1) {
                        throw new AssertionError();
                    }
                    l = Math.max(l, ((ConnectionAbsoluteTime)invocationConstraint).getTime());
                    continue;
                }
                l = Long.MAX_VALUE;
            }
            if (!bl2) {
                if (bl) {
                    throw new UnsupportedConstraintException("cannot satisfy constraint: " + constraintAlternatives);
                }
                return;
            }
            if (!bl3 && arrayList != null) {
                if (bl) {
                    if (this.unfulfilledRequirements == null) {
                        this.unfulfilledRequirements = new ArrayList();
                    }
                    this.unfulfilledRequirements.add(ConstraintAlternatives.create(arrayList));
                } else {
                    if (this.unfulfilledPreferences == null) {
                        this.unfulfilledPreferences = new ArrayList();
                    }
                    this.unfulfilledPreferences.add(ConstraintAlternatives.create(arrayList));
                }
            }
            if (l < Long.MAX_VALUE) {
                if (!$assertionsDisabled && l == Long.MIN_VALUE) {
                    throw new AssertionError();
                }
                this.addConnectDeadline(l);
            }
        }

        private void addConnectDeadline(long l) {
            if (!this.hasConnectDeadline) {
                this.hasConnectDeadline = true;
                this.connectDeadline = l;
            } else {
                this.connectDeadline = Math.min(this.connectDeadline, l);
            }
        }

        static {
            $assertionsDisabled = !(class$net$jini$jeri$tcp$Constraints == null ? (class$net$jini$jeri$tcp$Constraints = Constraints.class$("net.jini.jeri.tcp.Constraints")) : class$net$jini$jeri$tcp$Constraints).desiredAssertionStatus();
        }
    }
}

