/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ProjectComponentWithSelection;
import com.mathworks.project.api.SectionComponentWithPropertySupport;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.GlobalVariableList;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeEvent;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputTable;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;

public class GlobalsSection
implements ProjectComponentWithSelection,
SectionComponentWithPropertySupport,
IDPChangeListener {
    static final String PARAM_GLOBALS_TAG = "param.globals";
    static final String GLOBALS_TAG = "Globals";
    private WritableConfiguration fConfig;
    private final PropertyChangeSupport fPropertySupport = new PropertyChangeSupport(this);
    private final GlobalVariableList fGlobals;
    private InputTable fTable;
    private JPanel fPanel;
    private HyperlinkTextLabel fGlobalAddLink;
    private MJLabel fDescription;
    private String fDescriptionTooltip;
    private Component fDescriptionComponent;
    private Component fGlobalsTreeTableComponent;

    public GlobalsSection(WritableConfiguration writableConfiguration) {
        this.fConfig = writableConfiguration;
        this.fGlobals = new GlobalVariableList();
        this.loadGlobals();
        this.fTable = new InputTable((Configuration)this.fConfig, this.fGlobals, (IDPChangeListener)this, new Runnable(){

            @Override
            public void run() {
                GlobalsSection.this.changeEvent();
            }
        });
        this.fDescription = Utilities.createDescriptionComponent("desc.globalVariables");
        this.createGlobalAddLink();
        this.populatePanel();
    }

    private void loadGlobals() {
        try {
            XmlReader xmlReader = this.fConfig.getParamReader(PARAM_GLOBALS_TAG);
            this.fGlobals.setVariables(InputDataProperty.parse(xmlReader, this, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveGlobals() {
        XmlWriter xmlWriter = XmlApi.getInstance().create(GLOBALS_TAG);
        for (InputDataProperty inputDataProperty : this.fGlobals.getVariables()) {
            inputDataProperty.getData(xmlWriter);
        }
        try {
            this.fConfig.setParamAsXml(PARAM_GLOBALS_TAG, XmlApi.getInstance().read(xmlWriter.getXML()));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(exception.getCause());
        }
    }

    private void populatePanel() {
        String string = this.fDescriptionTooltip;
        if (this.fPanel == null) {
            this.fPanel = this.createPanel();
        }
        if (this.fGlobals.isEmpty()) {
            this.fDescriptionTooltip = null;
            this.fDescriptionComponent.setVisible(true);
            this.fGlobalsTreeTableComponent.setVisible(false);
        } else {
            this.fDescriptionTooltip = this.fDescription.getText();
            this.fDescriptionComponent.setVisible(false);
            this.fGlobalsTreeTableComponent.setVisible(true);
        }
        this.fPropertySupport.firePropertyChange("header-tooltip", string, this.fDescriptionTooltip);
    }

    private JPanel createPanel() {
        String string = "p, default:grow, fill:d";
        String string2 = "p, p, 3dlu, p, 3dlu, p";
        FormLayout formLayout = new FormLayout(string, string2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.fDescriptionComponent = panelBuilder.add((Component)this.fDescription, cellConstraints.xyw(1, 1, 3));
        this.fGlobalsTreeTableComponent = panelBuilder.add((Component)this.fTable.getComponent(), cellConstraints.xyw(1, 2, 3));
        panelBuilder.add((Component)this.fGlobalAddLink.getComponent(), cellConstraints.xy(3, 6));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void changeEvent() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GlobalsSection.this.populatePanel();
                GlobalsSection.this.saveGlobals();
            }
        });
    }

    @Override
    public void stateChanged(IDPChangeEvent<?> iDPChangeEvent) {
        this.changeEvent();
    }

    public void dispose() {
        for (InputDataProperty inputDataProperty : this.fGlobals.getVariables()) {
            inputDataProperty.clearChangeListenerAndActiveDialog();
        }
        this.fConfig = null;
    }

    private void createGlobalAddLink() {
        String string = CoderResources.getString("link.addglobal");
        this.fGlobalAddLink = Utilities.createLink(string, "link.addglobal", new Runnable(){

            @Override
            public void run() {
                GlobalsSection.this.fTable.addRootLevelItem();
            }
        });
    }

    public Component getComponent() {
        return this.fPanel;
    }

    public void clearSelection() {
        this.fTable.clearSelection();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getHeaderToolTipText() {
        return this.fDescriptionTooltip;
    }
}

