/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.EntryPoint;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.DimensionSizeCategory;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeEvent;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPClassEnum;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPFieldID;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataPropertyDimSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class InputDataProperty {
    public static final String INPUTS_TAG = "Inputs";
    public static final String NAME_TAG = "Name";
    public static final String CLASS_TAG = "Class";
    public static final String SIZE_TAG = "Size";
    public static final String VALUE_TAG = "Value";
    public static final String INITIAL_VALUE_TAG = "InitialValue";
    public static final String COMPLEX_TAG = "Complex";
    public static final String CONSTANT_TAG = "Constant";
    public static final String FIELD_TAG = "Field";
    public static final String INPUT_TAG = "Input";
    public static final String CSTRUCTNAME_TYPENAME_TAG = "TypeName";
    public static final String CSTRUCTNAME_EXTERN_TAG = "Extern";
    public static final String CSTRUCTNAME_HEADERFILE_TAG = "HeaderFile";
    public static final String CSTRUCTNAME_ALIGNMENT_TAG = "Alignment";
    public static final String NUMERICTYPE_TAG = "numerictype";
    public static final String FIMATH_TAG = "fimath";
    public static final String FIMATHISLOCAL_TAG = "fimathislocal";
    private EntryPoint fEntryPoint;
    private IDPAttributes fAttributes;
    private Vector<InputDataProperty> fFields = new Vector(0);
    private InputDataProperty fParent = null;
    private String fValue = "";
    private String fInitialValue = "";
    private IDPChangeListener fChangeListener = null;

    public InputDataProperty(String string) {
        this.fEntryPoint = null;
        this.fAttributes = new IDPAttributes(string);
    }

    public InputDataProperty(EntryPoint entryPoint, String string) {
        this.fEntryPoint = entryPoint;
        this.fAttributes = new IDPAttributes(string);
    }

    public InputDataProperty(EntryPoint entryPoint, IDPAttributes iDPAttributes) {
        this.fEntryPoint = entryPoint;
        this.fAttributes = iDPAttributes;
    }

    public InputDataProperty(IDPAttributes iDPAttributes) {
        this.fEntryPoint = null;
        this.fAttributes = iDPAttributes;
    }

    public void setChangeListener(IDPChangeListener iDPChangeListener) {
        this.fChangeListener = iDPChangeListener;
    }

    private void clearChangeListener() {
        this.fChangeListener = null;
    }

    public void clearChangeListenerAndActiveDialog() {
        for (InputDataProperty inputDataProperty : this.getChildren()) {
            inputDataProperty.clearChangeListenerAndActiveDialog();
        }
        this.clearChangeListener();
    }

    private <E> void changeEvent(IDPFieldID iDPFieldID, E e, boolean bl) {
        if (bl && this.fChangeListener != null) {
            this.fChangeListener.stateChanged(new IDPChangeEvent<E>(this, iDPFieldID, e));
        }
    }

    public String getName() {
        return this.fAttributes.getName();
    }

    public void setName(String string, boolean bl) {
        String string2 = this.getName();
        if (!string2.equals(string)) {
            if (IDPAttributes.isTilde(string)) {
                this.fAttributes.setName(string);
            } else {
                String string3 = this.isField() ? "field" : "g";
                this.fAttributes.setName(this.uniquifyName(Utilities.sanitizeName(string, string3)));
            }
            this.changeEvent(IDPFieldID.NAME, string2, bl);
        }
    }

    private String uniquifyName(String string) {
        if (this.isField()) {
            int n = 0;
            while (true) {
                boolean bl = true;
                String string2 = n == 0 ? string : string + n;
                for (InputDataProperty inputDataProperty : this.fParent.getChildren()) {
                    if (inputDataProperty == this || !string2.equals(inputDataProperty.getName())) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return string2;
                }
                ++n;
            }
        }
        return string;
    }

    public String getPath() {
        if (this.isField()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getParent().getPath()).append(".").append(this.getName());
            return stringBuilder.toString();
        }
        return this.getName();
    }

    public void setClass(String string, boolean bl) {
        IDPClassEnum iDPClassEnum = this.getClassID();
        if (!string.equals(this.fAttributes.getClassName())) {
            this.fAttributes.setClassName(string);
            this.changeEvent(IDPFieldID.CLASS, iDPClassEnum, bl);
        }
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String string) {
        this.fValue = string == null ? "" : string;
    }

    public String getInitialValue() {
        return this.fInitialValue;
    }

    public void setInitialValue(String string) {
        this.fInitialValue = string == null ? "" : string;
    }

    public boolean hasInitialValue() {
        return !this.fInitialValue.isEmpty();
    }

    public String getDefinition() {
        return this.getDefinition(true);
    }

    public String getDefinition(boolean bl) {
        if (this.isDeferred()) {
            return CoderResources.getString("class.deferred");
        }
        if (this.isUndefined()) {
            return CoderResources.getString("class.undefined");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasInitialValue() && bl) {
            stringBuilder.append("initialized(");
        }
        if (this.isConstant() && bl) {
            stringBuilder.append("constant(");
        }
        if (this.isComplex() && bl) {
            stringBuilder.append("complex(");
        }
        stringBuilder.append(this.getClassName());
        stringBuilder.append("(");
        stringBuilder.append(this.getSizeString());
        stringBuilder.append(")");
        if (this.isComplex() && bl) {
            stringBuilder.append(")");
        }
        if (this.isConstant() && bl) {
            stringBuilder.append(")");
        }
        if (this.hasInitialValue() && bl) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String getClassName() {
        return this.fAttributes.getClassName();
    }

    public IDPClassEnum getClassID() {
        return this.fAttributes.getClassID();
    }

    public void setComplex(Boolean bl, boolean bl2) {
        boolean bl3 = this.fAttributes.isComplex();
        if (bl3 != bl) {
            this.fAttributes.setComplex(bl);
            this.changeEvent(IDPFieldID.COMPLEX, bl3, bl2);
        }
    }

    boolean isComplex() {
        return this.fAttributes.hasComplexness() && this.fAttributes.isComplex();
    }

    public void setConstant(Boolean bl, boolean bl2) {
        boolean bl3 = this.fAttributes.isConstant();
        if (bl3 != bl) {
            this.fAttributes.setConstant(bl);
            this.changeEvent(IDPFieldID.CONSTANT, bl3, bl2);
        }
    }

    public String getCStructNameTypeName() {
        return this.fAttributes.getCStructNameTypeName();
    }

    public void setCStructNameTypeName(String string, boolean bl) {
        String string2 = this.fAttributes.getCStructNameTypeName();
        if (!string.equals(string2)) {
            this.fAttributes.setCStructNameTypeName(string);
            this.changeEvent(IDPFieldID.CSTRUCTNAMETYPENAME, string2, bl);
        }
    }

    public boolean isCStructNameExtern() {
        return this.fAttributes.isCStructNameExtern();
    }

    public void setCStructNameExtern(boolean bl, boolean bl2) {
        boolean bl3 = this.fAttributes.isCStructNameExtern();
        if (bl != bl3) {
            this.fAttributes.setCStructNameExtern(bl);
            this.changeEvent(IDPFieldID.CSTRUCTNAMEEXTERN, bl3, bl2);
        }
    }

    public String getCStructNameHeaderFile() {
        return this.fAttributes.getCStructNameHeaderFile();
    }

    public void setCStructNameHeaderFile(String string, boolean bl) {
        String string2 = this.fAttributes.getCStructNameHeaderFile();
        if (!string.equals(string2)) {
            this.fAttributes.setCStructNameHeaderFile(string);
            this.changeEvent(IDPFieldID.CSTRUCTNAMEHEADERFILE, string2, bl);
        }
    }

    public int getCStructNameAlignment() {
        return this.fAttributes.getCStructNameAlignment();
    }

    public void setCStructNameAlignment(int n, boolean bl) {
        int n2 = this.fAttributes.getCStructNameAlignment();
        if (n != n2) {
            this.fAttributes.setCStructNameAlignment(n);
            this.changeEvent(IDPFieldID.CSTRUCTNAMEALIGNMENT, n2, bl);
        }
    }

    public boolean isLocked() {
        return this.isVarargin() || !this.isFunctionInput() && (this.isConstantDescendant() || this.isConstant() || this.isField() && this.getParent().isLocked());
    }

    private boolean isConstantDescendant() {
        return this.isField() && this.getRoot().isConstant();
    }

    private InputDataProperty getRoot() {
        InputDataProperty inputDataProperty = this;
        while (inputDataProperty.isField()) {
            inputDataProperty = inputDataProperty.getParent();
        }
        return inputDataProperty;
    }

    public boolean isConstant() {
        return this.fAttributes.isConstant();
    }

    public IDPAttributes getAttributes() {
        return new IDPAttributes(this.fAttributes);
    }

    public void setAttributesDirect(IDPAttributes iDPAttributes) {
        IDPAttributes iDPAttributes2 = this.fAttributes;
        this.fAttributes = iDPAttributes;
        this.changeEvent(IDPFieldID.ATTRIBUTES, iDPAttributes2, true);
    }

    public void setAttributes(IDPAttributes iDPAttributes, boolean bl) {
        this.setComplex(iDPAttributes.isComplex(), bl);
    }

    public void setSize(Collection<InputDataPropertyDimSize> collection, boolean bl) {
        String string = this.getSizeString();
        if (!this.fAttributes.dimensionsEqual(collection)) {
            this.fAttributes.replaceDimensions(collection);
            this.changeEvent(IDPFieldID.SIZE, string, bl);
        }
    }

    public void setSize(String string, boolean bl) {
        Collection<InputDataPropertyDimSize> collection = InputDataPropertyDimSize.stringToDimensions(string);
        this.setSize(collection, bl);
    }

    public String getSizeString() {
        return this.fAttributes.getSizeString();
    }

    public static String getSizeString(Iterable<InputDataPropertyDimSize> iterable) {
        return IDPAttributes.getSizeString(iterable);
    }

    public boolean isEmpty() {
        return this.fAttributes.isEmpty();
    }

    public boolean isDeferred() {
        return this.fEntryPoint != null && this.fEntryPoint.isUsePreconditions();
    }

    public boolean isUndefined() {
        return this.fAttributes.isUndefined();
    }

    public boolean isStruct() {
        return this.fAttributes.isStruct();
    }

    public boolean isFixedPoint() {
        return this.fAttributes.isFixedPoint();
    }

    public boolean isEnum() {
        return this.fAttributes.isEnum();
    }

    public boolean hasComplexness() {
        return this.fAttributes.hasComplexness();
    }

    boolean isHierarchical() {
        switch (this.getClassID()) {
            case STRUCT: 
            case FI: 
            case CELL: {
                return true;
            }
            case CHAR: 
            case DOUBLE: 
            case ENUM: 
            case INT16: 
            case INT32: 
            case INT8: 
            case LOGICAL: 
            case SINGLE: 
            case UINT16: 
            case UINT32: 
            case UINT8: {
                break;
            }
        }
        return false;
    }

    public int numChildren() {
        return this.fFields.size();
    }

    public List<InputDataProperty> getChildren() {
        ArrayList<InputDataProperty> arrayList = new ArrayList<InputDataProperty>(this.fFields.size());
        for (InputDataProperty inputDataProperty : this.fFields) {
            arrayList.add(inputDataProperty);
        }
        return arrayList;
    }

    public int getChildIndex(InputDataProperty inputDataProperty) {
        return this.fFields.indexOf(inputDataProperty);
    }

    public boolean isFunctionInput() {
        return this.fParent == null || this.isVararg();
    }

    public boolean isVarargin() {
        return this.isFunctionInput() && this.fAttributes.isVarargin();
    }

    public boolean isVararg() {
        return this.fParent != null && this.fParent.isVarargin();
    }

    public int getFieldIndex(InputDataProperty inputDataProperty) {
        return this.fFields.indexOf(inputDataProperty);
    }

    public int getFieldIndex() {
        return this.fParent != null ? this.fParent.getFieldIndex(this) : -1;
    }

    public boolean isField() {
        return this.fParent != null && this.fParent.isStruct();
    }

    public void setParent(InputDataProperty inputDataProperty) {
        this.fParent = inputDataProperty;
    }

    public InputDataProperty getParent() {
        return this.fParent;
    }

    public boolean hasParent() {
        return this.fParent != null;
    }

    public void addField(InputDataProperty inputDataProperty) {
        inputDataProperty.setParent(this);
        this.fFields.addElement(inputDataProperty);
    }

    public void insertField(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2) {
        this.insertField(this.fFields.indexOf(inputDataProperty) + 1, inputDataProperty2);
    }

    public void insertField(int n, InputDataProperty inputDataProperty) {
        inputDataProperty.setParent(this);
        this.fFields.add(n, inputDataProperty);
    }

    public void setVarargName(int n) {
        this.fAttributes.setVarargName(n);
    }

    public void addVararg(InputDataProperty inputDataProperty) {
        this.addField(inputDataProperty);
        this.adjustVararginSize();
    }

    public void addVararg(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2) {
        this.insertField(inputDataProperty, inputDataProperty2);
        this.adjustVararginSize();
    }

    public void delVararg(InputDataProperty inputDataProperty) {
        this.delField(inputDataProperty);
        for (int i = this.fFields.indexOf(inputDataProperty) + 1; i < this.fFields.size(); ++i) {
            InputDataProperty inputDataProperty2 = this.fFields.get(i);
            inputDataProperty2.setVarargName(i + 1);
        }
        this.adjustVararginSize();
    }

    private void adjustVararginSize() {
        ArrayList<InputDataPropertyDimSize> arrayList = new ArrayList<InputDataPropertyDimSize>(2);
        arrayList.add(0, new InputDataPropertyDimSize());
        arrayList.add(1, new InputDataPropertyDimSize(this.fFields.size(), DimensionSizeCategory.FIXED));
        this.fAttributes.replaceDimensions(arrayList);
    }

    public void delField(InputDataProperty inputDataProperty) {
        inputDataProperty.clearChangeListener();
        this.fFields.remove(inputDataProperty);
        if (inputDataProperty.isStruct()) {
            for (InputDataProperty inputDataProperty2 : inputDataProperty.getChildren()) {
                inputDataProperty.delField(inputDataProperty2);
            }
        }
    }

    public void replaceField(InputDataProperty inputDataProperty, InputDataProperty inputDataProperty2) {
        int n = this.fFields.indexOf(inputDataProperty);
        this.delField(inputDataProperty);
        this.insertField(n, inputDataProperty2);
    }

    public String nextVararginName() {
        int n = this.fFields.size() + 1;
        return "varargin{" + n + "}";
    }

    public String nextVararginName(InputDataProperty inputDataProperty) {
        int n = this.fFields.indexOf(inputDataProperty);
        for (int i = n + 1; i < this.fFields.size(); ++i) {
            InputDataProperty inputDataProperty2 = this.fFields.get(i);
            inputDataProperty2.setVarargName(i + 2);
        }
        return "varargin{" + (n + 2) + "}";
    }

    public String nextFieldName(String string) {
        int n = 1;
        while (true) {
            boolean bl = true;
            String string2 = string + n;
            for (InputDataProperty inputDataProperty : this.fFields) {
                if (!string2.equals(inputDataProperty.getName())) continue;
                bl = false;
                break;
            }
            if (bl) {
                return string2;
            }
            ++n;
        }
    }

    public void getData(XmlWriter xmlWriter) {
        XmlWriter xmlWriter2 = xmlWriter.createElement(this.isField() || this.isVararg() ? FIELD_TAG : INPUT_TAG);
        xmlWriter2.writeAttribute(NAME_TAG, (Object)this.getName());
        xmlWriter2.writeText(CLASS_TAG, new Object[]{this.getClassName()});
        xmlWriter2.writeText(SIZE_TAG, new Object[]{this.getSizeString()});
        xmlWriter2.writeText(VALUE_TAG, new Object[]{this.getValue()});
        xmlWriter2.writeText(INITIAL_VALUE_TAG, new Object[]{this.getInitialValue()});
        if (this.hasComplexness()) {
            xmlWriter2.writeText(COMPLEX_TAG, new Object[]{this.isComplex()});
        }
        if (this.isConstant()) {
            xmlWriter2.writeText(CONSTANT_TAG, new Object[]{this.isConstant()});
        }
        if (this.isFixedPoint() && IDPAttributes.supportsFixedPoint()) {
            this.fAttributes.getNumericType().getData(xmlWriter2.createElement(NUMERICTYPE_TAG));
            boolean bl = this.fAttributes.getFimath().getFimathIsLocal();
            xmlWriter2.writeText(FIMATHISLOCAL_TAG, new Object[]{bl});
            if (bl) {
                this.fAttributes.getFimath().getData(xmlWriter2.createElement(FIMATH_TAG));
            }
        }
        if (this.isStruct()) {
            xmlWriter2.writeText(CSTRUCTNAME_TYPENAME_TAG, new Object[]{this.getCStructNameTypeName()});
            xmlWriter2.writeText(CSTRUCTNAME_EXTERN_TAG, new Object[]{this.isCStructNameExtern()});
            xmlWriter2.writeText(CSTRUCTNAME_HEADERFILE_TAG, new Object[]{this.getCStructNameHeaderFile()});
            xmlWriter2.writeText(CSTRUCTNAME_ALIGNMENT_TAG, new Object[]{this.getCStructNameAlignment()});
        }
        if (this.isStruct() || this.isVarargin()) {
            for (InputDataProperty inputDataProperty : this.fFields) {
                inputDataProperty.getData(xmlWriter2);
            }
        }
    }

    private void setStructData(XmlReader xmlReader) {
        String string;
        String string2;
        String string3;
        String string4;
        XmlReader xmlReader2 = xmlReader.getChild(new String[]{CSTRUCTNAME_TYPENAME_TAG});
        if (xmlReader2 != null && (string4 = xmlReader2.readText()) != null) {
            this.setCStructNameTypeName(string4, false);
        }
        if ((string4 = xmlReader.getChild(new String[]{CSTRUCTNAME_EXTERN_TAG})) != null && (string3 = string4.readText()) != null) {
            this.setCStructNameExtern(Boolean.parseBoolean(string3), false);
        }
        if ((string3 = xmlReader.getChild(new String[]{CSTRUCTNAME_HEADERFILE_TAG})) != null && (string2 = string3.readText()) != null) {
            this.setCStructNameHeaderFile(string2, false);
        }
        if ((string2 = xmlReader.getChild(new String[]{CSTRUCTNAME_ALIGNMENT_TAG})) != null && (string = string2.readText()) != null) {
            this.setCStructNameAlignment(Integer.parseInt(string), false);
        }
    }

    private void setFixedPointData(XmlReader xmlReader) {
        if (!IDPAttributes.supportsFixedPoint()) {
            IDPAttributes.reportUnsupportedFixedPoint();
            return;
        }
        Utilities.setPropertyValues(xmlReader.getChild(new String[]{FIMATH_TAG}), this.fAttributes.getFimath());
        this.fAttributes.getFimath().setFimathIsLocal(Boolean.parseBoolean(xmlReader.getChild(new String[]{FIMATHISLOCAL_TAG}).readText()));
        Utilities.setPropertyValues(xmlReader.getChild(new String[]{NUMERICTYPE_TAG}), this.fAttributes.getNumericType());
    }

    public EntryPoint getEntryPoint() {
        return this.fEntryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.fEntryPoint = entryPoint;
    }

    public static InputDataProperty createInputDataProperty(XmlReader xmlReader, final IDPChangeListener iDPChangeListener, final EntryPoint entryPoint) {
        Object object;
        XmlReader xmlReader2;
        String string = xmlReader.readAttribute(NAME_TAG);
        String string2 = xmlReader.getChild(new String[]{CLASS_TAG}).readText();
        final InputDataProperty inputDataProperty = new InputDataProperty(entryPoint, string);
        XmlReader xmlReader3 = xmlReader.getChild(new String[]{VALUE_TAG});
        if (xmlReader3 != null) {
            inputDataProperty.setValue(xmlReader3.readText());
        }
        if ((xmlReader2 = xmlReader.getChild(new String[]{INITIAL_VALUE_TAG})) != null) {
            inputDataProperty.setInitialValue(xmlReader2.readText());
        }
        inputDataProperty.setClass(string2, false);
        String string3 = xmlReader.getChild(new String[]{SIZE_TAG}).readText();
        inputDataProperty.setSize(string3, false);
        if (inputDataProperty.hasComplexness()) {
            object = xmlReader.getChild(new String[]{COMPLEX_TAG}).readText();
            inputDataProperty.setComplex(Boolean.parseBoolean((String)object), false);
        }
        if ((object = xmlReader.getChild(new String[]{CONSTANT_TAG})) != null) {
            inputDataProperty.setConstant(Boolean.parseBoolean(object.readText()), false);
        }
        if (inputDataProperty.isStruct()) {
            inputDataProperty.setStructData(xmlReader);
        }
        if (inputDataProperty.isFixedPoint()) {
            inputDataProperty.setFixedPointData(xmlReader);
        }
        xmlReader.loop(new XmlLooper(){

            public void iterate(XmlReader xmlReader) {
                InputDataProperty inputDataProperty2 = InputDataProperty.createInputDataProperty(xmlReader, iDPChangeListener, entryPoint);
                if (inputDataProperty.isStruct()) {
                    inputDataProperty.addField(inputDataProperty2);
                } else {
                    inputDataProperty.addVararg(inputDataProperty2);
                }
            }
        }, new String[]{FIELD_TAG});
        inputDataProperty.setChangeListener(iDPChangeListener);
        return inputDataProperty;
    }

    public static List<InputDataProperty> parse(XmlReader xmlReader, final IDPChangeListener iDPChangeListener, final EntryPoint entryPoint) {
        final ArrayList<InputDataProperty> arrayList = new ArrayList<InputDataProperty>();
        xmlReader.loop(new XmlLooper(){

            public void iterate(XmlReader xmlReader) {
                InputDataProperty inputDataProperty = InputDataProperty.createInputDataProperty(xmlReader, iDPChangeListener, entryPoint);
                arrayList.add(inputDataProperty);
            }
        }, new String[0]);
        return arrayList;
    }

    public static List<InputDataProperty> parse(XmlReader xmlReader) {
        return InputDataProperty.parse(xmlReader, null, null);
    }

    public static InputDataProperty createInputDataProperty(XmlReader xmlReader) {
        return InputDataProperty.createInputDataProperty(xmlReader, null, null);
    }
}

