/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.toolbox.coder.plugin.workflow.ProposeTypesWidget;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesListener;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesModel;
import com.mathworks.toolbox.coder.plugin.workflow.VerifyCodeMatlabCommand;
import java.io.File;

public final class ProposeTypesCommand
implements Command {
    private static final Matlab MATLAB = new Matlab();
    private final WorkflowStep fStep;
    private Command fMatlabCommand;
    private Configuration fConfiguration;
    private boolean fCanceled;

    public ProposeTypesCommand(File file, ReadableConfiguration readableConfiguration, XmlReader xmlReader) {
        this.fConfiguration = (Configuration)readableConfiguration;
        this.fStep = this.fConfiguration.getTarget().getWorkflow().getStepByKey("category.workflow.proposefixpttypes");
        this.fMatlabCommand = new VerifyCodeMatlabCommand("emlhdlcoder.WorkFlow.Manager.instance.wfa_proposeFixedPointTypes");
    }

    public void execute(final CommandStatus commandStatus) {
        for (ProposedTypesListener proposedTypesListener : ProposeTypesWidget.getWidgetList()) {
            proposedTypesListener.notifyLoading();
        }
        this.fMatlabCommand.execute(commandStatus);
        MATLAB.feval("eval", new Object[]{"emlhdlcoder.WorkFlow.Manager.instance.wfa_getProposedTypesReport"}, 1, new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0) {
                    Object object = matlabEvent.getResult();
                    if (!(object instanceof String)) {
                        if (object instanceof Object[]) {
                            Object[] objectArray = (Object[])object;
                            ProposedTypesModel proposedTypesModel = ProposeTypesCommand.this.constructProposeTypesMap(objectArray);
                            for (ProposedTypesListener proposedTypesListener : ProposeTypesWidget.getWidgetList()) {
                                proposedTypesListener.updateData(proposedTypesModel);
                            }
                        }
                    } else {
                        String string = (String)object;
                        commandStatus.printOutputLine(string);
                    }
                    commandStatus.finished();
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!ProposeTypesCommand.this.fCanceled) {
                                WorkflowDialog.getInstance().getOutputModelForStep(ProposeTypesCommand.this.fStep).setSelectedTabIndex(1);
                            }
                        }
                    });
                } else {
                    Object object = matlabEvent.getResult();
                    if (object != null) {
                        commandStatus.printErrorLine(object.toString());
                    }
                    commandStatus.failed(new CommandExecutionException((Command)ProposeTypesCommand.this));
                }
            }
        });
    }

    public void cancel() {
        this.fCanceled = true;
    }

    public String toString() {
        return this.fMatlabCommand.toString();
    }

    private ProposedTypesModel constructProposeTypesMap(Object[] objectArray) {
        ProposedTypesModel proposedTypesModel = null;
        for (Object object : objectArray) {
            Object[] objectArray2 = (Object[])object;
            String string = (String)objectArray2[0];
            for (int i = 1; i < objectArray2.length; ++i) {
                Object[] objectArray3 = (Object[])objectArray2[i];
                Object[] objectArray4 = (Object[])objectArray3[0];
                Object[] objectArray5 = (Object[])((Object[])objectArray3[1])[0];
                assert (objectArray4.length == objectArray5.length);
                if (proposedTypesModel == null) {
                    proposedTypesModel = new ProposedTypesModel(this.fConfiguration, objectArray4);
                }
                String string2 = objectArray5[0].toString();
                for (int j = 0; j < objectArray4.length; ++j) {
                    Object object2 = objectArray5[j];
                    String string3 = object2.toString();
                    if (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true")) {
                        object2 = Boolean.TRUE;
                    } else if (string3.equalsIgnoreCase("no") || string3.equalsIgnoreCase("false")) {
                        object2 = Boolean.FALSE;
                    } else {
                        try {
                            object2 = Double.parseDouble(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            object2 = string3;
                        }
                    }
                    proposedTypesModel.setProposedTypeData(string, string2, objectArray4[j].toString(), object2);
                }
            }
        }
        return proposedTypesModel;
    }
}

