/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.AbstractFileList;
import com.mathworks.mlwidgets.explorer.model.DefaultRecursiveSearchList;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.toolbox.coder.screener.ImpactModelBuilder;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Pair;
import com.mathworks.util.Predicate;
import com.mathworks.util.tree.Tree;
import com.mathworks.widgets.text.mcode.MTree;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DependencyFileSystem
implements FileSystem {
    private final Map<FileLocation, FileLocation> fDependencyNodeToLocation = new HashMap<FileLocation, FileLocation>();

    DependencyFileSystem(FileSystemEntry fileSystemEntry) {
        this.fDependencyNodeToLocation.put(FileLocation.ROOT, fileSystemEntry.getLocation());
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        return this.wrap(fileLocation, RealFileSystem.getInstance().getEntry(this.getLocationOrThrowException(fileLocation)));
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        return RealFileSystem.getInstance().getInputStream(this.getLocationOrThrowException(fileLocation));
    }

    public boolean exists(FileLocation fileLocation) {
        FileLocation fileLocation2 = this.fDependencyNodeToLocation.get(fileLocation);
        return fileLocation2 != null && RealFileSystem.getInstance().exists(fileLocation2);
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        return RealFileSystem.getInstance().followShortcutOrLink(this.unwrap(fileSystemEntry));
    }

    public DependencyFileList getList(FileLocation fileLocation) throws IOException {
        return new DependencyFileList(fileLocation);
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        return new DefaultRecursiveSearchList((FileSystem)this, this.getEntry(fileLocation), searchCriteria, predicate);
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        return true;
    }

    public FileSystemTransaction createTransaction() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String encodeName(String string) {
        return RealFileSystem.getInstance().encodeName(string);
    }

    public String decodeName(String string) {
        return RealFileSystem.getInstance().decodeName(string);
    }

    private FileLocation getLocationOrThrowException(FileLocation fileLocation) throws IOException {
        FileLocation fileLocation2 = this.getLocation(fileLocation);
        if (fileLocation2 == null) {
            throw new IOException("Location does not exist in dependency tree: " + fileLocation2);
        }
        return fileLocation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLocation getLocation(FileLocation fileLocation) {
        Map<FileLocation, FileLocation> map = this.fDependencyNodeToLocation;
        synchronized (map) {
            return this.fDependencyNodeToLocation.get(fileLocation);
        }
    }

    public FileLocation getRealLocationForMountedLocation(FileLocation fileLocation) {
        FileLocation fileLocation2 = this.getLocation(FileLocation.ROOT);
        if (fileLocation.hasPrefix(fileLocation2)) {
            FileLocation fileLocation3 = fileLocation.stripPrefix(fileLocation2);
            return this.getLocation(fileLocation3);
        }
        return this.getLocation(fileLocation);
    }

    private FileSystemEntry wrap(FileLocation fileLocation, FileSystemEntry fileSystemEntry) {
        return new FileSystemEntry((FileSystem)this, fileLocation, false, true, fileSystemEntry.getSize(), fileSystemEntry.getDateModified().getTime(), fileSystemEntry.getMode());
    }

    private FileSystemEntry unwrap(FileSystemEntry fileSystemEntry) {
        return new FileSystemEntry(RealFileSystem.getInstance(), this.getLocation(fileSystemEntry.getLocation()), true, false, fileSystemEntry.getSize(), fileSystemEntry.getDateModified().getTime(), fileSystemEntry.getMode());
    }

    public static FileLocation getToolboxRoot(String string) {
        File file = new File(string);
        while (!file.getParentFile().getName().equals("toolbox")) {
            file = file.getParentFile();
        }
        return new FileLocation(file);
    }

    public static boolean isInToolbox(String string) {
        FileLocation fileLocation = new FileLocation(Matlab.matlabRoot() + File.separator + "toolbox");
        return new FileLocation(string).hasPrefix(fileLocation);
    }

    private static String getSourceFunctionName(MTree.Node node) {
        while (node.getType() != MTree.NodeType.FUNCTION && node != MTree.NULL_NODE) {
            node = node.getParent();
        }
        if (node.getType() == MTree.NodeType.FUNCTION) {
            return node.getFunctionName().getText();
        }
        return null;
    }

    public class DependencyFileList
    extends AbstractFileList {
        private final FileLocation fDependencyNode;

        DependencyFileList(FileLocation fileLocation) throws IOException {
            super((FileSystem)DependencyFileSystem.this, fileLocation);
            this.fDependencyNode = fileLocation;
        }

        public boolean isEmpty() throws IOException {
            FileLocation fileLocation = DependencyFileSystem.this.getLocation(this.fDependencyNode);
            if (DependencyFileSystem.isInToolbox(fileLocation.toString())) {
                return true;
            }
            MTree mTree = MTree.parse((File)fileLocation.toFile(), (boolean)true);
            List list = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CALL, MTree.NodeType.DOT});
            if (list.isEmpty()) {
                List list2 = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CEXPR});
                for (MTree.Node node : list2) {
                    if (node.getRight().getType() != MTree.NodeType.LT) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
            this.read(asyncReceiver, false);
        }

        public void readFunctions(AsyncReceiver<Call> asyncReceiver) throws IOException {
            this.read(asyncReceiver, true);
        }

        private boolean send(String string, String string2, FileSystemEntry fileSystemEntry, boolean bl, AsyncReceiver asyncReceiver) {
            if (bl) {
                return asyncReceiver.receive((Object)new Call(string, string2, fileSystemEntry));
            }
            return asyncReceiver.receive((Object)fileSystemEntry);
        }

        public void read(final AsyncReceiver asyncReceiver, final boolean bl) throws IOException {
            MTree.Node node2;
            final FileLocation fileLocation = DependencyFileSystem.this.getLocation(this.fDependencyNode);
            final String string = fileLocation.getNameBeforeDot();
            if (DependencyFileSystem.isInToolbox(fileLocation.toString())) {
                asyncReceiver.finished();
                return;
            }
            MTree mTree = MTree.parse((File)fileLocation.toFile(), (boolean)true);
            List list = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CALL});
            final LinkedList<Pair> linkedList = new LinkedList<Pair>();
            for (MTree.Node node2 : list) {
                if (!node2.getLeft().isTextSupported()) continue;
                linkedList.add(new Pair((Object)DependencyFileSystem.getSourceFunctionName(node2), (Object)node2.getLeft().getText()));
            }
            Tree tree = mTree.findAsTree(new MTree.NodeType[]{MTree.NodeType.DOT, MTree.NodeType.ID, MTree.NodeType.FIELD});
            node2 = (MTree.Node)tree.getRoot();
            int n = tree.getChildCount((Object)node2);
            for (int i = 0; i < n; ++i) {
                MTree.Node node3 = (MTree.Node)tree.getChild((Object)node2, i);
                if (node3.getType() != MTree.NodeType.DOT) continue;
                linkedList.add(new Pair((Object)DependencyFileSystem.getSourceFunctionName(node3), (Object)ImpactModelBuilder.assembleQualifiedName(node3)));
            }
            for (MTree.Node node3 : mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.CEXPR})) {
                if (node3.getRight().getType() != MTree.NodeType.LT || node3.getRight().getRight() == MTree.NULL_NODE || !node3.getRight().getRight().isTextSupported() || node3.getRight().getRight().getText().equalsIgnoreCase("handle")) continue;
                linkedList.add(new Pair(null, (Object)node3.getRight().getRight().getText()));
            }
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HashSet<FileLocation> hashSet = new HashSet<FileLocation>();
                        String string3 = string;
                        FileLocation fileLocation4 = fileLocation;
                        for (Pair pair : linkedList) {
                            FileLocation fileLocation2;
                            Object object = null;
                            while (true) {
                                try {
                                    object = Matlab.mtFeval((String)"which", (Object[])new Object[]{pair.getSecond(), "in", string3}, (int)1);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (object == null || !((String)object).isEmpty() || fileLocation4.getParent() == null || !fileLocation4.getParent().getName().startsWith("+")) break;
                                fileLocation4 = fileLocation4.getParent();
                                string3 = fileLocation4.getNameBeforeDot().substring(1) + "." + string3;
                            }
                            if (object == null || !(object instanceof String) || ((String)object).length() == 0) continue;
                            String string2 = (String)object;
                            if (string2.startsWith("built-in")) {
                                string2 = string2.substring("built-in (".length(), string2.length() - 1) + ".m";
                            }
                            if (!hashSet.add(fileLocation2 = new FileLocation(string2))) continue;
                            FileLocation fileLocation3 = new FileLocation(DependencyFileList.this.fDependencyNode, fileLocation2.getName());
                            Map map = DependencyFileSystem.this.fDependencyNodeToLocation;
                            synchronized (map) {
                                DependencyFileSystem.this.fDependencyNodeToLocation.put(fileLocation3, fileLocation2);
                            }
                            try {
                                map = DependencyFileSystem.this.wrap(fileLocation3, RealFileSystem.getInstance().getEntry(fileLocation2));
                                if (DependencyFileList.this.send((String)pair.getFirst(), (String)pair.getSecond(), (FileSystemEntry)map, bl, asyncReceiver)) continue;
                            }
                            catch (IOException iOException) {
                                if (!DependencyFileSystem.isInToolbox(string2)) continue;
                                FileSystemEntry fileSystemEntry = new FileSystemEntry(RealFileSystem.getInstance(), fileLocation2, false, false, 0L, 0L, 0L);
                                if (DependencyFileList.this.send((String)pair.getFirst(), (String)pair.getSecond(), DependencyFileSystem.this.wrap(fileLocation3, fileSystemEntry), bl, asyncReceiver)) continue;
                            }
                            break;
                        }
                    }
                    finally {
                        asyncReceiver.finished();
                    }
                }
            };
            if (NativeMatlab.nativeIsMatlabThread()) {
                runnable.run();
            } else {
                Matlab.whenAtPrompt((Runnable)runnable);
            }
        }
    }

    public final class Call {
        private final String fSourceFunctionName;
        private final String fFunctionName;
        private final FileSystemEntry fEntry;

        public Call(String string, String string2, FileSystemEntry fileSystemEntry) {
            this.fSourceFunctionName = string;
            this.fFunctionName = string2;
            this.fEntry = fileSystemEntry;
        }

        public String getSourceFunctionName() {
            return this.fSourceFunctionName;
        }

        public String getFunctionName() {
            return this.fFunctionName;
        }

        public FileSystemEntry getEntry() {
            return this.fEntry;
        }
    }
}

