/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.screener.ProjectScreenerModel;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.toolbox.coder.screener.ScreenerReportDialog;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ProjectScreenerBar {
    private final MJPanel fComponent;
    private final ProjectScreenerModel fModel;
    private Window fCurrentWindow;
    private static final Color[] UPPER_LEFT = new Color[]{null, new Color(255, 196, 196), new Color(255, 196, 196), new Color(255, 196, 196), new Color(255, 196, 196), new Color(204, 242, 204)};
    private static final Color[] LOWER_RIGHT = new Color[]{null, new Color(255, 76, 76), new Color(255, 76, 76), new Color(255, 76, 76), new Color(255, 76, 76), new Color(76, 210, 76)};

    public ProjectScreenerBar(Configuration configuration) {
        this.fModel = new ProjectScreenerModel(configuration);
        this.fModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProjectScreenerBar.this.update();
            }
        });
        this.fComponent = new Panel();
        this.fComponent.setBackground(new Color(255, 255, 225));
        this.fComponent.setOpaque(true);
        this.update();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void dispose() {
        this.fModel.dispose();
    }

    private void update() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ProjectScreenerBar.this.fModel.updateReportAndRun(new Runnable(){

                            @Override
                            public void run() {
                                if (!SwingUtilities.isEventDispatchThread()) {
                                    SwingUtilities.invokeLater(this);
                                    return;
                                }
                                if (ProjectScreenerBar.this.fCurrentWindow != null) {
                                    ProjectScreenerBar.this.fCurrentWindow.dispose();
                                }
                                ProjectScreenerBar.this.fCurrentWindow = ScreenerReportDialog.show(CoderResources.getString("screener.project.title"), ProjectScreenerBar.this.fModel.getReportModel());
                            }
                        });
                    }
                };
                ProjectScreenerBar.this.fComponent.removeAll();
                ProjectScreenerBar.this.fComponent.setBorder(null);
                ScreenerReportModel screenerReportModel = ProjectScreenerBar.this.fModel.getReportModel();
                if (ProjectScreenerBar.this.fModel.hasInvisibleEntryPoint() || screenerReportModel != null && screenerReportModel.getScore().getScore() < 5) {
                    HyperlinkTextLabel hyperlinkTextLabel;
                    if (ProjectScreenerBar.this.fModel.hasInvisibleEntryPoint()) {
                        hyperlinkTextLabel = Utilities.createLink(CoderResources.getString("screener.bar.path.problem"), "link.screener", new Runnable(){

                            @Override
                            public void run() {
                                Target target = ProjectGUI.getInstance().getCurrentProject().getConfiguration().getTarget();
                                String string = PluginManager.resolveHelpMapPath((String)target.getHelpMapPath());
                                MLHelpServices.cshDisplayTopic((Object)ProjectScreenerBar.this.fComponent, (String)string, (String)"help_link_screener_file_resolution");
                            }
                        });
                        hyperlinkTextLabel.setRowCount(2);
                        hyperlinkTextLabel.getComponent().setMinimumSize(new Dimension((int)hyperlinkTextLabel.getComponent().getPreferredSize().getWidth(), (int)hyperlinkTextLabel.getComponent().getPreferredSize().getHeight() * 2));
                        hyperlinkTextLabel.getComponent().setPreferredSize(hyperlinkTextLabel.getComponent().getMinimumSize());
                    } else {
                        hyperlinkTextLabel = Utilities.createLink(CoderResources.getString("screener.bar.warning"), "link.screener", runnable);
                    }
                    MJLabel mJLabel = new MJLabel(ProjectScreenerBar.createStatusIcon(screenerReportModel));
                    if (screenerReportModel != null) {
                        mJLabel.setToolTipText(ProjectScreenerBar.createToolTipText(screenerReportModel));
                    }
                    mJLabel.setVerticalAlignment(0);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.fill = 0;
                    if (ProjectScreenerBar.this.fModel.hasInvisibleEntryPoint()) {
                        gridBagConstraints.anchor = 18;
                        gridBagConstraints.insets = new Insets(4, 3, 4, 3);
                    } else {
                        gridBagConstraints.anchor = 17;
                        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
                    }
                    ProjectScreenerBar.this.fComponent.add((Component)mJLabel, (Object)gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    if (ProjectScreenerBar.this.fModel.hasInvisibleEntryPoint()) {
                        gridBagConstraints.anchor = 17;
                        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
                    }
                    ProjectScreenerBar.this.fComponent.add((Component)hyperlinkTextLabel.getComponent(), (Object)gridBagConstraints);
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridwidth = 2;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                    ProjectScreenerBar.this.fComponent.add((Component)new MJPanel(){

                        public Dimension getPreferredSize() {
                            return new Dimension(1, 6);
                        }
                    }, (Object)gridBagConstraints);
                }
                ProjectScreenerBar.this.fComponent.revalidate();
                ProjectScreenerBar.this.fComponent.repaint();
            }
        });
    }

    private static Icon createStatusIcon(ScreenerReportModel screenerReportModel) {
        BufferedImage bufferedImage = new BufferedImage(12, 12, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        int n = screenerReportModel == null ? 1 : screenerReportModel.getScore().getScore();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, UPPER_LEFT[n], 12.0f, 12.0f, LOWER_RIGHT[n]));
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 11.0, 11.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(double_);
        graphics2D.setColor(new Color(128, 128, 128));
        graphics2D.draw(double_);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private static String createToolTipText(ScreenerReportModel screenerReportModel) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<html>The following issues were detected:<br>");
        for (ScreenerProblemType screenerProblemType : screenerReportModel.getProblemsByImpact()) {
            printWriter.println("  - " + CoderResources.getString("screener.problem." + StringUtils.upperCaseToCamelCase((String)screenerProblemType.toString(), (boolean)false)) + "<br>");
        }
        printWriter.println("<br>Click the link to see more details.</html>");
        printWriter.close();
        return stringWriter.toString();
    }

    private class Panel
    extends MJPanel
    implements ExplicitColorAndFontProvider {
        Panel() {
            super((LayoutManager)new GridBagLayout());
        }
    }
}

