/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlab.api.explorer;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.util.NativeJava;
import java.util.Date;

public final class FileSystemEntry {
    private final FileSystem fSystem;
    private final FileLocation fLocation;
    private final long fSize;
    private final long fDateModified;
    private final long fMode;
    private final boolean fFolder;
    private final boolean fReal;
    private final String fName;

    public FileSystemEntry(FileSystem fileSystem, FileLocation fileLocation, boolean bl, boolean bl2, long l, long l2, long l3) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("The system cannot be null");
        }
        if (fileLocation == null) {
            throw new IllegalArgumentException("The location cannot be null");
        }
        this.fReal = bl;
        this.fSystem = fileSystem;
        this.fLocation = fileLocation;
        this.fSize = l;
        this.fDateModified = l2;
        this.fMode = l3;
        this.fFolder = bl2;
        this.fName = fileLocation.getName();
    }

    public FileSystemEntry(FileSystem fileSystem, FileLocation fileLocation, NativeJava.StatEntry statEntry, boolean bl) {
        this(fileSystem, fileLocation, bl, statEntry.s_isdir, statEntry.st_size, statEntry.st_mtime * 1000L, statEntry.st_mode);
    }

    public FileSystemEntry(FileSystemEntry fileSystemEntry, FileLocation fileLocation, FileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("The system cannot be null");
        }
        if (fileLocation == null) {
            throw new IllegalArgumentException("The location cannot be null");
        }
        this.fSystem = fileSystem;
        this.fLocation = fileLocation;
        this.fSize = fileSystemEntry.fSize;
        this.fDateModified = fileSystemEntry.fDateModified;
        this.fMode = fileSystemEntry.fMode;
        this.fFolder = fileSystemEntry.fFolder;
        this.fName = fileSystemEntry.getName();
        this.fReal = fileSystemEntry.fReal && fileLocation.equals(fileSystemEntry.getLocation());
    }

    public FileSystem getSystem() {
        return this.fSystem;
    }

    public FileLocation getLocation() {
        return this.fLocation;
    }

    public String getName() {
        return this.fLocation.getName();
    }

    public long getSize() {
        return this.fSize;
    }

    public Date getDateModified() {
        return new Date(this.fDateModified);
    }

    public long getMode() {
        return this.fMode;
    }

    public boolean isFolder() {
        return this.fFolder;
    }

    public boolean isReal() {
        return this.fReal;
    }

    public String toString() {
        return this.fLocation.toString();
    }

    public int hashCode() {
        return this.fLocation.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof FileSystemEntry && this.fLocation.equals(((FileSystemEntry)object).getLocation()) && this.fSystem.equals(((FileSystemEntry)object).getSystem());
    }

    public boolean matches(FileSystemEntry fileSystemEntry) {
        return this.equals(fileSystemEntry) && this.fFolder == fileSystemEntry.isFolder() && this.fSize == fileSystemEntry.getSize() && this.fDateModified == fileSystemEntry.fDateModified && this.fMode == fileSystemEntry.getMode() && this.fLocation.getName().equals(fileSystemEntry.getName());
    }
}

