/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlab.api.explorer;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.util.ExtendedIterable;

public enum SelectionMode {
    NOT_SELECTION_SENSITIVE{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return true;
        }

        @Override
        public boolean allowOnContextMenu(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return extendedIterable.isEmpty();
        }
    }
    ,
    EXPLICIT_MULTIPLE_FILE_SELECTION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return SelectionMode.hasOneOrMoreFiles((ExtendedIterable<FileSystemEntry>)extendedIterable);
        }
    }
    ,
    EXPLICIT_MULTIPLE_FOLDER_SELECTION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return SelectionMode.hasOneOrMoreFolders((ExtendedIterable<FileSystemEntry>)extendedIterable);
        }
    }
    ,
    EXPLICIT_SINGLE_FOLDER_SELECTION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return extendedIterable.isSizeEqualTo(1) && SelectionMode.hasOneOrMoreFolders((ExtendedIterable<FileSystemEntry>)extendedIterable);
        }
    }
    ,
    EXPLICIT_SINGLE_FILE_SELECTION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return extendedIterable.isSizeEqualTo(1) && SelectionMode.hasOneOrMoreFiles((ExtendedIterable<FileSystemEntry>)extendedIterable);
        }
    }
    ,
    EXPLICIT_SINGLE_SELECTION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return extendedIterable.isSizeEqualTo(1);
        }
    }
    ,
    EXPLICIT_MULTIPLE_SELECTION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return extendedIterable.isSizeGreaterThan(0);
        }
    }
    ,
    SINGLE_FOLDER_SELECTION_OR_CURRENT_LOCATION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return extendedIterable.isSizeEqualTo(1) && SelectionMode.hasOneOrMoreFolders((ExtendedIterable<FileSystemEntry>)extendedIterable) || extendedIterable.isEmpty();
        }
    }
    ,
    SINGLE_SELECTION_OR_CURRENT_LOCATION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return extendedIterable.isSizeLessThanOrEqualTo(1);
        }
    }
    ,
    MULTIPLE_FOLDER_SELECTION_OR_CURRENT_LOCATION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return !SelectionMode.hasOneOrMoreFiles((ExtendedIterable<FileSystemEntry>)extendedIterable);
        }
    }
    ,
    MULTIPLE_SELECTION_OR_CURRENT_LOCATION{

        @Override
        public boolean allowInvocation(ExtendedIterable<FileSystemEntry> extendedIterable) {
            return true;
        }
    };


    public abstract boolean allowInvocation(ExtendedIterable<FileSystemEntry> var1);

    public boolean allowOnContextMenu(ExtendedIterable<FileSystemEntry> extendedIterable) {
        return this.allowInvocation(extendedIterable);
    }

    private static boolean hasOneOrMoreFiles(ExtendedIterable<FileSystemEntry> extendedIterable) {
        for (FileSystemEntry fileSystemEntry : extendedIterable) {
            if (fileSystemEntry.isFolder()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasOneOrMoreFolders(ExtendedIterable<FileSystemEntry> extendedIterable) {
        for (FileSystemEntry fileSystemEntry : extendedIterable) {
            if (!fileSystemEntry.isFolder()) continue;
            return true;
        }
        return false;
    }
}

