/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.cmapeditor;

import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.page.cmapeditor.CMColorCell;
import com.mathworks.page.cmapeditor.CMColorMarker;
import com.mathworks.page.cmapeditor.CMED;
import com.mathworks.page.cmapeditor.CMEditor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;

class CMEditModel
extends Observable {
    private static double CTOL = 0.005;
    public static int CSPACE_RGB = 0;
    public static int CSPACE_HSV = 1;
    private CMEditor editor;
    List colorCellList = null;
    List colorMarkerList = null;
    int ccSize = 0;
    private CMColorMarker selectedCMarker = null;
    private int selectedCMarkerIndex = -1;
    private double[][] dblcmap;
    private double[][] oldcmap;
    private double[] clim = new double[2];
    private double[] oldclim = new double[2];
    private int cspace = CSPACE_RGB;
    private Graphics2D g2;

    void dispose() {
        this.editor = null;
    }

    public CMEditModel(CMEditor cMEditor) {
        this.editor = cMEditor;
        this.colorCellList = Collections.synchronizedList(new LinkedList());
        this.colorMarkerList = Collections.synchronizedList(new LinkedList());
    }

    public void setColorMapModel(double[][] dArray) {
        if (this.cspace == CSPACE_RGB) {
            this.setColorMapModelRGB(dArray);
        } else {
            this.setColorMapModelHSV(dArray);
        }
        this.setSelectedColorMarker(null);
    }

    public void setBestColorMapModel(double[][] dArray) {
        int n;
        if (dArray == null) {
            throw new Error("Colormap must not be empty");
        }
        assert (dArray != null);
        int n2 = this.testRGBNumberOfMarkers(dArray);
        if (n2 <= (n = this.testHSVNumberOfMarkers(dArray))) {
            this.setColorMapModelRGB(dArray);
            this.cspace = CSPACE_RGB;
            this.editor.getFrame().setInterpModeCombo(0);
        } else {
            this.setColorMapModelHSV(dArray);
            this.cspace = CSPACE_HSV;
            this.editor.getFrame().setInterpModeCombo(1);
        }
        this.setSelectedColorMarker(null);
    }

    public void setColorMapModelRGB(double[][] dArray) {
        this.setOldCmap(dArray);
        if (this.colorCellList != null) {
            this.clearColorCells();
            this.ccSize = 0;
        }
        if (this.colorMarkerList != null) {
            this.clearColorMarkers();
        }
        this.selectedCMarker = null;
        int n = CMED.X0;
        int n2 = CMED.CMKR_Y;
        int n3 = CMED.CCELL_Y;
        int n4 = CMED.CELL_W;
        int n5 = CMED.CELL_H;
        for (int i = 0; i < dArray.length; ++i) {
            CMColorCell cMColorCell = new CMColorCell(n, n3, n4, n5, i, new Color((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]));
            this.addColorCell(cMColorCell);
            ++this.ccSize;
            if (i == 0 || i == dArray.length - 1) {
                CMColorMarker cMColorMarker = new CMColorMarker(true, n, n2, i, new Color((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]));
                this.addColorMarker(cMColorMarker);
            } else {
                double d = dArray[i][0] - dArray[i - 1][0];
                double d2 = dArray[i][1] - dArray[i - 1][1];
                double d3 = dArray[i][2] - dArray[i - 1][2];
                double d4 = dArray[i + 1][0] - dArray[i][0];
                double d5 = dArray[i + 1][1] - dArray[i][1];
                double d6 = dArray[i + 1][2] - dArray[i][2];
                if (Math.abs(d - d4) > CTOL || Math.abs(d2 - d5) > CTOL || Math.abs(d3 - d6) > CTOL) {
                    CMColorMarker cMColorMarker = new CMColorMarker(false, n, n2, i, new Color((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]));
                    this.addColorMarker(cMColorMarker);
                }
            }
            n += CMED.CELL_W;
        }
        this.editor.getView().updateViewSize(this.ccSize);
    }

    public void setColorMapModelHSV(double[][] dArray) {
        this.setOldCmap(dArray);
        if (this.colorCellList != null) {
            this.clearColorCells();
            this.colorCellList = null;
            this.ccSize = 0;
        }
        if (this.colorMarkerList != null) {
            this.clearColorMarkers();
            this.colorMarkerList = null;
        }
        this.colorCellList = Collections.synchronizedList(new LinkedList());
        this.colorMarkerList = Collections.synchronizedList(new LinkedList());
        this.selectedCMarker = null;
        double[][] dArray2 = new double[dArray.length][3];
        dArray2 = CMEditModel.cmedRGB2HSV(dArray, dArray2);
        int n = CMED.X0;
        int n2 = CMED.CMKR_Y;
        int n3 = CMED.CCELL_Y;
        int n4 = CMED.CELL_W;
        int n5 = CMED.CELL_H;
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            CMColorCell cMColorCell = new CMColorCell(n, n3, n4, n5, i, new Color((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]));
            this.addColorCell(cMColorCell);
            ++this.ccSize;
            if (i == 0 || i == dArray.length - 1) {
                CMColorMarker cMColorMarker = new CMColorMarker(true, n, n2, i, new Color((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]));
                this.addColorMarker(cMColorMarker);
            } else {
                double d2 = dArray2[i][0] - dArray2[i - 1][0];
                double d3 = dArray2[i][1] - dArray2[i - 1][1];
                double d4 = dArray2[i][2] - dArray2[i - 1][2];
                double d5 = dArray2[i + 1][0] - dArray2[i][0];
                double d6 = dArray2[i + 1][1] - dArray2[i][1];
                double d7 = dArray2[i + 1][2] - dArray2[i][2];
                d += d2;
                if (Math.abs(d2 - d5) > CTOL || Math.abs(d3 - d6) > CTOL || Math.abs(d4 - d7) > CTOL || d + d5 > 0.4) {
                    CMColorMarker cMColorMarker = new CMColorMarker(false, n, n2, i, new Color((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]));
                    this.addColorMarker(cMColorMarker);
                    d = 0.0;
                }
            }
            n += CMED.CELL_W;
        }
        this.editor.getView().updateViewSize(this.ccSize);
    }

    protected int testRGBNumberOfMarkers(double[][] dArray) {
        int n = 0;
        assert (dArray != null);
        for (int i = 1; i < dArray.length - 1; ++i) {
            double d = dArray[i][0] - dArray[i - 1][0];
            double d2 = dArray[i][1] - dArray[i - 1][1];
            double d3 = dArray[i][2] - dArray[i - 1][2];
            double d4 = dArray[i + 1][0] - dArray[i][0];
            double d5 = dArray[i + 1][1] - dArray[i][1];
            double d6 = dArray[i + 1][2] - dArray[i][2];
            if (!(Math.abs(d - d4) > CTOL) && !(Math.abs(d2 - d5) > CTOL) && !(Math.abs(d3 - d6) > CTOL)) continue;
            ++n;
        }
        return n;
    }

    protected int testHSVNumberOfMarkers(double[][] dArray) {
        int n = 0;
        assert (dArray != null);
        double[][] dArray2 = new double[dArray.length][3];
        dArray2 = CMEditModel.cmedRGB2HSV(dArray, dArray2);
        for (int i = 1; i < dArray.length - 1; ++i) {
            double d = dArray2[i][0] - dArray2[i - 1][0];
            double d2 = dArray2[i][1] - dArray2[i - 1][1];
            double d3 = dArray2[i][2] - dArray2[i - 1][2];
            double d4 = dArray2[i + 1][0] - dArray2[i][0];
            double d5 = dArray2[i + 1][1] - dArray2[i][1];
            double d6 = dArray2[i + 1][2] - dArray2[i][2];
            if (!(Math.abs(d - d4) > CTOL) && !(Math.abs(d2 - d5) > CTOL) && !(Math.abs(d3 - d6) > CTOL)) continue;
            ++n;
        }
        return n;
    }

    public void recalcCells() {
        ListIterator listIterator = null;
        CMColorMarker cMColorMarker = null;
        CMColorMarker cMColorMarker2 = null;
        listIterator = this.colorMarkerList.listIterator();
        Graphics2D graphics2D = (Graphics2D)this.editor.getView().getGraphics();
        graphics2D.setXORMode(this.editor.getFrame().getBackground());
        graphics2D.setPaintMode();
        while (listIterator.hasNext()) {
            cMColorMarker = cMColorMarker2 == null ? (CMColorMarker)listIterator.next() : cMColorMarker2;
            if (!listIterator.hasNext()) continue;
            cMColorMarker2 = (CMColorMarker)listIterator.next();
            this.updateColorCellsBetweenMarkers(cMColorMarker, cMColorMarker2, false);
        }
        if (this.editor.getAutoUpdate()) {
            this.sendMatlabUpdate();
        }
        graphics2D.dispose();
        graphics2D = null;
    }

    public void setColorLimits(double[] dArray, int n) {
        for (int i = 0; i < 2; ++i) {
            this.clim[i] = dArray[i];
            this.oldclim[i] = dArray[i];
        }
        this.editor.getFrame().setColorLimitsText(0, this.clim[0]);
        this.editor.getFrame().setColorLimitsText(1, this.clim[1]);
        if (n == 1) {
            this.updateMatlabClim();
        }
    }

    public void setColorLimits(int n, double d) {
        this.clim[n] = d;
        this.oldclim[n] = d;
        this.editor.getFrame().setColorLimitsText(n, this.clim[n]);
        this.updateMatlabClim();
    }

    public double getColorLimits(int n) {
        return this.clim[n];
    }

    public void resetColorLimits() {
        this.editor.getFrame().setColorLimitsText(0, this.clim[0]);
        this.editor.getFrame().setColorLimitsText(1, this.clim[1]);
    }

    public void clearColorCells() {
        this.colorCellList.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean removeColorCell(CMColorCell cMColorCell) {
        boolean bl = this.colorCellList.remove(cMColorCell);
        if (bl) {
            this.setChanged();
            this.notifyObservers(cMColorCell.getBounds());
        }
        return bl;
    }

    public void addColorCell(CMColorCell cMColorCell) {
        this.colorCellList.add(cMColorCell);
        this.setChanged();
        this.notifyObservers(cMColorCell.getBounds());
    }

    public int getColorCellListSize() {
        return this.colorCellList.size();
    }

    List getColorCellList() {
        return this.colorCellList;
    }

    List getColorMarkerList() {
        return this.colorMarkerList;
    }

    public void updateColorCellsBetweenMarkers(CMColorMarker cMColorMarker, CMColorMarker cMColorMarker2, boolean bl) {
        float[] fArray = new float[3];
        if (cMColorMarker != null && cMColorMarker2 != null) {
            CMColorCell cMColorCell;
            int n;
            int n2 = cMColorMarker.getCellindex();
            int n3 = cMColorMarker2.getCellindex();
            double[][] dArray = new double[2][3];
            double[][] dArray2 = new double[2][3];
            fArray = cMColorMarker.getColor().getColorComponents(fArray);
            for (n = 0; n < 3; ++n) {
                dArray[0][n] = fArray[n];
            }
            fArray = cMColorMarker2.getColor().getColorComponents(fArray);
            for (n = 0; n < 3; ++n) {
                dArray[1][n] = fArray[n];
            }
            Iterator iterator = this.colorCellList.iterator();
            for (int i = 0; i < n2 && iterator.hasNext(); ++i) {
                cMColorCell = (CMColorCell)iterator.next();
            }
            if (this.cspace == CSPACE_RGB) {
                for (int i = n2; i <= n3; ++i) {
                    cMColorCell = (CMColorCell)iterator.next();
                    if (cMColorCell == null) continue;
                    double d = (double)(i - n2) / (double)(n3 - n2);
                    float[] fArray2 = new float[3];
                    for (int j = 0; j < 3; ++j) {
                        fArray2[j] = (float)(dArray[0][j] + (dArray[1][j] - dArray[0][j]) * d);
                    }
                    cMColorCell.setColor(new Color(fArray2[0], fArray2[1], fArray2[2]));
                    this.setChanged();
                    this.notifyObservers(cMColorCell.getBounds());
                }
            } else {
                dArray2 = CMEditModel.cmedRGB2HSV(dArray, dArray2);
                double[][] dArray3 = new double[2][3];
                double[][] dArray4 = new double[2][3];
                for (int i = n2; i <= n3; ++i) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    cMColorCell = (CMColorCell)iterator.next();
                    double d5 = dArray2[0][0];
                    double d6 = dArray2[1][0];
                    double d7 = (double)(i - n2) / (double)(n3 - n2);
                    if (d6 > d5) {
                        d4 = d6 - d5;
                        d3 = 1.0 - d6 + d5;
                        if (d4 <= d3) {
                            dArray3[0][0] = d5 + (d6 - d5) * d7;
                        } else {
                            d2 = (1.0 - d6) / d3;
                            d = d5 / d3;
                            dArray3[0][0] = d7 < d ? d5 * (1.0 - d7 / d) : (d7 == d ? 0.0 : 1.0 - (1.0 - d6) * ((d7 - d) / d2));
                        }
                    } else {
                        d4 = d5 - d6;
                        d3 = 1.0 - d5 + d6;
                        if (d4 <= d3) {
                            dArray3[0][0] = d5 + (d6 - d5) * d7;
                        } else {
                            d2 = (1.0 - d5) / d3;
                            d = d6 / d3;
                            dArray3[0][0] = d7 < d2 ? d5 + (1.0 - d5) * (d7 / d2) : (d7 == d2 ? 1.0 : d6 * ((d7 - d2) / d));
                        }
                    }
                    for (int j = 1; j < 3; ++j) {
                        dArray3[0][j] = dArray2[0][j] + (dArray2[1][j] - dArray2[0][j]) * d7;
                    }
                    dArray4 = CMEditModel.cmedHSV2RGB(dArray3, dArray4);
                    cMColorCell.setColor(new Color((float)dArray4[0][0], (float)dArray4[0][1], (float)dArray4[0][2]));
                    this.setChanged();
                    this.notifyObservers(cMColorCell.getBounds());
                }
            }
            if (bl && this.editor.getAutoUpdate()) {
                this.sendMatlabUpdate();
            }
        }
    }

    public void resetColorMapModel() {
        if (this.oldcmap != null) {
            this.setColorMapModel(this.oldcmap);
            this.sendMatlabUpdate();
        }
    }

    public void sendMatlabUpdate() {
        float[] fArray = new float[3];
        this.dblcmap = new double[this.colorCellList.size()][3];
        for (int i = 0; i < this.colorCellList.size(); ++i) {
            CMColorCell cMColorCell = (CMColorCell)this.colorCellList.get(i);
            fArray = cMColorCell.getColor().getColorComponents(fArray);
            this.dblcmap[i][0] = fArray[0];
            this.dblcmap[i][1] = fArray[1];
            this.dblcmap[i][2] = fArray[2];
        }
        this.editor.getMatlabQue().MATLAB_UpdateCmap(this.dblcmap, this.editor);
        if (!this.editor.getAutoUpdate()) {
            this.setOldCmap(this.dblcmap);
        }
    }

    public void sendMatlabOldCmap() {
        if (this.oldcmap != null) {
            this.editor.getMatlabQue().MATLAB_UpdateCmap(this.oldcmap, this.editor);
        }
    }

    public void clearColorMarkers() {
        this.colorMarkerList.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean removeColorMarker(CMColorMarker cMColorMarker) {
        boolean bl = this.colorMarkerList.remove(cMColorMarker);
        if (bl) {
            this.setChanged();
            this.notifyObservers(cMColorMarker.getBounds());
        }
        return bl;
    }

    public void addColorMarker(CMColorMarker cMColorMarker) {
        this.colorMarkerList.add(cMColorMarker);
        this.setChanged();
        this.notifyObservers(cMColorMarker.getBounds());
    }

    public void addColorMarker(int n, CMColorMarker cMColorMarker) {
        this.colorMarkerList.add(n, cMColorMarker);
        this.setChanged();
        this.notifyObservers(cMColorMarker.getBounds());
    }

    public void setColorMarkerColor(CMColorMarker cMColorMarker, Color color) {
        if (cMColorMarker == null) {
            return;
        }
        float[] fArray = new float[3];
        fArray = color.getColorComponents(fArray);
        cMColorMarker.setColor(new Color(fArray[0], fArray[1], fArray[2]));
        this.setChanged();
        this.notifyObservers(cMColorMarker.getBounds());
    }

    public void setColorMarkerSelected(CMColorMarker cMColorMarker, boolean bl) {
        cMColorMarker.setSelected(bl);
        this.setChanged();
        this.notifyObservers(cMColorMarker.getBounds());
    }

    public void setSelectedColorMarker(CMColorMarker cMColorMarker) {
        boolean bl;
        boolean bl2 = bl = cMColorMarker != null;
        if (cMColorMarker == null) {
            this.selectedCMarker = null;
            this.selectedCMarkerIndex = -1;
        } else {
            this.selectedCMarker = cMColorMarker;
            this.selectedCMarkerIndex = this.colorMarkerList.indexOf(cMColorMarker);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (CMEditModel.this.editor != null && CMEditModel.this.editor.getFrame() != null && !CMEditModel.this.editor.getFrame().isDisposed()) {
                    CMEditModel.this.editor.getFrame().setEditColorEnabled(bl);
                    CMEditModel.this.editor.getFrame().setDeleteNodeEnabled(bl);
                }
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable));
    }

    public void setSelectedColorMarkerIndex(int n) {
        this.selectedCMarkerIndex = n;
        if (n == -1) {
            this.selectedCMarker = null;
            this.selectedCMarkerIndex = -1;
        } else {
            this.selectedCMarker = (CMColorMarker)this.colorMarkerList.get(n);
            this.selectedCMarkerIndex = n;
        }
    }

    public CMColorMarker getColorMarkerAtIndex(int n) {
        return (CMColorMarker)this.colorMarkerList.get(n);
    }

    public CMColorMarker getSelectedColorMarker() {
        return this.selectedCMarker;
    }

    public int getSelectedColorMarkerIndex() {
        return this.selectedCMarkerIndex;
    }

    public void setColorMarkerCellindex(CMColorMarker cMColorMarker, int n) {
        this.setChanged();
        this.notifyObservers(cMColorMarker.getBounds());
        cMColorMarker.setCellindex(n);
        int n2 = CMED.X0 + n * CMED.CELL_W;
        int n3 = CMED.CMKR_Y;
        cMColorMarker.modifyPos(n2, n3);
        this.setChanged();
        this.notifyObservers(cMColorMarker.getBounds());
    }

    public int getColorMarkerListSize() {
        return this.colorMarkerList.size();
    }

    public double getCDataAtColormapIndex(int n) {
        double d = this.clim[0] + (this.clim[1] - this.clim[0]) * ((double)n / (double)this.ccSize);
        return d;
    }

    public void updateMatlabClim() {
        double[] dArray = new double[]{this.clim[0], this.clim[1]};
        this.editor.getMatlabQue().MATLAB_UpdateClim(dArray, this.editor);
    }

    public void processNewCspace(int n) {
        this.cspace = n;
        this.recalcCells();
    }

    public void chooseSelectedMarkerColor() {
        CMColorMarker cMColorMarker = null;
        cMColorMarker = this.editor.getModel().getSelectedColorMarker();
        if (cMColorMarker != null) {
            Color color = cMColorMarker.getColor();
            double[] dArray = new double[3];
            float[] fArray = new float[4];
            color.getComponents(fArray);
            for (int i = 0; i < 3; ++i) {
                dArray[i] = fArray[i];
            }
            this.editor.getMatlabQue().MATLAB_ChooseMarkerColor(dArray, this.editor);
        }
    }

    public void setSelectedMarkerColor(double[] dArray) {
        CMColorMarker cMColorMarker = null;
        CMColorMarker cMColorMarker2 = null;
        CMColorMarker cMColorMarker3 = null;
        Color color = new Color((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        cMColorMarker2 = this.editor.getModel().getSelectedColorMarker();
        int n = this.editor.getModel().getSelectedColorMarkerIndex();
        this.g2 = (Graphics2D)this.editor.getView().getGraphics();
        this.g2.setXORMode(this.editor.getView().getBackground());
        this.editor.getModel().setColorMarkerColor(cMColorMarker2, color);
        this.g2.setPaintMode();
        if (n == 0) {
            cMColorMarker3 = this.editor.getModel().getColorMarkerAtIndex(n + 1);
            this.editor.getModel().updateColorCellsBetweenMarkers(cMColorMarker2, cMColorMarker3, true);
        } else if (n == this.editor.getModel().getColorMarkerListSize() - 1) {
            cMColorMarker = this.editor.getModel().getColorMarkerAtIndex(n - 1);
            this.editor.getModel().updateColorCellsBetweenMarkers(cMColorMarker, cMColorMarker2, true);
        } else {
            cMColorMarker3 = this.editor.getModel().getColorMarkerAtIndex(n + 1);
            cMColorMarker = this.editor.getModel().getColorMarkerAtIndex(n - 1);
            this.editor.getModel().updateColorCellsBetweenMarkers(cMColorMarker, cMColorMarker2, false);
            this.editor.getModel().updateColorCellsBetweenMarkers(cMColorMarker2, cMColorMarker3, true);
        }
        this.g2.dispose();
        this.g2 = null;
        this.editor.bringToFront();
    }

    public void deleteSelectedMarkers() {
        ListIterator listIterator = null;
        CMColorMarker cMColorMarker = null;
        CMColorMarker cMColorMarker2 = null;
        CMColorMarker cMColorMarker3 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        this.g2 = (Graphics2D)this.editor.getView().getGraphics();
        this.g2.setXORMode(this.editor.getFrame().getBackground());
        this.g2.setPaintMode();
        while (!bl2) {
            bl2 = true;
            bl = false;
            listIterator = null;
            cMColorMarker = null;
            cMColorMarker2 = null;
            cMColorMarker3 = null;
            n = 0;
            listIterator = this.colorMarkerList.listIterator();
            while (listIterator.hasNext() & !bl) {
                if (n > 0) {
                    cMColorMarker = new CMColorMarker(cMColorMarker2);
                }
                if ((cMColorMarker2 = (CMColorMarker)listIterator.next()).isSelected() && n > 0 && listIterator.hasNext()) {
                    bl = true;
                    cMColorMarker3 = (CMColorMarker)listIterator.next();
                    boolean bl3 = this.removeColorMarker(cMColorMarker2);
                    if (bl3) {
                        bl2 = false;
                        this.updateColorCellsBetweenMarkers(cMColorMarker, cMColorMarker3, false);
                    }
                }
                ++n;
            }
        }
        if (this.editor.getAutoUpdate()) {
            this.sendMatlabUpdate();
        }
        this.g2.dispose();
        this.g2 = null;
        this.setSelectedColorMarker(null);
    }

    public void setOldCmap(double[][] dArray) {
        this.oldcmap = new double[dArray.length][3];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.oldcmap[i][j] = dArray[i][j];
            }
        }
    }

    public static double[][] cmedRGB2HSV(double[][] dArray, double[][] dArray2) {
        float[] fArray = new float[3];
        for (int i = 0; i < dArray.length; ++i) {
            int n = Math.round((float)dArray[i][0] * 255.0f);
            int n2 = Math.round((float)dArray[i][1] * 255.0f);
            int n3 = Math.round((float)dArray[i][2] * 255.0f);
            fArray = Color.RGBtoHSB(n, n2, n3, fArray);
            for (int j = 0; j < 3; ++j) {
                dArray2[i][j] = fArray[j];
            }
        }
        return dArray2;
    }

    public static double[][] cmedHSV2RGB(double[][] dArray, double[][] dArray2) {
        float[] fArray = new float[4];
        for (int i = 0; i < dArray.length; ++i) {
            int n = Color.HSBtoRGB((float)dArray[i][0], (float)dArray[i][1], (float)dArray[i][2]);
            Color color = new Color(n);
            fArray = color.getComponents(fArray);
            for (int j = 0; j < 3; ++j) {
                dArray2[i][j] = fArray[j];
            }
        }
        return dArray2;
    }
}

