/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.mwswing.MJSlider;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import javax.swing.JComponent;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderControl
extends PropertyControl {
    MJSlider fSlider = null;
    private float fMultiplier = 1.0f;

    public SliderControl() {
        this.constructorHelper(0, 100);
    }

    public SliderControl(String string, CellEditorListener cellEditorListener, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper(0, 100);
        this.fSlider.setName(string2 + "." + string);
    }

    public SliderControl(String string, CellEditorListener cellEditorListener, int n, int n2, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper(n, n2);
        this.fSlider.setName(string2 + "." + string);
    }

    private void constructorHelper(int n, int n2) {
        this.fSlider = new MJSlider(0, n, n2, n);
        this.fSlider.setMajorTickSpacing(10);
        this.fSlider.setPaintTicks(false);
        this.setCustomEditor((JComponent)this.fSlider);
    }

    @Override
    public String getName() {
        if (this.fSlider != null) {
            return this.fSlider.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    public float getMultiplier() {
        return this.fMultiplier;
    }

    public void setMultiplier(float f) {
        if (f != 0.0f) {
            this.fMultiplier = f;
        }
    }

    @Override
    public void setDisplayedValue(Object object) {
        int n = 0;
        if (object == null) {
            n = 0;
        } else if (object instanceof Integer) {
            n = (int)(((Integer)object).floatValue() / this.fMultiplier);
        } else if (object instanceof Float) {
            n = (int)(((Float)object).floatValue() / this.fMultiplier);
        } else if (object instanceof Double) {
            n = (int)((Double)object / (double)this.fMultiplier);
        } else if (object == PropertyControl.MIXED_VALUES) {
            n = 0;
        }
        this.fSlider.setValue(n);
    }

    @Override
    public void addEditStoppedSupport() {
        this.fSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!SliderControl.this.fSlider.getValueIsAdjusting()) {
                    SliderControl.this.propertyEditStopped();
                }
            }
        });
    }

    @Override
    public Object getDisplayedValue() {
        int n = this.fSlider.getValue();
        float f = (float)n * this.fMultiplier;
        Number number = new Float(f);
        String string = this.getPropertyType().getName();
        if (string.equals("double")) {
            number = new Double(f);
        } else if (string.equals("int")) {
            number = new Integer((int)f);
        }
        return number;
    }
}

