/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.jidesoft.swing.AutoResizingTextArea;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceModel;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.plotbrowser.MLPropertyTypeConverter;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.PropertyControl;
import com.mathworks.util.Log;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextControl
extends PropertyControl {
    public volatile JTextComponent fText = null;
    protected boolean fIsMultiline = false;
    protected NumberFormat fNumberFormat;
    private String fPrevText = "";
    protected boolean fIgnoreEvents = false;
    protected boolean fTEXWarningDisabled = false;
    protected String fTEXWarningCache = null;
    private String[] fNullTitle = new String[0];
    protected FocusListener focusLsnr = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!TextControl.this.fIgnoreEvents) {
                TextControl.this.fIgnoreEvents = true;
                TextControl.this.propertyEditStopped();
                TextControl.this.restoreTEXWarningState();
                TextControl.this.fIgnoreEvents = false;
            }
        }
    };
    protected KeyAdapter enterLsnr = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (TextControl.this.fIgnoreEvents) {
                return;
            }
            if (TextControl.this.fEditor instanceof JTextArea) {
                if (!TextControl.this.timer.isRunning()) {
                    TextControl.this.timer.start();
                } else {
                    TextControl.this.timer.restart();
                }
                TextControl.this.cacheTEXWarningState();
            }
            if (keyEvent.getKeyCode() == 10 && !(TextControl.this.fEditor instanceof JTextArea)) {
                TextControl.this.fIgnoreEvents = true;
                TextControl.this.propertyEditStopped();
                keyEvent.consume();
                TextControl.this.fIgnoreEvents = false;
            }
        }
    };
    private final Timer timer = new Timer(0, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextControl.this.propertyEditStopped();
        }
    });
    private TransferHandler fTransferHandler = new TextControlTransferHandler();

    public TextControl(String string, CellEditorListener cellEditorListener, String string2) {
        this(string, cellEditorListener, false, string2);
    }

    public TextControl(String string, CellEditorListener cellEditorListener, boolean bl, String string2) {
        super(string, cellEditorListener);
        this.constructorHelper(bl);
        this.fText.setName(string2 + "." + string);
        this.timer.setRepeats(false);
        this.timer.setDelay(500);
    }

    @Override
    public void applyChanges(Object[] objectArray) {
        this.enablePropertyChangeListeners(false);
        super.applyChanges(objectArray);
        this.setValue(this.getDisplayedValue());
        this.enablePropertyChangeListeners(true);
    }

    private void constructorHelper(boolean bl) {
        this.fIsMultiline = bl;
        if (this.fIsMultiline) {
            AutoResizingTextArea autoResizingTextArea = new AutoResizingTextArea(){

                public void setToolTipText(String string) {
                }
            };
            autoResizingTextArea.setFont(UIManager.getFont("TextField.font"));
            autoResizingTextArea.setLineWrap(false);
            autoResizingTextArea.setRows(3);
            autoResizingTextArea.setMinRows(2);
            autoResizingTextArea.setMaxRows(3);
            this.fText = autoResizingTextArea;
        } else {
            this.fText = new JTextField();
        }
        this.setCustomEditor(this.fText);
        this.fText.setTransferHandler(this.fTransferHandler);
        this.fNumberFormat = NumberFormat.getInstance(Locale.US);
        this.fNumberFormat.setGroupingUsed(false);
        this.setMaximumFractionDigits(6);
    }

    @Override
    public String getName() {
        if (this.fText != null) {
            return this.fText.getName() + "." + this.getClass().getSimpleName();
        }
        return null;
    }

    public int getMaximumFractionDigits() {
        return this.fNumberFormat.getMaximumFractionDigits();
    }

    public void setMaximumFractionDigits(int n) {
        this.fNumberFormat.setMaximumFractionDigits(n);
    }

    public int getRows() {
        if (this.fText instanceof JTextArea) {
            return ((JTextArea)this.fText).getRows();
        }
        return 1;
    }

    public void setRows(int n) {
        if (this.fText instanceof JTextArea) {
            ((JTextArea)this.fText).setRows(n);
        }
    }

    public String getToolTipText() {
        return this.fText.getToolTipText();
    }

    public void setToolTipText(String string) {
        this.fText.setToolTipText(string);
    }

    @Override
    public void setDisplayedValue(Object object) {
        String string = "";
        if (object == null) {
            string = "";
        } else if (object == PropertyControl.MIXED_VALUES) {
            string = (String)PropertyControl.MIXED_VALUES;
        } else if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Integer) {
            string = Integer.toString((Integer)object);
        } else if (object instanceof Float) {
            string = this.fNumberFormat.format(((Float)object).floatValue());
        } else if (object instanceof Double) {
            string = this.fNumberFormat.format((Double)object);
        } else {
            String string2 = object.getClass().getName();
            if (string2.startsWith("[L") && string2.indexOf("String") > -1) {
                String[] stringArray = (String[])object;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append(stringArray[i]);
                }
                string = stringBuffer.toString();
            }
        }
        if (!string.equals(this.fText.getText())) {
            this.fText.setText(string);
        }
        this.fPrevText = string;
    }

    @Override
    public void addEditStoppedSupport() {
        boolean bl = false;
        for (FocusListener eventListener : this.fText.getFocusListeners()) {
            if (this.focusLsnr != eventListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.fText.addFocusListener(this.focusLsnr);
        }
        bl = false;
        for (EventListener eventListener : this.fText.getKeyListeners()) {
            if (this.enterLsnr != eventListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.fText.addKeyListener(this.enterLsnr);
        }
    }

    @Override
    public Object getDisplayedValue() {
        String string = this.fText.getText();
        String[] stringArray = string;
        String string2 = this.getPropertyType() == MLArrayRef.class ? MLPropertyTypeConverter.lookupDataType(this.getPropertyName(), this.getValue().getClass().getName()) : this.getPropertyType().getName();
        try {
            if (string2.equals("double")) {
                stringArray = Double.valueOf(string);
            } else if (string2.equals("float")) {
                stringArray = Float.valueOf(string);
            } else if (string2.equals("int")) {
                stringArray = Integer.valueOf(string);
            } else if (string2.startsWith("[L") && string2.indexOf("String") > -1) {
                stringArray = string == null || string.length() == 0 ? this.fNullTitle : string.split("\n", -1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ErrorHandler.showSimpleError(MessageFormat.format(PropertyEditorResources.getBundle().getString("PropertyControl.error.parse"), string), this.getTopLevelAncestor());
            this.fText.setText(this.fPrevText);
            this.fText.requestFocus();
            return null;
        }
        return stringArray;
    }

    protected void cacheTEXWarningState() {
        if (!this.fTEXWarningDisabled) {
            this.fTEXWarningDisabled = true;
            this.fTEXWarningCache = null;
            MatlabWorker matlabWorker = new MatlabWorker(){

                public Object runOnMatlabThread() {
                    try {
                        String string = (String)Matlab.mtEval((String)"getfield(warning('query','MATLAB:gui:latexsup:UnableToInterpretTeXString'),'state');", (int)1);
                        if (string.equals("on")) {
                            Matlab.mtEval((String)"warning('off','MATLAB:gui:latexsup:UnableToInterpretTeXString')");
                        }
                        return string;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    if (object != null) {
                        TextControl.this.fTEXWarningCache = (String)object;
                    }
                }
            };
            matlabWorker.start();
        }
    }

    protected void restoreTEXWarningState() {
        if (this.fTEXWarningDisabled) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    TextControl.this.fTEXWarningDisabled = false;
                    if (TextControl.this.fTEXWarningCache != null && TextControl.this.fTEXWarningCache.equals("on")) {
                        try {
                            Matlab.mtEval((String)"warning('on','MATLAB:gui:latexsup:UnableToInterpretTeXString')");
                        }
                        catch (Exception exception) {
                            Log.log((String)exception.toString());
                        }
                    }
                }
            });
        }
    }

    class TextControlTransferHandler
    extends TransferHandler {
        TextControlTransferHandler() {
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            DataFlavor dataFlavor = this.getFlavor(transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                InputContext inputContext = jComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                try {
                    String string = null;
                    if (transferable.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
                        SimpleVariableDefinition[] simpleVariableDefinitionArray = MLDataFlavor.decodeSimpleVariableListFlavor((Transferable)transferable);
                        if (simpleVariableDefinitionArray.length == 1) {
                            string = this.getStringFromVars(simpleVariableDefinitionArray[0]);
                        }
                        if (string == null) {
                            string = (String)transferable.getTransferData(dataFlavor);
                        }
                    } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    }
                    ((JTextComponent)jComponent).replaceSelection(string);
                    TextControl.this.propertyEditStopped();
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    Log.log((String)unsupportedFlavorException.toString());
                }
                catch (IOException iOException) {
                    Log.log((String)iOException.toString());
                }
            }
            return false;
        }

        private String getStringFromVars(SimpleVariableDefinition simpleVariableDefinition) {
            String string = null;
            MatlabWorkspaceModel matlabWorkspaceModel = new MatlabWorkspaceModel();
            int n = matlabWorkspaceModel.CLASS();
            int n2 = matlabWorkspaceModel.VALUE();
            int n3 = matlabWorkspaceModel.getRecordCount();
            for (int i = 0; i < n3; ++i) {
                String string2;
                String string3 = (String)matlabWorkspaceModel.getValueAt(i, 0);
                String string4 = simpleVariableDefinition.getVariable();
                if (!string4.equals(string3) || !"char".equals(string2 = (String)matlabWorkspaceModel.getValueAt(i, n))) continue;
                string = (String)matlabWorkspaceModel.getValueAt(i, n2);
                if ("".equals(string)) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.log((String)interruptedException.toString());
                    }
                    string = (String)matlabWorkspaceModel.getValueAt(i, n2);
                }
                string = string.replace('\'', ' ');
                string = string.trim();
                break;
            }
            matlabWorkspaceModel.unregisterInterests();
            return string;
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            return jTextComponent.isEditable() && jTextComponent.isEnabled() && this.getFlavor(dataFlavorArray) != null;
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            int n2;
            JTextComponent jTextComponent;
            int n3;
            if (jComponent instanceof JTextComponent && (n3 = (jTextComponent = (JTextComponent)jComponent).getSelectionStart()) != (n2 = jTextComponent.getSelectionEnd())) {
                try {
                    Document document = jTextComponent.getDocument();
                    String string = document.getText(n3, n2 - n3);
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, null);
                    if (n == 2) {
                        document.remove(n3, n2 - n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Log.log((String)badLocationException.toString());
                }
            }
        }

        private DataFlavor getFlavor(DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray != null) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                    return dataFlavor;
                }
            }
            return null;
        }
    }
}

