/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.panels;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlwidgets.graphics.PlotArgDescriptor;
import com.mathworks.mlwidgets.graphics.PlotMetadata;
import com.mathworks.mlwidgets.graphics.PlotSignature;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.page.plottool.PropertyEditor;
import com.mathworks.page.plottool.propertyeditor.PropertyEditorResources;
import com.mathworks.page.plottool.propertyeditor.controls.DataSourceControl;
import com.mathworks.page.plottool.propertyeditor.controls.TextControl;
import com.mathworks.page.plottool.propertyeditor.panels.PropertyPanel;
import com.mathworks.widgets.FormPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public abstract class AbstractSeriesPropPanel
extends PropertyPanel {
    protected String fNewSeriesType;
    protected boolean fIgnorePlotTypeChangeEvents = false;
    protected MJComboBox fPlotTypeCB;
    protected MJLabel fPlotTypeLabel;
    protected TextControl fNameTF;
    protected MJLabel fNameLabel;
    protected MJPanel fDataSourcesPanel;
    protected MJPanel fAppearancePanel;
    protected JPanel fButtonPanel;
    private Hashtable fIcons = new Hashtable();
    protected ActionListener fPlotTypeCBLsnr = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AbstractSeriesPropPanel.this.fIgnorePlotTypeChangeEvents) {
                return;
            }
            MJComboBox mJComboBox = (MJComboBox)actionEvent.getSource();
            AbstractSeriesPropPanel.this.fNewSeriesType = ((PLOTTYPE)((Object)mJComboBox.getSelectedItem())).getMatlabPlotType();
            AbstractSeriesPropPanel.this.fPlotTypeCB.setEnabled(false);
            AbstractSeriesPropPanel.this.fMatlab.feval("changeseriestype", new Object[]{AbstractSeriesPropPanel.this.fObjects, AbstractSeriesPropPanel.this.fNewSeriesType}, 1, AbstractSeriesPropPanel.this.changeSeriesTypeLsnr);
        }
    };
    protected MatlabListener changeSeriesTypeLsnr = new MatlabListener(){

        public void matlabEvent(final MatlabEvent matlabEvent) {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (matlabEvent.getStatus() != 0) {
                        ErrorHandler.showMatlabError("changeseriestype", matlabEvent, AbstractSeriesPropPanel.this.fMatlab);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AbstractSeriesPropPanel.this.fPlotTypeCB.setSelectedItem((Object)PLOTTYPE.getMatchingPlotType(AbstractSeriesPropPanel.this.getPlotType()));
                                AbstractSeriesPropPanel.this.fPlotTypeCB.setEnabled(true);
                            }
                        });
                    } else {
                        AbstractSeriesPropPanel.this.fMatlab.feval("selectobject", new Object[]{matlabEvent.getResult(), "replace"}, 0, AbstractSeriesPropPanel.this.selectObjectLsnr);
                    }
                }
            });
        }
    };
    protected MatlabListener selectObjectLsnr = new MatlabListener(){

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() != 0) {
                ErrorHandler.showMatlabError("selectobject", matlabEvent, AbstractSeriesPropPanel.this.fMatlab);
            }
            AbstractSeriesPropPanel.this.fPlotTypeCB.setEnabled(true);
        }
    };

    public AbstractSeriesPropPanel() {
        this.fNameTF = new TextControl("DisplayName", this, this.getPlotType());
        this.fNameTF.setWidth(60);
        this.protectSizeFromGridBag((JComponent)((Object)this.fNameTF));
        this.fNameLabel = new MJLabel(PropertyEditorResources.getBundle().getString("label.displayname"));
        this.fPlotTypeLabel = new MJLabel(PropertyEditorResources.getBundle().getString("label.plottype"));
        if (this.usesPlotTypeControl()) {
            this.fPlotTypeCB = (MJComboBox)this.createPlotTypeControl();
        }
        this.fAppearancePanel = this.createAppearancePanel();
        this.fDataSourcesPanel = this.createDataSourcesPanel();
        this.fButtonPanel = this.createButtonPanel(true);
        this.setLayout(new GridBagLayout());
        this.layoutControls();
    }

    protected abstract String getPlotType();

    protected String getSeriesName() {
        return this.getPlotType() + "Series";
    }

    protected String getGroupName() {
        return this.getPlotType() + "Group";
    }

    protected boolean usesPlotTypeControl() {
        return false;
    }

    protected abstract PlotSignature getPlotSignature();

    protected abstract void createAndLayoutAppearanceControls(MJPanel var1);

    protected JComponent createPlotTypeControl() {
        this.createIcons();
        this.fPlotTypeCB = new MJComboBox((Object[])PLOTTYPE.values());
        this.fPlotTypeCB.setSelectedItem((Object)PLOTTYPE.getMatchingPlotType(this.getPlotType()));
        this.fPlotTypeCB.setRenderer((ListCellRenderer)new PlotTypeRenderer());
        this.fPlotTypeCB.addActionListener(this.fPlotTypeCBLsnr);
        this.protectSizeFromGridBag((JComponent)this.fPlotTypeCB);
        this.fPlotTypeCB.setName("fPlotTypeCB");
        return this.fPlotTypeCB;
    }

    protected boolean isPropertyRequired(PlotArgDescriptor plotArgDescriptor) {
        return plotArgDescriptor.getRequired() == PlotArgDescriptor.RequiredType.REQUIRED;
    }

    protected MJPanel createDataSourcesPanel() {
        FormPanel formPanel = new FormPanel();
        formPanel.setRightAligned(false);
        formPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        PlotSignature plotSignature = this.getPlotSignature();
        PlotArgDescriptor[] plotArgDescriptorArray = plotSignature.getPrimaryArgs();
        for (int i = 0; i < plotArgDescriptorArray.length; ++i) {
            boolean bl = this.isPropertyRequired(plotArgDescriptorArray[i]);
            MJLabel mJLabel = new MJLabel(plotArgDescriptorArray[i].getLabel() + ":");
            String string = plotArgDescriptorArray[i].getName() + "DataSource";
            DataSourceControl dataSourceControl = new DataSourceControl(string, this, !bl, this.getPlotType());
            if (!bl) {
                dataSourceControl.setModePropertyName(plotArgDescriptorArray[i].getName() + "DataMode");
            }
            dataSourceControl.setWidth(60);
            formPanel.addRow((JLabel)mJLabel, (JComponent)((Object)dataSourceControl), 1);
        }
        return formPanel;
    }

    protected MJPanel createAppearancePanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.createAndLayoutAppearanceControls(mJPanel);
        return mJPanel;
    }

    protected void layoutControls() {
        this.removeAll();
        GridBagConstraints gridBagConstraints = PropertyPanel.createLabelGBC();
        GridBagConstraints gridBagConstraints2 = PropertyPanel.createControlGBC();
        gridBagConstraints2.insets = new Insets(PropertyPanel.VERT_SPACE, PropertyPanel.HORIZ_SPACE, PropertyPanel.VERT_SPACE, PropertyPanel.HORIZ_SPACE + 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.fNameLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 18;
        GridBagConstraints gridBagConstraints4 = PropertyPanel.createBottomSpacerGBC();
        gridBagConstraints4.gridx = 0;
        GridBagConstraints gridBagConstraints5 = PropertyPanel.createButtonGBC();
        if (this.fPropertyEditor == null || this.fPropertyEditor.isShowDataSources()) {
            this.fNameTF.setWidth(30);
            this.add((Component)((Object)this.fNameTF), gridBagConstraints2);
            gridBagConstraints3.insets = new Insets(PropertyPanel.VERT_SPACE + 2, 0, 0, PropertyPanel.HORIZ_SPACE + 4);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridheight = 2;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 1.0;
            this.add((Component)this.fDataSourcesPanel, gridBagConstraints3);
            if (this.fPropertyEditor != null && this.fPropertyEditor.isShowPlotType() && this.usesPlotTypeControl()) {
                gridBagConstraints2.gridy = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridx = 2;
                this.add((Component)this.fPlotTypeLabel, gridBagConstraints);
                gridBagConstraints2.gridx = 3;
                gridBagConstraints2.fill = 0;
                gridBagConstraints2.weightx = 0.0;
                MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(1, 1));
                mJPanel.add((Component)this.fPlotTypeCB);
                this.protectSizeFromGridBag((JComponent)mJPanel);
                this.add((Component)mJPanel, gridBagConstraints2);
            }
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(PropertyPanel.VERT_SPACE + 2, 0, 0, 0);
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridheight = 3;
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.weightx = 0.0;
            this.add((Component)this.fAppearancePanel, gridBagConstraints3);
            gridBagConstraints4.gridy = 5;
            this.add((Component)new MJLabel(""), gridBagConstraints4);
            gridBagConstraints5.gridx = 5;
            this.add(this.fButtonPanel, gridBagConstraints5);
        } else if (!this.fPropertyEditor.isShowDataSources()) {
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.weightx = 0.0;
            this.fNameTF.setWidth(150);
            this.add((Component)((Object)this.fNameTF), gridBagConstraints2);
            if (this.fPropertyEditor.isShowPlotType() && this.usesPlotTypeControl()) {
                gridBagConstraints2.gridy = 1;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.fPlotTypeLabel, gridBagConstraints);
                this.add((Component)this.fPlotTypeCB, gridBagConstraints2);
                gridBagConstraints3.gridy = 2;
            } else {
                gridBagConstraints3.gridy = 1;
            }
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.insets = new Insets(PropertyPanel.VERT_SPACE + 2, 0, 0, 0);
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.weightx = 0.0;
            this.add((Component)this.fAppearancePanel, gridBagConstraints3);
            gridBagConstraints4.gridy = 5;
            this.add((Component)new MJLabel(""), gridBagConstraints4);
            gridBagConstraints5.gridx = 2;
            this.add(this.fButtonPanel, gridBagConstraints5);
        }
    }

    @Override
    public void setPropertyEditor(PropertyEditor propertyEditor) {
        super.setPropertyEditor(propertyEditor);
        this.layoutControls();
    }

    public void setShowDataSources(boolean bl) {
        this.layoutControls();
    }

    public void setShowPlotType(boolean bl) {
        this.layoutControls();
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        if (this.usesPlotTypeControl()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractSeriesPropPanel.this.fIgnorePlotTypeChangeEvents = true;
                    AbstractSeriesPropPanel.this.fPlotTypeCB.setSelectedItem((Object)PLOTTYPE.getMatchingPlotType(AbstractSeriesPropPanel.this.getPlotType()));
                    AbstractSeriesPropPanel.this.fIgnorePlotTypeChangeEvents = false;
                }
            });
        }
    }

    protected void createIcons() {
        for (PLOTTYPE pLOTTYPE : PLOTTYPE.values()) {
            PlotSignature plotSignature = PlotMetadata.getPlotSignature((String)pLOTTYPE.getPlotMetadataID());
            ImageIcon imageIcon = new ImageIcon(plotSignature.getSmallIconURL());
            this.fIcons.put(pLOTTYPE.toString(), imageIcon);
        }
    }

    class PlotTypeRenderer
    extends DefaultListCellRenderer {
        public PlotTypeRenderer() {
            this.setHorizontalTextPosition(11);
            this.setIconTextGap(4);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == null) {
                return jLabel;
            }
            String string = object.toString();
            jLabel.setText(string);
            ImageIcon imageIcon = (ImageIcon)AbstractSeriesPropPanel.this.fIcons.get(string);
            jLabel.setIcon(imageIcon);
            return jLabel;
        }
    }

    private static enum PLOTTYPE {
        LINE(PropertyEditorResources.getBundle().getString("value.line"), "line", "plot"),
        BAR(PropertyEditorResources.getBundle().getString("value.bar"), "bar", "bar"),
        AREA(PropertyEditorResources.getBundle().getString("value.area"), "area", "area"),
        STAIRS(PropertyEditorResources.getBundle().getString("value.stairs"), "stairs", "stairs"),
        STEM(PropertyEditorResources.getBundle().getString("value.stem"), "stem", "stem");

        private String iPlotType;
        private String iPlotTypeLabel;
        private String iPlotMetadataID;

        private PLOTTYPE(String string2, String string3, String string4) {
            this.iPlotType = string3;
            this.iPlotTypeLabel = string2;
            this.iPlotMetadataID = string4;
        }

        public String toString() {
            return this.iPlotTypeLabel;
        }

        private String getMatlabPlotType() {
            return this.iPlotType;
        }

        private String getPlotMetadataID() {
            return this.iPlotMetadataID;
        }

        static PLOTTYPE getMatchingPlotType(String string) {
            for (PLOTTYPE pLOTTYPE : PLOTTYPE.values()) {
                if (!string.toLowerCase().equals(pLOTTYPE.getMatlabPlotType().toLowerCase())) continue;
                return pLOTTYPE;
            }
            return null;
        }
    }
}

