/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AppearanceFocusDispatcher
implements FocusListener {
    public static final String TEMPORARY_FOCUS_OWNER_KEY = "temporary-focus-owner";
    private Vector fListeners = new Vector();

    @Override
    public void focusGained(FocusEvent focusEvent) {
        AppearanceFocusEvent appearanceFocusEvent = new AppearanceFocusEvent(focusEvent);
        Enumeration enumeration = this.fListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((AppearanceFocusListener)enumeration.nextElement()).appearanceFocusGained(appearanceFocusEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (AppearanceFocusDispatcher.isTemporaryFocusOwner(focusEvent.getOppositeComponent())) {
            return;
        }
        if (!focusEvent.isTemporary()) {
            this.dispatchFocusLost(focusEvent);
        } else {
            Component component = focusEvent.getComponent();
            Component component2 = focusEvent.getOppositeComponent();
            if (component2 == null) {
                this.dispatchFocusLost(focusEvent);
            } else {
                Window window;
                Window window2 = SwingUtilities.getWindowAncestor(component);
                if (window2 != (window = SwingUtilities.getWindowAncestor(component2))) {
                    this.dispatchFocusLost(focusEvent);
                }
            }
        }
    }

    private void dispatchFocusLost(FocusEvent focusEvent) {
        AppearanceFocusEvent appearanceFocusEvent = new AppearanceFocusEvent(focusEvent);
        Enumeration enumeration = this.fListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((AppearanceFocusListener)enumeration.nextElement()).appearanceFocusLost(appearanceFocusEvent);
        }
    }

    public void addAppearanceFocusListener(AppearanceFocusListener appearanceFocusListener) {
        this.fListeners.add(appearanceFocusListener);
    }

    public void removeAppearanceFocusListener(AppearanceFocusListener appearanceFocusListener) {
        if (appearanceFocusListener != null) {
            this.fListeners.remove(appearanceFocusListener);
        }
    }

    private static boolean isTemporaryFocusOwner(Component component) {
        Boolean bl;
        if (component instanceof JComponent && (bl = (Boolean)((JComponent)component).getClientProperty(TEMPORARY_FOCUS_OWNER_KEY)) != null) {
            return bl;
        }
        return false;
    }
}

