/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.JComponent;
import javax.swing.UIManager;

public final class ColorUtils {
    public static final Color NORMAL_HYPERLINK_COLOR = Color.BLUE;
    public static final Color DARK_BACKGROUND_HYPERLINK_COLOR = new Color(128, 128, 255);
    public static final Color HYPERLINK_HOVER_COLOR = Color.RED;
    public static final Color MAC_ACTIVE_BOTTOM_COLOR = new Color(165, 174, 189);
    public static final Color MAC_ACTIVE_MIDDLE_COLOR = new Color(235, 243, 255);
    public static final Color MAC_INACTIVE_BOTTOM_COLOR = new Color(200, 200, 200);
    public static final Color MAC_INACTIVE_MIDDLE_COLOR = new Color(245, 245, 245);
    private static Color sLastColorToFade;
    private static Color sLastFadedColor;
    private static Color sLastColorToIntensify;
    private static Color sLastIntensifiedColor;

    private ColorUtils() {
    }

    public static Color getTextSelectionForegroundColor() {
        return PlatformInfo.isMacintosh() ? SystemColor.textHighlightText : UIManager.getColor("textHighlightText");
    }

    public static Color getTextSelectionBackgroundColor() {
        return PlatformInfo.isMacintosh() ? SystemColor.textHighlight : UIManager.getColor("textHighlight");
    }

    public static Color getSelectionForegroundColor() {
        return UIManager.getColor("List.selectionForeground");
    }

    public static Color getSelectionBackgroundColor() {
        return UIManager.getColor("List.selectionBackground");
    }

    public static Color getUnfocusedSelectionForegroundColor(Component component) {
        Color color;
        Color color2 = ColorUtils.getListItemUnfocusedSelectionForeground();
        if (!ColorUtils.areContrasting(color2, color = ColorUtils.getUnfocusedSelectionBackgroundColor(component))) {
            color2 = ColorUtils.getBlackOrWhiteContrasting(color);
        }
        return color2;
    }

    private static Color getListItemUnfocusedSelectionForeground() {
        return UIManager.getColor("List.foreground");
    }

    private static Color getListItemUnfocusedSelectionBackground() {
        return PlatformInfo.isMacintosh() ? new Color(212, 212, 212) : UIManager.getColor("control");
    }

    public static Color getUnfocusedSelectionBackgroundColor(Component component) {
        Color color;
        Color color2 = ColorUtils.getListItemUnfocusedSelectionBackground();
        if (!ColorUtils.areBackgroundsContrasting(color2, color = component.getBackground())) {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            fArray[2] = fArray[2] < 0.25f ? 0.5f : fArray[2] * 0.67f;
            color2 = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        }
        return color2;
    }

    public static boolean isDark(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return fArray[2] < 0.5f;
    }

    public static boolean areContrasting(Color color, Color color2) {
        return ColorUtils.areColorsContrasting(color, color2, 12288);
    }

    public static boolean areBackgroundsContrasting(Color color, Color color2) {
        return ColorUtils.areColorsContrasting(color, color2, 1000);
    }

    private static boolean areColorsContrasting(Color color, Color color2, int n) {
        int n2;
        int n3;
        if (color == null || color2 == null) {
            return false;
        }
        int n4 = color.getRed() - color2.getRed();
        return n4 * n4 + (n3 = color.getGreen() - color2.getGreen()) * n3 + (n2 = color.getBlue() - color2.getBlue()) * n2 > n;
    }

    public static Color getBlackOrWhiteContrasting(Color color) {
        return ColorUtils.isDark(color) ? Color.white : Color.black;
    }

    public static Color getContrastingHyperlinkColor(Color color) {
        return ColorUtils.isDark(color) ? DARK_BACKGROUND_HYPERLINK_COLOR : NORMAL_HYPERLINK_COLOR;
    }

    public static Color getDarkenedHeadingForeground(JComponent jComponent) {
        Color color = jComponent.getBackground();
        if (color.getRed() < 50 && color.getGreen() < 50 && color.getBlue() < 50) {
            return Color.white;
        }
        return jComponent.getForeground();
    }

    public static Color getDarkenedHeadingBackground(JComponent jComponent) {
        Color color = jComponent.getBackground();
        if (color.getRed() < 50 && color.getGreen() < 50 && color.getBlue() < 50) {
            color = color.brighter();
        } else {
            int n = 7 * color.getRed() / 8;
            int n2 = 7 * color.getGreen() / 8;
            int n3 = 7 * color.getBlue() / 8;
            color = new Color(n, n2, n3);
        }
        return color;
    }

    public static Color convertToCurrentColorScheme(Color color, Color color2) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        int n = Color.HSBtoRGB(fArray2[0], fArray2[1], fArray[2]);
        return new Color(n);
    }

    public static Color[] createGradientRange(Color color, Color color2, int n) {
        Color[] colorArray = new Color[n];
        colorArray[n - 1] = color2;
        colorArray[0] = color;
        int n2 = (color2.getRed() - color.getRed()) / (colorArray.length - 1);
        int n3 = (color2.getGreen() - color.getGreen()) / (colorArray.length - 1);
        int n4 = (color2.getBlue() - color.getBlue()) / (colorArray.length - 1);
        for (int i = 1; i < colorArray.length - 1; ++i) {
            colorArray[i] = new Color(Math.min(255, Math.max(0, colorArray[i - 1].getRed() + n2)), Math.min(255, Math.max(0, colorArray[i - 1].getGreen() + n3)), Math.min(255, Math.max(0, colorArray[i - 1].getBlue() + n4)));
        }
        return colorArray;
    }

    public static Color getContrastingForegroundVariant(Color color, Color color2) {
        Color color3 = color2;
        while (!ColorUtils.areContrasting(color3, color) && !(ColorUtils.isDark(color) ? (color3 = color3.brighter()).equals(Color.WHITE) : (color3 = color3.darker()).equals(Color.BLACK))) {
        }
        return color3;
    }

    public static Color fade(Color color) {
        if (!color.equals(sLastColorToFade)) {
            sLastColorToFade = color;
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if (fArray[1] >= 0.4f) {
                fArray[1] = 0.4f;
            }
            if (fArray[2] < 0.75f) {
                fArray[2] = 0.75f;
            }
            sLastFadedColor = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        }
        return sLastFadedColor;
    }

    public static Color intensify(Color color) {
        if (!color.equals(sLastColorToIntensify)) {
            sLastColorToIntensify = color;
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if (fArray[1] < 0.1f) {
                fArray[2] = fArray[2] * 0.75f;
            } else {
                if (fArray[1] < 0.6f) {
                    fArray[1] = 0.6f;
                }
                if (fArray[2] > 0.75f) {
                    fArray[2] = 0.75f;
                }
            }
            sLastIntensifiedColor = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        }
        return sLastIntensifiedColor;
    }

    public static Color darker(Color color, double d) {
        double d2 = Math.abs(d);
        return new Color(Math.min((int)((double)color.getRed() * d2), 255), Math.min((int)((double)color.getGreen() * d2), 255), Math.min((int)((double)color.getBlue() * d2), 255));
    }

    public static Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        double d2 = Math.abs(d);
        if (d2 < 0.001) {
            return Color.white;
        }
        int n4 = (int)(1.0 / (1.0 - d2));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n4, n4, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / d2), 255), Math.min((int)((double)n2 / d2), 255), Math.min((int)((double)n3 / d2), 255));
    }
}

