/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconUtils {
    private static final Color SELECTION_ALPHA_COLOR;

    public static Icon createSelectedIcon(Icon icon) {
        if (!(icon instanceof ImageIcon)) {
            return icon;
        }
        if (PlatformInfo.isMacintosh()) {
            return icon;
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.setColor(SELECTION_ALPHA_COLOR);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static Icon createGhostedIcon(Icon icon) {
        return IconUtils.createGhostedIcon(icon, 0.45f);
    }

    public static Icon createGhostedIcon(Icon icon, float f) {
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - f / 100.0f));
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static Icon createBadgedIcon(ImageIcon imageIcon, ImageIcon imageIcon2, int n, int n2, int n3, int n4) {
        if (imageIcon == null) {
            throw new IllegalArgumentException("'baseIcon' cannot be null");
        }
        if (imageIcon2 == null) {
            throw new IllegalArgumentException("'baseIcon' cannot be null");
        }
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics2D.drawImage(imageIcon2.getImage(), n, n2, n3, n4, null);
        return new ImageIcon(bufferedImage);
    }

    public static Icon createBadgedIcon(ImageIcon imageIcon, ImageIcon imageIcon2, int n, int n2) {
        return IconUtils.createBadgedIcon(imageIcon, imageIcon2, n, n2, imageIcon2.getIconWidth(), imageIcon2.getIconHeight());
    }

    public static ImageIcon changeIconColor(ImageIcon imageIcon, Color color) {
        ImageIcon imageIcon2 = new ImageIcon();
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcIn);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        imageIcon2.setImage(bufferedImage);
        return imageIcon2;
    }

    public static Icon move(Icon icon, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(null, graphics, n, n2);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }

    private IconUtils() {
    }

    static {
        Color color = ColorUtils.getSelectionBackgroundColor();
        SELECTION_ALPHA_COLOR = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }
}

