/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class MGridLayout
implements LayoutManager {
    public static final int ONE_SIZE_FITS_ALL = 0;
    public static final int COLUMN_VARIABLE = 65536;
    public static final int ROW_VARIABLE = 131072;
    public static final int GRID_VARIABLE = 196608;
    public static final int EXPAND_COLUMN = 327680;
    private static final int EXPAND_ROW = 655360;
    private int fHgap;
    private int fVgap;
    private int fRows;
    private int fCols;
    private int fGridConstraint;
    private float fColAlign;
    private float fRowAlign;
    private float[] fColAlignments;
    private float[] fRowAlignments;
    private int[] fHeights;
    private int[] fWidths;
    private int fColFit;
    private int fRowFit;
    private int fExpandRow;

    public MGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public MGridLayout(int n, int n2, int n3, int n4) {
        this.fColAlign = -1.0f;
        this.fRowAlign = -1.0f;
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("invalid rows,cols");
        }
        this.fRows = n;
        this.fCols = n2;
        this.fHgap = n3;
        this.fVgap = n4;
        this.fGridConstraint = 983040;
        this.fColFit = 100;
        this.fRowFit = 100;
    }

    public MGridLayout(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, null, null);
    }

    public MGridLayout(int n, int n2, int n3, int n4, int n5, Object object, Object object2) {
        block11: {
            int n6;
            block12: {
                block13: {
                    block8: {
                        block9: {
                            block10: {
                                this.fColAlign = -1.0f;
                                this.fRowAlign = -1.0f;
                                if (n == 0 && n2 == 0) {
                                    throw new IllegalArgumentException("invalid rows,cols");
                                }
                                this.fRows = n;
                                this.fCols = n2;
                                this.fHgap = n3;
                                this.fVgap = n4;
                                if (n5 < 0 || (n5 & 0xF0000) > 458752) {
                                    n5 = 0;
                                }
                                this.fGridConstraint = n5;
                                this.fColFit = 100;
                                this.fRowFit = 100;
                                if (object == null) break block8;
                                if (!(object instanceof Float)) break block9;
                                this.fColAlign = ((Float)object).floatValue();
                                if (!(this.fColAlign < 0.0f)) break block10;
                                this.fColAlign = 0.0f;
                                break block8;
                            }
                            if (!(this.fColAlign > 1.0f)) break block8;
                            this.fColAlign = 1.0f;
                            break block8;
                        }
                        if (object instanceof float[]) {
                            this.fColAlign = 0.0f;
                            this.fColAlignments = (float[])object;
                            for (n6 = 0; n6 < this.fColAlignments.length; ++n6) {
                                if (this.fColAlignments[n6] < 0.0f) {
                                    this.fColAlignments[n6] = 0.0f;
                                    continue;
                                }
                                if (!(this.fColAlignments[n6] > 1.0f)) continue;
                                this.fColAlignments[n6] = 1.0f;
                            }
                        }
                    }
                    if (object2 == null) break block11;
                    if (!(object2 instanceof Float)) break block12;
                    this.fRowAlign = ((Float)object2).floatValue();
                    if (!(this.fRowAlign < 0.0f)) break block13;
                    this.fRowAlign = 0.0f;
                    break block11;
                }
                if (!(this.fRowAlign > 1.0f)) break block11;
                this.fRowAlign = 1.0f;
                break block11;
            }
            if (object2 instanceof float[]) {
                this.fRowAlign = 0.0f;
                this.fRowAlignments = (float[])object2;
                for (n6 = 0; n6 < this.fRowAlignments.length; ++n6) {
                    if (this.fRowAlignments[n6] < 0.0f) {
                        this.fRowAlignments[n6] = 0.0f;
                        continue;
                    }
                    if (!(this.fRowAlignments[n6] > 1.0f)) continue;
                    this.fRowAlignments[n6] = 1.0f;
                }
            }
        }
    }

    public void setColFit(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.fColFit = n;
    }

    public void setRowFit(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.fRowFit = n;
    }

    public void setExpandRow(int n) {
        if (n < 0) {
            n = 0;
            this.fGridConstraint &= 0xFFF5FFFF;
        } else {
            this.fGridConstraint |= 0xA0000;
        }
        this.fExpandRow = n;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension calcLayoutSize(Container container, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Dimension dimension;
            int n2;
            boolean bl2;
            int n3 = this.fRows;
            int n4 = this.fCols;
            int n5 = container.getComponentCount();
            if (n3 > 0) {
                n4 = (n5 + n3 - 1) / n3;
            } else {
                n3 = (n5 + n4 - 1) / n4;
            }
            boolean bl3 = bl2 = (this.fGridConstraint & 0x20000) == 131072;
            if ((this.fGridConstraint & 0x10000) == 65536 && (this.fWidths == null || this.fWidths.length != n4)) {
                this.fWidths = new int[n4];
            } else if (this.fWidths != null) {
                for (n2 = 0; n2 < n4; ++n2) {
                    this.fWidths[n2] = 0;
                }
            }
            if ((this.fGridConstraint & 0x20000) == 131072 && (this.fHeights == null || this.fHeights.length != n3)) {
                this.fHeights = new int[n3];
            } else if (this.fHeights != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    this.fHeights[n2] = 0;
                }
            }
            int n6 = 0;
            int n7 = 0;
            int n8 = n5 - n4;
            n8 = n8 < 0 || n5 < n3 ? n5 - 1 : n4 * (n3 - 1);
            for (int i = 0; i < n4; ++i) {
                n2 = 0;
                int n9 = 0;
                if (n8 < n5) {
                    ++n8;
                }
                for (int j = i; j < n8; j += n4) {
                    Component component = container.getComponent(j);
                    dimension = bl ? component.getPreferredSize() : component.getMinimumSize();
                    if (dimension.width > n9) {
                        n9 = dimension.width;
                    }
                    if (this.fHeights != null) {
                        if (dimension.height > this.fHeights[n2]) {
                            this.fHeights[n2] = dimension.height;
                        }
                        ++n2;
                        continue;
                    }
                    if (dimension.height <= n6) continue;
                    n6 = dimension.height;
                }
                n7 += n9;
                if (this.fWidths == null || n9 <= this.fWidths[i]) continue;
                this.fWidths[i] = n9;
            }
            if (bl2) {
                n = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    n += this.fHeights[n2];
                }
            } else {
                n = n3 * n6;
            }
            Insets insets = container.getInsets();
            dimension = new Dimension(insets.left + insets.right + n7 + (n4 - 1) * this.fHgap, insets.top + insets.bottom + n + (n3 - 1) * this.fVgap);
            return dimension;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.calcLayoutSize(container, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.calcLayoutSize(container, false);
    }

    private void scaleToFit(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n2 > n4) {
            n2 = n4;
        }
        int n7 = 0;
        for (n6 = 0; n6 < nArray.length; ++n6) {
            n7 += nArray[n6];
        }
        if ((n7 += (n4 - 1) * n) > n5) {
            int n8;
            int n9 = 0;
            n6 = n2;
            if (n6 > 0) {
                n9 = nArray[n6 - 1];
                if (n7 - (n9 = (100 - n3) * n9 / 100) <= n5) {
                    n9 = n7 - n5;
                }
                int n10 = n6 - 1;
                nArray[n10] = nArray[n10] - n9;
            }
            if ((n8 = n7 - n5 - n9) > 0) {
                int n11 = 0;
                n9 = 0;
                n6 = 0;
                while (n6 < n4) {
                    n11 = nArray[n6] * n8 + n11;
                    int n12 = n11 / n7;
                    int n13 = n6++;
                    nArray[n13] = nArray[n13] - n12;
                    n9 += n12;
                    n11 %= n7;
                }
                if (n6 > 0 && n9 < n8) {
                    int n14 = n6 - 1;
                    nArray[n14] = nArray[n14] - (n8 - n9);
                }
            }
        } else if (n7 < n5) {
            n6 = n2;
            int n15 = n5 - n7;
            if (n6 == 0) {
                if (n7 > 0) {
                    int n16 = 0;
                    int n17 = 0;
                    n6 = 0;
                    while (n6 < n4) {
                        n16 = nArray[n6] * n15 + n16;
                        int n18 = n16 / n7;
                        int n19 = n6++;
                        nArray[n19] = nArray[n19] + n18;
                        n17 += n18;
                        n16 %= n7;
                    }
                    if (n6 > 0 && n17 < n15) {
                        int n20 = n6 - 1;
                        nArray[n20] = nArray[n20] + (n15 - n17);
                    }
                }
            } else {
                int n21 = n6 - 1;
                nArray[n21] = nArray[n21] + n15;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component component;
            int n;
            int n2;
            int n3;
            int n4 = container.getComponentCount();
            if (n4 == 0) {
                return;
            }
            int n5 = this.fRows;
            int n6 = this.fCols;
            if (n5 > 0) {
                n6 = (n4 + n5 - 1) / n5;
            } else {
                n5 = (n4 + n6 - 1) / n6;
            }
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n7 = dimension.width - (insets.left + insets.right);
            int n8 = dimension.height - (insets.top + insets.bottom);
            if (n7 == 0 || n8 == 0) {
                return;
            }
            if ((this.fGridConstraint & 0x10000) == 65536) {
                this.calcLayoutSize(container, true);
                if ((this.fGridConstraint & 0x50000) == 327680) {
                    this.scaleToFit(this.fWidths, this.fHgap, this.fGridConstraint & 0xFFFF, this.fColFit, n6, n7);
                }
            } else {
                n7 = (n7 - (n6 - 1) * this.fHgap) / n6;
            }
            if ((this.fGridConstraint & 0x20000) == 131072) {
                n3 = n4 - n6;
                n3 = n3 < 0 || n4 < n5 ? n4 - 1 : n6 * (n5 - 1);
                for (n2 = 0; n2 < n6; ++n2) {
                    if (this.fWidths != null) {
                        n7 = this.fWidths[n2];
                    }
                    if (n3 < n4) {
                        ++n3;
                    }
                    for (n = n2; n < n3; n += n6) {
                        component = container.getComponent(n);
                        component.setSize(n7, n8);
                    }
                }
                n = this.fGridConstraint & 0x10000;
                this.fGridConstraint &= 0xFFFEFFFF;
                int[] nArray = this.fWidths;
                this.fWidths = null;
                this.calcLayoutSize(container, true);
                this.fWidths = nArray;
                this.fGridConstraint |= n;
                if ((this.fGridConstraint & 0xA0000) == 655360) {
                    this.scaleToFit(this.fHeights, this.fVgap, this.fExpandRow, this.fRowFit, n5, n8);
                }
            } else {
                n8 = (n8 - (n5 - 1) * this.fVgap) / n5;
            }
            n3 = n4 - n6;
            n3 = n3 < 0 || n4 < n5 ? n4 - 1 : n6 * (n5 - 1);
            if (this.fColAlign >= 0.0f || this.fRowAlign >= 0.0f) {
                this.doLayoutAndAlign(container, insets, n7, n8, n6, n5, n3);
            } else {
                int n9 = insets.left;
                for (n2 = 0; n2 < n6; ++n2) {
                    int n10 = insets.top;
                    if (this.fWidths != null) {
                        n7 = this.fWidths[n2];
                    }
                    if (n3 < n4) {
                        ++n3;
                    }
                    int n11 = 0;
                    for (n = n2; n < n3; n += n6) {
                        if (this.fHeights != null) {
                            n8 = this.fHeights[n11];
                        }
                        component = container.getComponent(n);
                        component.setSize(n7, n8);
                        component.setLocation(n9, n10);
                        n10 += n8 + this.fVgap;
                        ++n11;
                    }
                    n9 += n7 + this.fHgap;
                }
            }
        }
    }

    private void doLayoutAndAlign(Container container, Insets insets, int n, int n2, int n3, int n4, int n5) {
        int n6 = container.getComponentCount();
        int n7 = this.fColAlignments != null ? this.fColAlignments.length : 0;
        int n8 = this.fRowAlignments != null ? this.fRowAlignments.length : 0;
        int n9 = insets.left;
        for (int i = 0; i < n3; ++i) {
            int n10 = insets.top;
            if (this.fWidths != null) {
                n = this.fWidths[i];
            }
            if (n5 < n6) {
                ++n5;
            }
            float f = i < n7 ? this.fColAlignments[i] : this.fColAlign;
            int n11 = 0;
            for (int j = i; j < n5; j += n3) {
                int n12;
                int n13;
                int n14;
                int n15;
                if (this.fHeights != null) {
                    n2 = this.fHeights[n11];
                }
                float f2 = n11 < n8 ? this.fRowAlignments[n11] : this.fRowAlign;
                Component component = container.getComponent(j);
                Dimension dimension = component.getPreferredSize();
                if (dimension.width < n && f >= 0.0f) {
                    n15 = n9 + (int)(f * (float)(n - dimension.width));
                    n14 = dimension.width;
                } else {
                    n15 = n9;
                    n14 = n;
                }
                if (dimension.height < n2 && f2 >= 0.0f) {
                    n13 = n10 + (int)(f2 * (float)(n2 - dimension.height));
                    n12 = dimension.height;
                } else {
                    n13 = n10;
                    n12 = n2;
                }
                component.setSize(n14, n12);
                component.setLocation(n15, n13);
                n10 += n2 + this.fVgap;
                ++n11;
            }
            n9 += n + this.fHgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.fHgap + ",vgap=" + this.fVgap + ",rows=" + this.fRows + ",cols=" + this.fCols + ",gridConstraint=" + Integer.toHexString(this.fGridConstraint) + "]";
    }
}

