/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.jgoodies.looks.common.ComboBoxEditorTextField;
import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.ItemSafetyListener;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.mwswing.SelectAllOnFocusListener;
import com.mathworks.mwswing.binding.DefaultKeyBindings;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.mwswing.plaf.MWindowsComboBoxUI;
import com.mathworks.mwswing.plaf.PlafUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboPopup;

public class MJComboBox
extends JComboBox
implements KeyBindingManagerRegistrant {
    private ListDataListener fModelSafetyListener;
    private boolean fConstrainPopupWidth;
    private BasicComboPopup fPopup;
    private Object fPreviousSelection;
    private boolean fShowTipWhenTruncated;

    public MJComboBox() {
        this.doDefaultSetup();
    }

    public MJComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.doDefaultSetup();
    }

    public MJComboBox(Object[] objectArray) {
        super(objectArray);
        this.doDefaultSetup();
    }

    public MJComboBox(Vector<?> vector) {
        super(vector);
        this.doDefaultSetup();
    }

    public MJComboBox(List<?> list) {
        this(list.toArray());
    }

    @Override
    public void updateUI() {
        BareSwingDetector.exempt();
        if (PlafUtils.isWindowsLookAndFeel()) {
            this.setUI((ComboBoxUI)((Object)new MWindowsComboBoxUI()));
        } else {
            super.updateUI();
        }
        BareSwingDetector.reinstate();
        if (!(this.renderer instanceof BasicComboBoxEditor.UIResource) && this.renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)this.renderer));
        }
    }

    protected void super_updateUI() {
        super.updateUI();
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (mouseListener == null) {
            return;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JButton)) continue;
            component.addMouseListener(new DelegatingMouseListener(mouseListener, this));
            break;
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (mouseListener == null) {
            return;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JButton)) continue;
            MJComboBox.removeDelegate(mouseListener, component);
            break;
        }
    }

    private static void removeDelegate(MouseListener mouseListener, Component component) {
        for (MouseListener mouseListener2 : component.getMouseListeners()) {
            MouseListener mouseListener3 = mouseListener2;
            if (!(mouseListener3 instanceof DelegatingMouseListener) || ((DelegatingMouseListener)mouseListener3).getOriginalListener() != mouseListener) continue;
            component.removeMouseListener(mouseListener3);
            break;
        }
    }

    @Override
    public void setPopupVisible(boolean bl) {
        Accessible accessible = this.getUI().getAccessibleChild(this, 0);
        if (accessible != null && accessible instanceof BasicComboPopup) {
            this.fPopup = (BasicComboPopup)accessible;
        }
        super.setPopupVisible(bl);
    }

    protected void doDefaultSetup() {
        this.addSafetyListeners();
        if (PlafUtils.isPlasticLookAndFeel()) {
            boolean bl = Boolean.TRUE.equals(this.getClientProperty("JComboBox.isTableCellEditor"));
            this.setEditor(new FixedPlasticComboBoxEditor(bl));
        }
        this.initializeTextFieldEditor(DefaultKeyBindings.getManager(), "DefaultContext");
        this.installEscapeListener();
        this.addComponentListener(this.createResizeListener());
        this.addItemListener(this.createSelectionListener());
    }

    @Override
    public void registerWithKeyBindingManager(KeyBindingManager keyBindingManager, String string) {
        this.initializeTextFieldEditor(keyBindingManager, string);
    }

    private void initializeTextFieldEditor(KeyBindingManager keyBindingManager, String string) {
        Component component = this.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            MJTextField.initialize((JTextField)component, SelectAllOnFocusListener.SelectAllBehavior.ALWAYS, keyBindingManager, string);
        }
    }

    protected ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MJComboBox.this.updateToolTipTextIfNecessary();
            }
        };
    }

    protected ItemListener createSelectionListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MJComboBox.this.updateToolTipTextIfNecessary();
            }
        };
    }

    private void updateToolTipTextIfNecessary() {
        if (this.isEditable() && this.fShowTipWhenTruncated && this.getEditor() != null && this.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
            String string = this.isSelectedItemTruncated() && this.isEnabled() ? jTextField.getText() : null;
            jTextField.setToolTipText(string);
        }
    }

    public void setConstrainPopupWidth(boolean bl) {
        this.fConstrainPopupWidth = bl;
    }

    public boolean isPopupWidthConstrained() {
        return this.fConstrainPopupWidth;
    }

    public void setTipWhenTruncatedEnabled(boolean bl) {
        this.fShowTipWhenTruncated = bl;
        this.updateToolTipTextIfNecessary();
    }

    public boolean isTipWhenTruncatedEnabled() {
        return this.fShowTipWhenTruncated;
    }

    public void setEditorColumnCount(int n) {
        if (this.getEditor() != null && this.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
            jTextField.setColumns(n);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (!this.isMinimumSizeSet()) {
            dimension.width = 20;
        }
        return dimension;
    }

    protected void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.fModelSafetyListener = new ModelSafetyListener();
            this.getModel().addListDataListener(this.fModelSafetyListener);
            this.addItemListener(new ItemSafetyListener(this));
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    protected void installEscapeListener() {
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                if (MJComboBox.this.isEditable() && MJComboBox.this.editor != null) {
                    MJComboBox.this.fPreviousSelection = MJComboBox.this.editor.getItem();
                } else {
                    MJComboBox.this.fPreviousSelection = MJComboBox.this.getSelectedItem();
                }
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (MJComboBox.this.isPopupVisible() && keyEvent.getKeyCode() == 27) {
                    if (MJComboBox.this.isEditable() && MJComboBox.this.editor != null) {
                        MJComboBox.this.editor.setItem(MJComboBox.this.fPreviousSelection);
                    }
                    MJComboBox.this.setSelectedItem(MJComboBox.this.fPreviousSelection);
                }
            }
        };
        this.addKeyListener(keyAdapter);
    }

    @Override
    public void setEditable(boolean bl) {
        AccessibleContext accessibleContext;
        super.setEditable(bl);
        if (bl && (accessibleContext = this.getEditor().getEditorComponent().getAccessibleContext()).getAccessibleName() == null) {
            accessibleContext.setAccessibleName(this.getAccessibleContext().getAccessibleName());
        }
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        if (this.fModelSafetyListener != null) {
            ComboBoxModel comboBoxModel2 = this.getModel();
            comboBoxModel2.removeListDataListener(this.fModelSafetyListener);
            comboBoxModel.addListDataListener(this.fModelSafetyListener);
        }
        super.setModel(comboBoxModel);
    }

    JScrollPane getPopupScrollPane() {
        Component component;
        if (this.fPopup != null && this.isPopupVisible() && (component = this.fPopup.getComponent(0)) instanceof JScrollPane) {
            return (JScrollPane)component;
        }
        return null;
    }

    private boolean isSelectedItemTruncated() {
        assert (this.isEditable()) : "Item truncation determination is only supported for editable combo-boxes.";
        Component component = this.getEditor() == null ? null : this.getEditor().getEditorComponent();
        return component != null && component.getPreferredSize().width > component.getWidth();
    }

    private static class FixedPlasticComboBoxEditor
    extends BasicComboBoxEditor {
        private FixedPlasticComboBoxEditor(boolean bl) {
            this.editor = new ComboBoxEditorTextField(bl);
        }
    }

    private class ModelSafetyListener
    implements ListDataListener {
        private ModelSafetyListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            if (MJComboBox.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            if (MJComboBox.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (MJComboBox.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private static class DelegatingMouseListener
    implements MouseListener {
        private final MouseListener fListener;
        private final Component fSource;

        DelegatingMouseListener(MouseListener mouseListener, Component component) {
            this.fListener = mouseListener;
            this.fSource = component;
        }

        public MouseListener getOriginalListener() {
            return this.fListener;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.fListener.mouseClicked(this.convertEvent(mouseEvent));
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.fListener.mouseEntered(this.convertEvent(mouseEvent));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.fListener.mouseExited(this.convertEvent(mouseEvent));
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.fListener.mousePressed(this.convertEvent(mouseEvent));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.fListener.mouseReleased(this.convertEvent(mouseEvent));
        }

        private MouseEvent convertEvent(MouseEvent mouseEvent) {
            return SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, this.fSource);
        }
    }
}

