/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MJWindow;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputAdapter;

public class MJDimensionPicker
extends MJPanel {
    protected Dimension fGridSize = new Dimension();
    protected Dimension fSelectedSize = new Dimension();
    protected Dimension fLimitSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected int fOccupancy;
    protected boolean fColumnMajorOccupancy;
    protected boolean fAutoGrow;
    protected Component fInvoker;
    protected Window fInvokerWindow;
    protected JMenu fInvokingMenu;
    protected MouseHandler fMouseHandler = new MouseHandler();
    protected KeyHandler fKeyHandler = new KeyHandler();
    protected EventForwarder fEventForwarder;
    protected MJWindow fWindow;
    protected JPopupMenu fPopupMenu;
    protected MJLabel fDimensionLabel;
    protected GridPanel fGridPanel;
    protected ActionListener fActionListener;
    protected ActionListener fCancelListener;
    protected Closer fCloser = new Closer();
    protected boolean fMouseIsOver;
    protected boolean fMouseHasEntered;
    private Color fOccupiedColor;
    private Color fSelectedColor;
    private static final Dimension DEFAULT_GRID_SIZE = new Dimension(4, 4);
    public static final Dimension CELL_SIZE = new Dimension(32, 32);
    public static final String WINDOW_NAME = "DimensionPickerWindow";

    public MJDimensionPicker() {
        this(DEFAULT_GRID_SIZE, 0);
    }

    public MJDimensionPicker(Dimension dimension) {
        this(dimension, 0);
    }

    public MJDimensionPicker(Dimension dimension, int n) {
        this.fGridSize.setSize(dimension);
        this.fOccupancy = n;
        this.setLayout(new BorderLayout());
        this.fDimensionLabel = new MJLabel(MJUtilities.intlString("labelCancel"));
        this.fDimensionLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.fDimensionLabel.setHorizontalAlignment(0);
        this.fDimensionLabel.setBackground(UIManager.getColor("Menu.background"));
        this.fDimensionLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MJDimensionPicker.this.close(true);
            }
        });
        this.add((Component)this.fDimensionLabel, "South");
        this.fGridPanel = new GridPanel();
        this.fGridPanel.addMouseListener(this.fMouseHandler);
        this.fGridPanel.addMouseMotionListener(this.fMouseHandler);
        this.add((Component)this.fGridPanel, "Center");
        this.setFocusable(true);
        this.addKeyListener(this.fKeyHandler);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    public synchronized void addCancelationListener(ActionListener actionListener) {
        this.fCancelListener = AWTEventMulticaster.add(this.fCancelListener, actionListener);
    }

    public synchronized void removeCancelationListener(ActionListener actionListener) {
        this.fCancelListener = AWTEventMulticaster.remove(this.fCancelListener, actionListener);
    }

    public void setOccupancy(int n) {
        if (n != this.fOccupancy) {
            this.fOccupancy = n;
            this.repaint();
        }
    }

    public void setColumnMajorOccupancy(boolean bl) {
        this.fColumnMajorOccupancy = bl;
    }

    public void setAutoGrowEnabled(boolean bl) {
        this.fAutoGrow = bl;
    }

    public Dimension getSelectedSize() {
        return new Dimension(this.fSelectedSize);
    }

    public void setSizeLimit(Dimension dimension) {
        this.fLimitSize.setSize(dimension);
    }

    public Dimension getSizeLimit() {
        return new Dimension(this.fLimitSize);
    }

    public void setOccupiedColor(Color color) {
        this.fOccupiedColor = color;
    }

    public Color getOccupiedColor() {
        return this.fOccupiedColor != null ? this.fOccupiedColor : UIManager.getColor("Menu.selectionBackground");
    }

    public void setSelectedColor(Color color) {
        this.fSelectedColor = color;
    }

    public Color getSelectedColor() {
        return this.fSelectedColor != null ? this.fSelectedColor : Color.gray;
    }

    public void show(Component component, int n, int n2) {
        this.fInvoker = component;
        component.addKeyListener(this.fKeyHandler);
        component.addMouseListener(this.fMouseHandler);
        component.addMouseMotionListener(this.fMouseHandler);
        Window window = component instanceof Window ? (Window)component : SwingUtilities.windowForComponent(component);
        this.fWindow = new MJWindow(window);
        this.fWindow.setName(WINDOW_NAME);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.fWindow.getContentPane().setLayout(new BorderLayout());
        this.fWindow.getContentPane().add((Component)this, "Center");
        Dimension dimension = this.getPreferredSize();
        Point point = MJUtilities.getPopupLocation(component, dimension, new Point(n, n2));
        this.fMouseHasEntered = false;
        this.fWindow.setLocation(point);
        this.fWindow.setSize(dimension);
        this.fWindow.setVisible(true);
        this.fInvokerWindow = SwingUtilities.getWindowAncestor(component);
        if (this.fInvokerWindow != null) {
            this.fInvokerWindow.addWindowListener(this.fCloser);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fCloser, 16L);
    }

    public void setInvokingMenu(JMenu jMenu) {
        Container container;
        if (this.fInvokingMenu != jMenu) {
            if (jMenu != null) {
                if (this.fEventForwarder == null) {
                    this.fEventForwarder = new EventForwarder();
                }
                Toolkit.getDefaultToolkit().addAWTEventListener(this.fEventForwarder, 56L);
            } else if (this.fEventForwarder != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.fEventForwarder);
            }
            this.fInvokingMenu = jMenu;
        }
        if ((container = this.getParent()) instanceof JPopupMenu) {
            this.fPopupMenu = (JPopupMenu)container;
            this.grow();
        }
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean bl) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fCloser);
        if (this.fInvokerWindow != null) {
            this.fInvokerWindow.removeWindowListener(this.fCloser);
            this.fInvokerWindow = null;
        }
        if (this.fWindow != null) {
            this.fInvoker.removeKeyListener(this.fKeyHandler);
            this.fInvoker.removeMouseListener(this.fMouseHandler);
            this.fInvoker.removeMouseMotionListener(this.fMouseHandler);
            this.fWindow.remove(this);
            this.fWindow.dispose();
            this.fWindow = null;
        }
        if (this.fInvokingMenu != null) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            this.fInvokingMenu = null;
        }
        this.fMouseIsOver = false;
        this.fMouseHasEntered = false;
        this.fInvoker = null;
        if (bl && this.fCancelListener != null) {
            this.fCancelListener.actionPerformed(new ActionEvent(this, 0, "canceled"));
        }
    }

    protected void grow() {
        Dimension dimension = this.getPreferredSize();
        if (this.fWindow != null) {
            Point point = MJUtilities.ensureOnScreen(this.fWindow.getLocation(), dimension, 10);
            this.fWindow.setLocation(point);
            this.fWindow.setSize(dimension);
            this.fWindow.invalidate();
            this.fWindow.validate();
        } else if (this.fPopupMenu != null) {
            Insets insets = this.fPopupMenu.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            this.fPopupMenu.setPopupSize(dimension);
        }
    }

    protected Dimension getSizeFromPoint(Point point, boolean bl) {
        Dimension dimension = new Dimension();
        if (point.x > 2) {
            dimension.width = (point.x + MJDimensionPicker.CELL_SIZE.width - 3) / MJDimensionPicker.CELL_SIZE.width;
            if (dimension.width > this.fGridSize.width) {
                int n = dimension.width = bl ? dimension.width : this.fGridSize.width;
            }
        }
        if (point.y > 2) {
            dimension.height = (point.y + MJDimensionPicker.CELL_SIZE.height - 3) / MJDimensionPicker.CELL_SIZE.height;
            if (dimension.height > this.fGridSize.height) {
                dimension.height = bl ? dimension.height : this.fGridSize.height;
            }
        }
        return dimension;
    }

    private void reportResult() {
        boolean bl;
        boolean bl2 = bl = this.fSelectedSize.width > 0 && this.fSelectedSize.height > 0;
        if (bl && this.fActionListener != null) {
            this.fActionListener.actionPerformed(new ActionEvent(this, 0, "dimension"));
        }
        this.close(!bl);
    }

    class Closer
    extends WindowAdapter
    implements AWTEventListener {
        Closer() {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            if (!MJDimensionPicker.this.fMouseIsOver) {
                MJDimensionPicker.this.close(true);
            }
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            Component component;
            if (aWTEvent.getID() == 501 && (component = (mouseEvent = (MouseEvent)aWTEvent).getComponent()) != MJDimensionPicker.this && !SwingUtilities.isDescendingFrom(component, MJDimensionPicker.this)) {
                mouseEvent.consume();
                MJDimensionPicker.this.close(true);
            }
        }
    }

    class EventForwarder
    implements AWTEventListener {
        EventForwarder() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (!MJDimensionPicker.this.isShowing()) {
                return;
            }
            switch (aWTEvent.getID()) {
                case 401: {
                    MJDimensionPicker.this.fKeyHandler.keyPressed((KeyEvent)aWTEvent);
                    break;
                }
                case 400: {
                    MJDimensionPicker.this.fKeyHandler.keyTyped((KeyEvent)aWTEvent);
                    break;
                }
                case 402: {
                    MJDimensionPicker.this.fKeyHandler.keyReleased((KeyEvent)aWTEvent);
                    break;
                }
                case 501: {
                    if (aWTEvent.getSource() != MJDimensionPicker.this.fGridPanel) break;
                    MJDimensionPicker.this.fMouseHandler.mousePressed((MouseEvent)aWTEvent);
                    ((MouseEvent)aWTEvent).consume();
                    break;
                }
                case 502: {
                    MJDimensionPicker.this.fMouseHandler.mouseReleased((MouseEvent)aWTEvent);
                    if (!this.isPartOfMenuTree((Component)aWTEvent.getSource())) break;
                    ((MouseEvent)aWTEvent).consume();
                    break;
                }
                case 503: {
                    if (!this.isPartOfMenuTree((Component)aWTEvent.getSource())) break;
                    MJDimensionPicker.this.fMouseHandler.mouseMoved((MouseEvent)aWTEvent);
                    break;
                }
                case 506: {
                    MJDimensionPicker.this.fMouseHandler.mouseDragged((MouseEvent)aWTEvent);
                }
            }
        }

        boolean isPartOfMenuTree(Component component) {
            return component == MJDimensionPicker.this.fGridPanel || component instanceof JMenuBar || component instanceof JMenu;
        }
    }

    class KeyHandler
    extends KeyAdapter
    implements MenuKeyListener {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl = false;
            boolean bl2 = false;
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    MJDimensionPicker.this.close(true);
                    break;
                }
                case 10: {
                    MJDimensionPicker.this.reportResult();
                    break;
                }
                case 37: {
                    if (MJDimensionPicker.this.fSelectedSize.width <= 1) break;
                    --MJDimensionPicker.this.fSelectedSize.width;
                    bl = true;
                    break;
                }
                case 39: {
                    if (MJDimensionPicker.this.fSelectedSize.width < MJDimensionPicker.this.fGridSize.width) {
                        ++MJDimensionPicker.this.fSelectedSize.width;
                        if (MJDimensionPicker.this.fSelectedSize.height == 0) {
                            MJDimensionPicker.this.fSelectedSize.height = 1;
                        }
                        bl = true;
                        break;
                    }
                    if (!MJDimensionPicker.this.fAutoGrow || MJDimensionPicker.this.fSelectedSize.width >= MJDimensionPicker.this.fLimitSize.width) break;
                    ++MJDimensionPicker.this.fSelectedSize.width;
                    MJDimensionPicker.this.fGridSize.width = MJDimensionPicker.this.fSelectedSize.width;
                    bl2 = true;
                    bl = true;
                    break;
                }
                case 38: {
                    if (MJDimensionPicker.this.fSelectedSize.height <= 1) break;
                    --MJDimensionPicker.this.fSelectedSize.height;
                    bl = true;
                    break;
                }
                case 40: {
                    if (MJDimensionPicker.this.fSelectedSize.height < MJDimensionPicker.this.fGridSize.height) {
                        ++MJDimensionPicker.this.fSelectedSize.height;
                        if (MJDimensionPicker.this.fSelectedSize.width == 0) {
                            MJDimensionPicker.this.fSelectedSize.width = 1;
                        }
                        bl = true;
                        break;
                    }
                    if (!MJDimensionPicker.this.fAutoGrow || MJDimensionPicker.this.fSelectedSize.height >= MJDimensionPicker.this.fLimitSize.height) break;
                    ++MJDimensionPicker.this.fSelectedSize.height;
                    MJDimensionPicker.this.fGridSize.height = MJDimensionPicker.this.fSelectedSize.height;
                    bl2 = true;
                    bl = true;
                }
            }
            if (bl2) {
                MJDimensionPicker.this.grow();
            }
            if (bl) {
                MJDimensionPicker.this.repaint();
            }
            if (MJDimensionPicker.this.isShowing()) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            if (MJDimensionPicker.this.isShowing()) {
                this.keyPressed(menuKeyEvent);
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
            if (MJDimensionPicker.this.isShowing()) {
                this.keyReleased(menuKeyEvent);
            }
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MJDimensionPicker.this.fMouseHasEntered = true;
            MJDimensionPicker.this.fMouseIsOver = true;
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MJDimensionPicker.this.fMouseIsOver = false;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!MJDimensionPicker.this.isShowing()) {
                return;
            }
            Point point = this.getPointFromEvent(mouseEvent);
            Dimension dimension = MJDimensionPicker.this.getSizeFromPoint(point, false);
            if (!dimension.equals(MJDimensionPicker.this.fSelectedSize)) {
                MJDimensionPicker.this.fSelectedSize.setSize(dimension);
                MJDimensionPicker.this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!MJDimensionPicker.this.isShowing()) {
                return;
            }
            Point point = this.getPointFromEvent(mouseEvent);
            if (!MJDimensionPicker.this.fMouseHasEntered) {
                if (MJDimensionPicker.this.fGridPanel.contains(point)) {
                    MJDimensionPicker.this.fMouseHasEntered = true;
                } else {
                    return;
                }
            }
            Dimension dimension = MJDimensionPicker.this.getSizeFromPoint(point, MJDimensionPicker.this.fAutoGrow);
            if (dimension.width > MJDimensionPicker.this.fLimitSize.width) {
                dimension.width = MJDimensionPicker.this.fLimitSize.width;
            }
            if (dimension.height > MJDimensionPicker.this.fLimitSize.height) {
                dimension.height = MJDimensionPicker.this.fLimitSize.height;
            }
            if (!dimension.equals(MJDimensionPicker.this.fSelectedSize)) {
                MJDimensionPicker.this.fSelectedSize.setSize(dimension);
                boolean bl = false;
                if (dimension.width > MJDimensionPicker.this.fGridSize.width) {
                    MJDimensionPicker.this.fGridSize.width = dimension.width;
                    bl = true;
                }
                if (dimension.height > MJDimensionPicker.this.fGridSize.height) {
                    MJDimensionPicker.this.fGridSize.height = dimension.height;
                    bl = true;
                }
                if (bl) {
                    MJDimensionPicker.this.grow();
                }
                MJDimensionPicker.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (PlatformInfo.isSolaris() && MJDimensionPicker.this.fWindow != null) {
                MJDimensionPicker.this.fWindow.toFront();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!MJDimensionPicker.this.isShowing()) {
                return;
            }
            if (mouseEvent.getSource() == MJDimensionPicker.this.fInvoker && MJDimensionPicker.this.fInvoker.contains(mouseEvent.getX(), mouseEvent.getY())) {
                return;
            }
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), MJDimensionPicker.this.fGridPanel);
            if (MJDimensionPicker.this.fGridPanel.contains(point)) {
                Point point2 = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), MJDimensionPicker.this.fDimensionLabel);
                if (MJDimensionPicker.this.fDimensionLabel.contains(point2)) {
                    MJDimensionPicker.this.close(true);
                } else {
                    MJDimensionPicker.this.reportResult();
                }
            }
        }

        Point getPointFromEvent(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Component component = (Component)mouseEvent.getSource();
            if (component != MJDimensionPicker.this.fGridPanel) {
                point = SwingUtilities.convertPoint(component, point, MJDimensionPicker.this.fGridPanel);
            }
            return point;
        }
    }

    protected class GridPanel
    extends JPanel {
        protected GridPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(MJDimensionPicker.CELL_SIZE.width * MJDimensionPicker.this.fGridSize.width + 2, MJDimensionPicker.CELL_SIZE.height * MJDimensionPicker.this.fGridSize.height + 2);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = 0;
            if (MJDimensionPicker.this.fColumnMajorOccupancy) {
                int n2 = 2;
                int n3 = 0;
                while (n3 < MJDimensionPicker.this.fGridSize.width) {
                    int n4 = 2;
                    int n5 = 0;
                    while (n5 < MJDimensionPicker.this.fGridSize.height) {
                        this.outlineTile(graphics, n2, n4);
                        n = this.fillTile(graphics, n5, n3, n2, n4, n);
                        ++n5;
                        n4 += MJDimensionPicker.CELL_SIZE.width;
                    }
                    ++n3;
                    n2 += MJDimensionPicker.CELL_SIZE.height;
                }
            } else {
                int n6 = 2;
                int n7 = 0;
                while (n7 < MJDimensionPicker.this.fGridSize.height) {
                    int n8 = 2;
                    int n9 = 0;
                    while (n9 < MJDimensionPicker.this.fGridSize.width) {
                        this.outlineTile(graphics, n8, n6);
                        n = this.fillTile(graphics, n7, n9, n8, n6, n);
                        ++n9;
                        n8 += MJDimensionPicker.CELL_SIZE.height;
                    }
                    ++n7;
                    n6 += MJDimensionPicker.CELL_SIZE.width;
                }
            }
        }

        private void outlineTile(Graphics graphics, int n, int n2) {
            graphics.setColor(Color.gray);
            graphics.drawRect(n, n2, MJDimensionPicker.CELL_SIZE.width - 3, MJDimensionPicker.CELL_SIZE.height - 3);
        }

        private int fillTile(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
            boolean bl;
            Color color = Color.white;
            boolean bl2 = bl = n < MJDimensionPicker.this.fSelectedSize.height && n2 < MJDimensionPicker.this.fSelectedSize.width;
            if (bl) {
                color = ++n5 <= MJDimensionPicker.this.fOccupancy ? MJDimensionPicker.this.getOccupiedColor() : MJDimensionPicker.this.getSelectedColor();
            }
            graphics.setColor(color);
            graphics.fillRect(n3 + 1, n4 + 1, MJDimensionPicker.CELL_SIZE.width - 4, MJDimensionPicker.CELL_SIZE.height - 4);
            return n5;
        }
    }
}

