/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.ChangeSafetyListener;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;

public class MJScrollPane
extends JScrollPane {
    private ChangeListener fViewportSafetyListener;
    private boolean fAnchorToBottom;

    public MJScrollPane() {
        this.addSafetyListeners();
        MJScrollPane.fixMacListenerBug();
    }

    private static void fixMacListenerBug() {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = Toolkit.getDefaultToolkit().getPropertyChangeListeners("apple.awt.contentScaleFactor")) {
            if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
                if (((PropertyChangeListenerProxy)propertyChangeListener).isValid()) continue;
                Toolkit.getDefaultToolkit().removePropertyChangeListener("apple.awt.contentScaleFactor", propertyChangeListener);
                continue;
            }
            PropertyChangeListenerProxy propertyChangeListenerProxy = new PropertyChangeListenerProxy(propertyChangeListener);
            Toolkit.getDefaultToolkit().removePropertyChangeListener("apple.awt.contentScaleFactor", propertyChangeListener);
            Toolkit.getDefaultToolkit().addPropertyChangeListener("apple.awt.contentScaleFactor", propertyChangeListenerProxy);
        }
    }

    public MJScrollPane(Component component) {
        super(component);
        this.addSafetyListeners();
        MJScrollPane.fixMacListenerBug();
    }

    public MJScrollPane(int n, int n2) {
        super(n, n2);
        this.addSafetyListeners();
        MJScrollPane.fixMacListenerBug();
    }

    public MJScrollPane(Component component, int n, int n2) {
        super(component, n, n2);
        this.addSafetyListeners();
        MJScrollPane.fixMacListenerBug();
    }

    public void anchorToBottom() {
        this.fAnchorToBottom = true;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (this.fAnchorToBottom) {
            bl = this.isAtBottom();
        }
        super.setBounds(n, n2, n3, n4);
        if (this.fAnchorToBottom && bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MJScrollPane.this.getVerticalScrollBar() != null) {
                        int n = MJScrollPane.this.getVerticalScrollBar().getMaximum() - MJScrollPane.this.getVerticalScrollBar().getModel().getExtent();
                        MJScrollPane.this.getVerticalScrollBar().setValue(n);
                    }
                }
            });
        }
    }

    public boolean isAtBottom() {
        boolean bl = false;
        if (this.getVerticalScrollBar() != null) {
            int n;
            int n2 = this.getVerticalScrollBar().getValue();
            bl = n2 == (n = this.getVerticalScrollBar().getMaximum() - this.getVerticalScrollBar().getModel().getExtent());
        }
        return bl;
    }

    private void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.fViewportSafetyListener = new ChangeSafetyListener(this);
            this.getViewport().addChangeListener(this.fViewportSafetyListener);
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    @Override
    public void setViewport(JViewport jViewport) {
        if (this.fViewportSafetyListener != null) {
            JViewport jViewport2 = this.getViewport();
            jViewport2.removeChangeListener(this.fViewportSafetyListener);
            jViewport.addChangeListener(this.fViewportSafetyListener);
        }
        super.setViewport(jViewport);
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        BareSwingDetector.exempt();
        JScrollBar jScrollBar = super.createHorizontalScrollBar();
        BareSwingDetector.reinstate();
        return jScrollBar;
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        BareSwingDetector.exempt();
        JScrollBar jScrollBar = super.createVerticalScrollBar();
        BareSwingDetector.reinstate();
        return jScrollBar;
    }

    private static class PropertyChangeListenerProxy
    implements PropertyChangeListener {
        private WeakReference<PropertyChangeListener> fTarget;

        PropertyChangeListenerProxy(PropertyChangeListener propertyChangeListener) {
            this.fTarget = new WeakReference<PropertyChangeListener>(propertyChangeListener);
        }

        public boolean isValid() {
            return this.fTarget.get() != null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.fTarget.get();
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }
}

