/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.ChangeSafetyListener;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.util.PlatformInfo;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.text.JTextComponent;

public class MJSpinner
extends JSpinner {
    public MJSpinner() {
        this.initialize();
    }

    public MJSpinner(SpinnerModel spinnerModel) {
        super(spinnerModel);
        this.initialize();
    }

    private void initialize() {
        this.addSafetyListeners();
        if (!PlatformInfo.isMacintosh()) {
            this.addAppearanceFocusListener();
        }
    }

    @Override
    public void updateUI() {
        BareSwingDetector.exempt();
        super.updateUI();
        BareSwingDetector.reinstate();
    }

    private void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.addChangeListener(new ChangeSafetyListener(this));
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    protected void addAppearanceFocusListener() {
        JTextComponent jTextComponent = this.getTextComponent();
        if (jTextComponent != null) {
            jTextComponent.addFocusListener(MJTextField.APPEARANCE_FOCUS_DISPATCHER);
        }
    }

    protected void removeAppearanceFocusListener() {
        JTextComponent jTextComponent = this.getTextComponent();
        if (jTextComponent != null) {
            jTextComponent.removeFocusListener(MJTextField.APPEARANCE_FOCUS_DISPATCHER);
        }
    }

    private JTextComponent getTextComponent() {
        JTextComponent jTextComponent = null;
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            jTextComponent = ((JSpinner.DefaultEditor)jComponent).getTextField();
        } else if (jComponent instanceof JTextComponent) {
            jTextComponent = (JTextComponent)jComponent;
        }
        return jTextComponent;
    }

    @Override
    public void setEditor(JComponent jComponent) {
        if (!PlatformInfo.isMacintosh()) {
            this.removeAppearanceFocusListener();
        }
        super.setEditor(jComponent);
        if (!PlatformInfo.isMacintosh()) {
            this.addAppearanceFocusListener();
        }
    }

    public void setDefaultEditorAccessibleName(String string) {
        if (!(this.getEditor() instanceof JSpinner.DefaultEditor)) {
            throw new IllegalStateException("Editor must be a DefaultEditor");
        }
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().getAccessibleContext().setAccessibleName(string);
        this.getAccessibleContext().setAccessibleName(string);
    }
}

