/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.ChangeSafetyListener;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.util.Assert;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class MJTabbedPane
extends JTabbedPane {
    private final Hashtable<MouseListener, TabMouseListener> fTabListenerTable = new Hashtable();

    public MJTabbedPane() {
        this.addSafetyListeners();
    }

    public MJTabbedPane(int n) {
        super(n);
        this.addSafetyListeners();
    }

    private void addSafetyListeners() {
        if (MJUtilities.threadingChecksEnabled()) {
            this.addChangeListener(new ChangeSafetyListener(this));
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    public void addTabListener(MouseListener mouseListener) {
        Assert._assert((boolean)(mouseListener instanceof MouseMotionListener));
        TabMouseListener tabMouseListener = new TabMouseListener(mouseListener);
        this.fTabListenerTable.put(mouseListener, tabMouseListener);
        this.attachTabListener(tabMouseListener);
    }

    private void attachTabListener(TabMouseListener tabMouseListener) {
        if (this.getTabLayoutPolicy() == 0 || PlatformInfo.isMacintosh() || PlatformInfo.getVersion() != 5) {
            MJUtilities.addFirstMouseListener(this, tabMouseListener);
            this.addMouseMotionListener(tabMouseListener);
        } else {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JViewport) || this.indexOfComponent(component) != -1) continue;
                Component component2 = ((JViewport)component).getView();
                MJUtilities.addFirstMouseListener(component2, tabMouseListener);
                component2.addMouseMotionListener(tabMouseListener);
            }
        }
    }

    public void removeTabListener(MouseListener mouseListener) {
        TabMouseListener tabMouseListener = this.fTabListenerTable.remove(mouseListener);
        if (tabMouseListener != null) {
            this.detachTabListener(tabMouseListener);
        }
    }

    private void detachTabListener(TabMouseListener tabMouseListener) {
        if (this.getTabLayoutPolicy() == 0 || PlatformInfo.isMacintosh() || PlatformInfo.getVersion() != 5) {
            this.removeMouseListener(tabMouseListener);
            this.removeMouseMotionListener(tabMouseListener);
        } else {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JViewport) || this.indexOfComponent(component) != -1) continue;
                Component component2 = ((JViewport)component).getView();
                component2.removeMouseListener(tabMouseListener);
                component2.removeMouseMotionListener(tabMouseListener);
            }
        }
    }

    @Override
    public void setTabLayoutPolicy(int n) {
        if (n != this.getTabLayoutPolicy()) {
            Collection<TabMouseListener> collection = this.fTabListenerTable.values();
            if (collection.size() > 0 && !PlatformInfo.isMacintosh()) {
                for (TabMouseListener tabMouseListener : collection) {
                    this.detachTabListener(tabMouseListener);
                }
            }
            super.setTabLayoutPolicy(n);
            if (collection.size() > 0 && !PlatformInfo.isMacintosh()) {
                for (TabMouseListener tabMouseListener : collection) {
                    this.attachTabListener(tabMouseListener);
                }
            }
        }
    }

    public int indexAtLocation(Point point) {
        return this.indexAtLocation(point.x, point.y);
    }

    public int indexFromMouse(MouseEvent mouseEvent) {
        if (this.getTabLayoutPolicy() == 0 || mouseEvent.getComponent() instanceof JTabbedPane) {
            return this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
        }
        Component component = mouseEvent.getComponent();
        Container container = component.getParent();
        return this.indexAtLocation(mouseEvent.getX() - container.getX(), mouseEvent.getY() - container.getY());
    }

    class TabMouseListener
    implements MouseListener,
    MouseMotionListener {
        MouseListener fListener;
        MouseMotionListener fMotionListener;
        boolean fDragStartedOnTab;
        int fOverTab;

        public TabMouseListener(MouseListener mouseListener) {
            this.fListener = mouseListener;
            this.fMotionListener = (MouseMotionListener)((Object)mouseListener);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (MJTabbedPane.this.indexFromMouse(mouseEvent) != -1) {
                this.fListener.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (MJTabbedPane.this.indexFromMouse(mouseEvent) == -1) {
                this.fDragStartedOnTab = false;
            } else {
                this.fDragStartedOnTab = true;
                this.fListener.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.fDragStartedOnTab) {
                this.fListener.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.fOverTab = MJTabbedPane.this.indexFromMouse(mouseEvent);
            if (this.fOverTab != -1) {
                this.fListener.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.fOverTab != -1) {
                this.fOverTab = -1;
                this.fListener.mouseExited(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = MJTabbedPane.this.indexFromMouse(mouseEvent);
            if (n != this.fOverTab) {
                if (this.fOverTab != -1) {
                    this.fListener.mouseExited(new MouseEvent(mouseEvent.getComponent(), 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
                if (n != -1) {
                    this.fListener.mouseEntered(new MouseEvent(mouseEvent.getComponent(), 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
                this.fOverTab = n;
            } else if (this.fOverTab != -1) {
                this.fMotionListener.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.fDragStartedOnTab) {
                this.fMotionListener.mouseDragged(mouseEvent);
            }
        }
    }
}

