/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.DefaultKeyBindings;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.mwswing.text.TextContextMenu;
import com.mathworks.mwswing.text.TextDragRecognizer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class MJTextArea
extends JTextArea
implements KeyBindingManagerRegistrant {
    protected ContextMenuListener fContextListener;
    protected TextDragRecognizer fDragRecognizer;

    public MJTextArea() {
        this.initialize();
    }

    public MJTextArea(Document document) {
        super(document);
        this.initialize();
    }

    public MJTextArea(Document document, String string, int n, int n2) {
        super(document, string, n, n2);
        this.initialize();
    }

    public MJTextArea(int n, int n2) {
        super(n, n2);
        this.initialize();
    }

    public MJTextArea(String string) {
        super(string);
        this.initialize();
    }

    public MJTextArea(String string, int n, int n2) {
        super(string, n, n2);
        this.initialize();
    }

    private void initialize() {
        this.registerWithKeyBindingManager(DefaultKeyBindings.getManager(), "DefaultContext");
    }

    @Override
    public void registerWithKeyBindingManager(KeyBindingManager keyBindingManager, String string) {
        MJUtilities.updateInputMap(this, keyBindingManager, string);
        this.addContextMenu(new TextContextMenu(keyBindingManager, string));
    }

    public void addContextMenu(JPopupMenu jPopupMenu) {
        if (this.fContextListener != null) {
            if (jPopupMenu == null) {
                this.removeContextMenu();
            } else {
                this.fContextListener.setMenu(jPopupMenu);
            }
        } else if (jPopupMenu != null) {
            this.fContextListener = new ContextMenuListener(jPopupMenu);
            this.addMouseListener(this.fContextListener);
        }
    }

    public void removeContextMenu() {
        if (this.fContextListener != null) {
            this.removeMouseListener(this.fContextListener);
            this.fContextListener = null;
        }
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener instanceof TextDragRecognizer) {
            this.fDragRecognizer = (TextDragRecognizer)mouseListener;
        } else {
            super.addMouseListener(mouseListener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == this.fDragRecognizer) {
            this.fDragRecognizer = null;
        } else {
            super.removeMouseListener(mouseListener);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null) {
            int n = mouseEvent.getID();
            if (n == 501) {
                this.fDragRecognizer.mousePressed(mouseEvent);
            } else if (n == 502) {
                this.fDragRecognizer.mouseReleased(mouseEvent);
            }
            if (mouseEvent.isConsumed()) {
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null && mouseEvent.getID() == 506) {
            this.fDragRecognizer.mouseDragged(mouseEvent);
            if (mouseEvent.isConsumed()) {
                return;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    protected class ContextMenuListener
    extends MouseAdapter {
        JPopupMenu fMenu;

        public ContextMenuListener(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        public void setMenu(JPopupMenu jPopupMenu) {
            this.fMenu = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MJTextArea.this.requestFocus();
                this.fMenu.show(MJTextArea.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

