/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.CellViewerCustomizer;
import com.mathworks.mwswing.CellViewerUtils;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.DefaultTreeCellViewerCustomizer;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MultiSelectionEventType;
import com.mathworks.mwswing.PropertySafetyListener;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class MJTree
extends JTree
implements CellViewerCustomizer<Integer> {
    private boolean fRightSelectionEnabled;
    private boolean fLooseSelectionEnabled = true;
    private boolean fFirstCharacterNavigationEnabled = true;
    private boolean fIsProcessingKeyEvent;
    private boolean fIsSelectionLocked;
    private boolean fSelectionAppearanceReflectsFocus = true;
    protected MouseDragGestureRecognizer fDragRecognizer;
    protected int fSuppressedIndex = -1;
    private CellViewerUtils.Context fCellViewerContext;
    private CellViewerCustomizer<Integer> fDefaultCellViewerCustomizer;
    private KeyListener fKeyListener;
    private TreeModelListener fModelSafetyListener;
    private TreeSelectionListener fSelectionSafetyListener;
    private Color fSaveSelectionBackground;
    private Color fSaveSelectionForeground;
    private int fMinimumRowHeight = 16;
    private static AppearanceFocusDispatcher sAppearanceFocusDispatcher = new AppearanceFocusDispatcher();

    public MJTree() {
        this.initialize();
    }

    public MJTree(Hashtable<?, ?> hashtable) {
        super(hashtable);
        this.initialize();
    }

    public MJTree(Object[] objectArray) {
        super(objectArray);
        this.initialize();
    }

    public MJTree(TreeModel treeModel) {
        super(treeModel);
        this.initialize();
    }

    public MJTree(TreeNode treeNode) {
        super(treeNode);
        this.initialize();
    }

    public MJTree(TreeNode treeNode, boolean bl) {
        super(treeNode, bl);
        this.initialize();
    }

    public MJTree(Vector<?> vector) {
        super(vector);
        this.initialize();
    }

    private void initialize() {
        this.addSelfListeners();
        this.updateRowHeight();
    }

    private void addSelfListeners() {
        this.fDefaultCellViewerCustomizer = new DefaultTreeCellViewerCustomizer(this);
        LocalMouseListener localMouseListener = new LocalMouseListener();
        this.addMouseListener(localMouseListener);
        this.addMouseMotionListener(localMouseListener);
        this.fKeyListener = new LocalKeyListener();
        if (this.fSelectionAppearanceReflectsFocus) {
            this.addFocusListener(sAppearanceFocusDispatcher);
        }
        if (MJUtilities.threadingChecksEnabled()) {
            this.fModelSafetyListener = new ModelSafetyListener();
            this.fSelectionSafetyListener = new SelectionSafetyListener();
            this.getModel().addTreeModelListener(this.fModelSafetyListener);
            this.getSelectionModel().addTreeSelectionListener(this.fSelectionSafetyListener);
            this.addPropertyChangeListener(new PropertySafetyListener(this));
        }
    }

    public void setRightSelectionEnabled(boolean bl) {
        this.fRightSelectionEnabled = bl;
    }

    public boolean isRightSelectionEnabled() {
        return this.fRightSelectionEnabled;
    }

    public void setLooseSelectionEnabled(boolean bl) {
        this.fLooseSelectionEnabled = bl;
    }

    public boolean isLooseSelectionEnabled() {
        return this.fLooseSelectionEnabled;
    }

    public void setFirstCharacterNavigationEnabled(boolean bl) {
        this.fFirstCharacterNavigationEnabled = bl;
    }

    public boolean isFirstCharacterNavigationEnabled() {
        return this.fFirstCharacterNavigationEnabled;
    }

    public void setMinimumRowHeight(int n) {
        this.fMinimumRowHeight = n;
        this.updateRowHeight();
    }

    private void updateRowHeight() {
        FontMetrics fontMetrics;
        Font font = this.getFont();
        if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
            this.setRowHeight(Math.max(this.fMinimumRowHeight, fontMetrics.getHeight() + 2));
            return;
        }
        this.setRowHeight(this.fMinimumRowHeight);
    }

    public void setCellViewerEnabled(boolean bl) {
        if (bl && this.fCellViewerContext == null) {
            this.fCellViewerContext = CellViewerUtils.installCellViewer(this);
        }
        if (!bl && this.fCellViewerContext != null) {
            this.fCellViewerContext.uninstall();
            this.fCellViewerContext = null;
        }
    }

    public boolean isCellViewerEnabled() {
        return this.fCellViewerContext != null;
    }

    public void setSelectionAppearanceReflectsFocus(boolean bl) {
        if (bl && !this.fSelectionAppearanceReflectsFocus) {
            this.addFocusListener(sAppearanceFocusDispatcher);
        } else if (!bl && this.fSelectionAppearanceReflectsFocus) {
            this.removeFocusListener(sAppearanceFocusDispatcher);
        }
        this.fSelectionAppearanceReflectsFocus = bl;
    }

    public boolean selectionAppearanceReflectsFocus() {
        return this.fSelectionAppearanceReflectsFocus;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            this.updateRowHeight();
        }
    }

    @Override
    public void setModel(TreeModel treeModel) {
        if (this.fModelSafetyListener != null) {
            TreeModel treeModel2 = this.getModel();
            treeModel2.removeTreeModelListener(this.fModelSafetyListener);
            if (treeModel != null) {
                treeModel.addTreeModelListener(this.fModelSafetyListener);
            }
        }
        super.setModel(treeModel);
    }

    @Override
    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (this.fSelectionSafetyListener != null) {
            TreeSelectionModel treeSelectionModel2 = this.getSelectionModel();
            treeSelectionModel2.removeTreeSelectionListener(this.fSelectionSafetyListener);
            treeSelectionModel.addTreeSelectionListener(this.fSelectionSafetyListener);
        }
        super.setSelectionModel(treeSelectionModel);
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                this.fKeyListener.keyPressed(keyEvent);
                break;
            }
            case 400: {
                this.fKeyListener.keyTyped(keyEvent);
                break;
            }
            case 402: {
                this.fKeyListener.keyReleased(keyEvent);
            }
        }
        if (!keyEvent.isConsumed()) {
            this.fIsProcessingKeyEvent = true;
            super.processKeyEvent(keyEvent);
            this.fIsProcessingKeyEvent = false;
        }
    }

    @Override
    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        if (this.fFirstCharacterNavigationEnabled || !this.fIsProcessingKeyEvent) {
            return super.getNextMatch(string, n, bias);
        }
        return null;
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (mouseListener instanceof MouseDragGestureRecognizer) {
            this.fDragRecognizer = (MouseDragGestureRecognizer)mouseListener;
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        if (mouseListener == this.fDragRecognizer) {
            this.fDragRecognizer = null;
            this.fSuppressedIndex = -1;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.processMouseEventImpl(mouseEvent);
    }

    public final void processMouseEventImpl(MouseEvent mouseEvent) {
        int n;
        if (this.fCellViewerContext != null) {
            mouseEvent = this.fCellViewerContext.adjustMouseEvent(mouseEvent);
        }
        if (this.fDragRecognizer != null) {
            n = mouseEvent.getID();
            int n2 = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == 501) {
                int n3 = mouseEvent.getModifiers();
                if ((n3 & 0x10) != 0 && this.getSelectionModel().getSelectionMode() != 1 && !this.isSelectionEmpty() && this.getSelectionRows().length > 1 && this.isRowSelected(n2)) {
                    this.fIsSelectionLocked = true;
                    this.fSuppressedIndex = n2;
                } else {
                    this.fSuppressedIndex = -1;
                }
            } else if (n == 502 && this.fSuppressedIndex != -1) {
                MultiSelectionEventType.getMouseReleasedSelectionType(mouseEvent, this.isRowSelected(n2)).performOnTree(this, this.fSuppressedIndex);
                this.fSuppressedIndex = -1;
            }
        }
        if (PlatformInfo.isMacintosh() && mouseEvent.isPopupTrigger() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isShiftDown() && this.getSelectionModel().getSelectionMode() != 1) {
            n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            this.fIsSelectionLocked = n != -1 && this.isRowSelected(n);
        }
        super.processMouseEvent(mouseEvent);
        this.fIsSelectionLocked = false;
    }

    void extendSelection(TreePath treePath) {
        TreePath treePath2 = this.getAnchorSelectionPath();
        int n = treePath2 == null ? -1 : this.getRowForPath(treePath2);
        int n2 = this.getRowForPath(treePath);
        if (n == -1) {
            this.setSelectionRow(n2);
        } else {
            if (n < n2) {
                this.setSelectionInterval(n, n2);
            } else {
                this.setSelectionInterval(n2, n);
            }
            this.setAnchorSelectionPath(treePath2);
            this.setLeadSelectionPath(treePath);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fDragRecognizer != null && mouseEvent.getID() == 506 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.fDragRecognizer.mouseDragged(mouseEvent);
        } else {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    @Override
    public Component getCellPainter(Integer n) {
        return this.fDefaultCellViewerCustomizer.getCellPainter(n);
    }

    @Override
    public Dimension getCellViewerOffset(Integer n) {
        return this.fDefaultCellViewerCustomizer.getCellViewerOffset(n);
    }

    @Override
    public boolean shouldShowCellViewer(Integer n) {
        return this.fDefaultCellViewerCustomizer.shouldShowCellViewer(n);
    }

    @Override
    public boolean constrainViewerToCellHeight() {
        return true;
    }

    protected void expandRecursively(TreePath treePath) {
        Object object;
        TreeModel treeModel = this.getModel();
        int n = treeModel.getChildCount(object = treePath.getLastPathComponent());
        if (n == 0) {
            return;
        }
        this.expandPath(treePath);
        for (int i = 0; i < n; ++i) {
            this.expandRecursively(treePath.pathByAddingChild(treeModel.getChild(object, i)));
        }
    }

    private void ensureRowsAreVisible(int n, int n2) {
        if (n >= 0 && n2 < this.getRowCount()) {
            if (n == n2) {
                Rectangle rectangle = this.getPathBounds(this.getPathForRow(n));
                if (rectangle != null) {
                    this.scrollRectToVisible(rectangle);
                }
            } else {
                Rectangle rectangle = this.getPathBounds(this.getPathForRow(n));
                Rectangle rectangle2 = this.getVisibleRect();
                Rectangle rectangle3 = rectangle;
                int n3 = rectangle.y;
                int n4 = n3 + rectangle2.height;
                for (int i = n + 1; i <= n2; ++i) {
                    rectangle3 = this.getPathBounds(this.getPathForRow(i));
                    if (rectangle3.y + rectangle3.height <= n4) continue;
                    i = n2;
                }
                this.scrollRectToVisible(new Rectangle(rectangle2.x, n3, 1, rectangle3.y + rectangle3.height - n3));
            }
        }
    }

    private int getVisibleNodeCount(TreeNode treeNode, TreePath treePath) {
        if (!this.isExpanded(treePath)) {
            return 1;
        }
        int n = treeNode.getChildCount();
        int n2 = 1;
        for (int i = 0; i != n; ++i) {
            n2 += this.getVisibleNodeCount(treeNode.getChildAt(i), treePath.pathByAddingChild(treeNode.getChildAt(i)));
        }
        return n2;
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (!this.fIsSelectionLocked) {
            super.addSelectionInterval(n, n2);
        }
    }

    @Override
    public void addSelectionPath(TreePath treePath) {
        if (!this.fIsSelectionLocked) {
            super.addSelectionPath(treePath);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] treePathArray) {
        if (!this.fIsSelectionLocked) {
            super.addSelectionPaths(treePathArray);
        }
    }

    @Override
    public void addSelectionRow(int n) {
        if (!this.fIsSelectionLocked) {
            super.addSelectionRow(n);
        }
    }

    @Override
    public void addSelectionRows(int[] nArray) {
        if (!this.fIsSelectionLocked) {
            super.addSelectionRows(nArray);
        }
    }

    @Override
    public void clearSelection() {
        if (!this.fIsSelectionLocked) {
            super.clearSelection();
        }
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (!this.fIsSelectionLocked) {
            super.removeSelectionInterval(n, n2);
        }
    }

    @Override
    public void removeSelectionPath(TreePath treePath) {
        if (!this.fIsSelectionLocked) {
            super.removeSelectionPath(treePath);
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (!this.fIsSelectionLocked) {
            super.removeSelectionPaths(treePathArray);
        }
    }

    @Override
    public void removeSelectionRow(int n) {
        if (!this.fIsSelectionLocked) {
            super.removeSelectionRow(n);
        }
    }

    @Override
    public void removeSelectionRows(int[] nArray) {
        if (!this.fIsSelectionLocked) {
            super.removeSelectionRows(nArray);
        }
    }

    @Override
    public void setAnchorSelectionPath(TreePath treePath) {
        if (!this.fIsSelectionLocked) {
            super.setAnchorSelectionPath(treePath);
        }
    }

    @Override
    public void setLeadSelectionPath(TreePath treePath) {
        if (!this.fIsSelectionLocked) {
            super.setLeadSelectionPath(treePath);
        }
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (!this.fIsSelectionLocked) {
            super.setSelectionInterval(n, n2);
        }
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        if (!this.fIsSelectionLocked) {
            super.setSelectionPath(treePath);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] treePathArray) {
        if (!this.fIsSelectionLocked) {
            super.setSelectionPaths(treePathArray);
        }
    }

    @Override
    public void setSelectionRow(int n) {
        if (!this.fIsSelectionLocked) {
            super.setSelectionRow(n);
        }
    }

    @Override
    public void setSelectionRows(int[] nArray) {
        if (!this.fIsSelectionLocked) {
            super.setSelectionRows(nArray);
        }
    }

    static {
        sAppearanceFocusDispatcher.addAppearanceFocusListener(new TreeAppearanceFocusListener());
    }

    static class TreeAppearanceFocusListener
    implements AppearanceFocusListener {
        TreeAppearanceFocusListener() {
        }

        @Override
        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof MJTree) {
                MJTree mJTree = (MJTree)appearanceFocusEvent.getComponent();
                Color color = null;
                Color color2 = null;
                Color color3 = ColorUtils.getUnfocusedSelectionBackgroundColor(mJTree);
                Color color4 = ColorUtils.getUnfocusedSelectionForegroundColor(mJTree);
                if (mJTree.getCellRenderer() instanceof DefaultTreeCellRenderer) {
                    DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)mJTree.getCellRenderer();
                    color = defaultTreeCellRenderer.getBackgroundSelectionColor();
                    color2 = defaultTreeCellRenderer.getTextSelectionColor();
                    defaultTreeCellRenderer.setBackgroundSelectionColor(color3);
                    defaultTreeCellRenderer.setTextSelectionColor(color4);
                    mJTree.repaint();
                }
                mJTree.fSaveSelectionBackground = color;
                mJTree.fSaveSelectionForeground = color2;
            }
        }

        @Override
        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            if (appearanceFocusEvent.getComponent() instanceof MJTree) {
                MJTree mJTree = (MJTree)appearanceFocusEvent.getComponent();
                Color color = mJTree.fSaveSelectionBackground;
                Color color2 = mJTree.fSaveSelectionForeground;
                if (mJTree.getCellRenderer() instanceof DefaultTreeCellRenderer) {
                    DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)mJTree.getCellRenderer();
                    if (color != null) {
                        defaultTreeCellRenderer.setBackgroundSelectionColor(color);
                    }
                    if (color2 != null) {
                        defaultTreeCellRenderer.setTextSelectionColor(color2);
                    }
                    mJTree.repaint();
                }
                mJTree.fSaveSelectionBackground = null;
                mJTree.fSaveSelectionForeground = null;
            }
        }
    }

    private class SelectionSafetyListener
    implements TreeSelectionListener {
        private SelectionSafetyListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (MJTree.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private class ModelSafetyListener
    implements TreeModelListener {
        private ModelSafetyListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (MJTree.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (MJTree.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (MJTree.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (MJTree.this.isShowing()) {
                MJUtilities.assertIsEventThread();
            }
        }
    }

    private class LocalKeyListener
    extends KeyAdapter {
        private boolean fPressConsumed;

        private LocalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Object object;
            TreePath treePath = MJTree.this.getSelectionPath();
            if (treePath == null) {
                return;
            }
            if (keyEvent.getKeyCode() == 107) {
                Object object2 = treePath.getLastPathComponent();
                if (MJTree.this.isCollapsed(treePath) && object2 instanceof TreeNode && !((TreeNode)object2).isLeaf()) {
                    MJTree.this.expandPath(treePath);
                    if (MJTree.this.getScrollsOnExpand()) {
                        int n = MJTree.this.getRowForPath(treePath);
                        MJTree.this.ensureRowsAreVisible(n, n + MJTree.this.getVisibleNodeCount((TreeNode)object2, treePath) - 1);
                    }
                    keyEvent.consume();
                }
            } else if (keyEvent.getKeyCode() == 109 || keyEvent.getKeyChar() == '-' && keyEvent.getKeyLocation() == 4) {
                if (MJTree.this.isExpanded(treePath)) {
                    MJTree.this.collapsePath(treePath);
                    keyEvent.consume();
                }
            } else if ((keyEvent.getKeyCode() == 106 || keyEvent.getKeyChar() == '*' && keyEvent.getKeyLocation() == 4) && (object = treePath.getLastPathComponent()) instanceof TreeNode && !((TreeNode)object).isLeaf()) {
                MJTree.this.expandRecursively(treePath);
                keyEvent.consume();
            }
            this.setPressConsumed(keyEvent.isConsumed());
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.isPressConsumed()) {
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.isPressConsumed()) {
                keyEvent.consume();
            }
        }

        public boolean isPressConsumed() {
            return this.fPressConsumed;
        }

        public void setPressConsumed(boolean bl) {
            this.fPressConsumed = bl;
        }
    }

    private class LocalMouseListener
    extends MouseInputAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Serializable serializable;
            int n;
            if (!MJTree.this.isEnabled()) {
                return;
            }
            boolean bl = MJUtilities.isRightMouseButton(mouseEvent);
            boolean bl2 = SwingUtilities.isMiddleMouseButton(mouseEvent);
            if (!MJTree.this.fRightSelectionEnabled && bl || bl2 || !MJTree.this.fLooseSelectionEnabled && !MJTree.this.fRightSelectionEnabled) {
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = MJTree.this.getRowForLocation(n2, n = mouseEvent.getY());
            if (n3 != -1 && !bl) {
                return;
            }
            if (n3 == -1 && MJTree.this.fLooseSelectionEnabled) {
                n3 = MJTree.this.getClosestRowForLocation(n2, n);
                if (n3 != -1 && n3 == MJTree.this.getRowCount() - 1) {
                    serializable = MJTree.this.getRowBounds(n3);
                    if (n > ((Rectangle)serializable).y + ((Rectangle)serializable).height) {
                        n3 = -1;
                    }
                }
                if (n3 != -1) {
                    serializable = MJTree.this.getPathForRow(n3);
                    if (!MJTree.this.getModel().isLeaf(((TreePath)serializable).getLastPathComponent())) {
                        Rectangle rectangle = MJTree.this.getRowBounds(n3);
                        if (n2 < rectangle.x) {
                            int n4 = 16;
                            int n5 = 20;
                            TreeUI treeUI = MJTree.this.getUI();
                            if (treeUI instanceof BasicTreeUI) {
                                BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
                                n4 = basicTreeUI.getExpandedIcon().getIconWidth();
                                n5 = basicTreeUI.getRightChildIndent() + 2;
                            }
                            int n6 = rectangle.x - n5;
                            int n7 = n6 + n4;
                            if (n2 >= n6 && n2 <= n7) {
                                return;
                            }
                        }
                    }
                }
            }
            if (n3 == -1) {
                return;
            }
            if (MJTree.this.fRightSelectionEnabled && bl && MJTree.this.isRowSelected(n3)) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                if (MJTree.this.isRowSelected(n3)) {
                    MJTree.this.removeSelectionInterval(n3, n3);
                } else {
                    MJTree.this.addSelectionInterval(n3, n3);
                }
                serializable = MJTree.this.getPathForRow(n3);
                MJTree.this.setAnchorSelectionPath((TreePath)serializable);
                MJTree.this.setLeadSelectionPath((TreePath)serializable);
            } else if (mouseEvent.isShiftDown()) {
                serializable = MJTree.this.getAnchorSelectionPath();
                if (serializable != null && MJTree.this.getSelectionModel().getSelectionMode() != 1) {
                    int n8 = MJTree.this.getRowForPath((TreePath)serializable);
                    if (n8 < n3) {
                        MJTree.this.setSelectionInterval(n8, n3);
                    } else {
                        MJTree.this.setSelectionInterval(n3, n8);
                    }
                    MJTree.this.setAnchorSelectionPath((TreePath)serializable);
                } else if (!MJTree.this.isRowSelected(n3) || MJTree.this.getSelectionCount() > 1) {
                    MJTree.this.setSelectionInterval(n3, n3);
                }
                MJTree.this.setLeadSelectionPath(MJTree.this.getPathForRow(n3));
            } else if (!MJTree.this.isRowSelected(n3) || MJTree.this.getSelectionCount() > 1) {
                MJTree.this.setSelectionInterval(n3, n3);
            }
        }
    }
}

