/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.google.common.base.Preconditions;
import com.jgoodies.forms.layout.Sizes;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import com.mathworks.mwswing.CheckThreadViolationRepaintManager;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MMouseEvent;
import com.mathworks.mwswing.MultiSelectionEventType;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.util.Log;
import com.mathworks.util.NativeJava;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;

public class MJUtilities {
    private static final com.mathworks.util.logger.Log LOG = com.mathworks.util.logger.Log.getInstance((String)"com.mathworks.mwswing.MJUtilities");
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mwswing.resources.RES_mwswing");
    private static boolean sThreadingChecksEnabled = false;
    private static boolean sThreadSafetyWarningStackTraceSuppressed = false;
    private static boolean sCopyPrivateDuringMouseEventConversion = NativeJava.nativeLibraryExists() && PlatformInfo.isXWindows();
    private static boolean sAssistiveTechChecked = false;
    private static boolean sAssistiveTechAvailable = false;
    private static boolean sDoRegisterJIDE = true;
    public static final String DISPOSED_BUTTON = "disposed_button";
    public static ScheduledExecutorService sExecutor;

    private MJUtilities() {
    }

    public static void addPageKeyBindingsToMacJList(JList jList) {
        Validate.notNull((Object)jList);
        if (!PlatformInfo.isMacintosh() || jList.getInputMap().get(KeyStroke.getKeyStroke(34, 0)) != null || jList.getInputMap().get(KeyStroke.getKeyStroke(33, 0)) != null) {
            return;
        }
        jList.getInputMap().put(KeyStroke.getKeyStroke(34, 0), "scrollDown");
        jList.getInputMap().put(KeyStroke.getKeyStroke(33, 0), "scrollUp");
    }

    public static void initJIDE() {
        if (sDoRegisterJIDE) {
            MJUtilities.initJideLicense();
            sDoRegisterJIDE = false;
            System.setProperty("jide.useImageIO", "false");
            LookAndFeelFactory.setDefaultStyle((int)0);
            LookAndFeelFactory.installJideExtension();
        }
    }

    public static void initJideLicense() {
        Lm.verifyLicense((String)"The MathWorks", (String)"MATLAB and Toolboxes", (String)"ZAHTQ89IAF8Itf.ptgzFy9V7lYu3L813");
    }

    public static boolean threadSafetyWarningStackTraceSuppressed() {
        return sThreadSafetyWarningStackTraceSuppressed;
    }

    public static void setThreadSafetyWarningStackTraceSuppressed(boolean bl) {
        sThreadSafetyWarningStackTraceSuppressed = bl;
    }

    public static boolean threadingChecksEnabled() {
        return sThreadingChecksEnabled;
    }

    public static void setThreadingChecksEnabled(boolean bl) {
        sThreadingChecksEnabled = bl;
    }

    public static void assertIsEventThread() {
        if (sThreadingChecksEnabled && !SwingUtilities.isEventDispatchThread()) {
            ThreadSafetyWarning threadSafetyWarning = new ThreadSafetyWarning();
            if (sThreadSafetyWarningStackTraceSuppressed) {
                System.out.println(threadSafetyWarning.getMessage());
            } else {
                threadSafetyWarning.printStackTrace(System.out);
            }
        }
    }

    public static String intlString(String string) {
        return BUNDLE.getString(string);
    }

    public static String exciseAmpersand(String string) {
        return MJUtilities.exciseMnemonic(string, PlatformInfo.isMacintosh());
    }

    public static String exciseMnemonic(String string) {
        return MJUtilities.exciseMnemonic(string, true);
    }

    public static String exciseBracketMnemonic(String string) {
        int n;
        int n2;
        if (string != null && (n2 = string.indexOf(91)) >= 0 && (n = string.indexOf(93, n2 + 1)) >= 0 && n2 + 1 != n) {
            return string.substring(0, n2) + string.substring(n + 1);
        }
        return string;
    }

    private static String exciseMnemonic(String string, boolean bl) {
        if (string != null) {
            int n = string.indexOf(38);
            while (n >= 0 && n < string.length() - 1) {
                char c = string.charAt(n + 1);
                if (!Character.isWhitespace(c)) {
                    String string2 = string.substring(0, n) + string.substring(n + 1);
                    return bl ? MJUtilities.removeMnemonicText(string2, c) : string2;
                }
                n = string.indexOf(38, n + 1);
            }
        }
        return string;
    }

    public static char findMnemonic(String string) {
        if (string != null) {
            if (PlatformInfo.isMacintosh()) {
                return '\u0000';
            }
            int n = string.indexOf(38);
            while (n >= 0 && n < string.length() - 1) {
                char c = string.charAt(n + 1);
                if (!Character.isWhitespace(c)) {
                    return c;
                }
                n = string.indexOf(38, n + 1);
            }
        }
        return '\u0000';
    }

    public static int indexOfMnemonic(String string) {
        if (string != null) {
            if (PlatformInfo.isMacintosh()) {
                return -1;
            }
            int n = string.indexOf(38);
            while (n >= 0 && n < string.length() - 1) {
                char c = string.charAt(n + 1);
                if (!Character.isWhitespace(c)) {
                    return n + 1;
                }
                n = string.indexOf(38, n + 1);
            }
        }
        return -1;
    }

    public static void setMnemonicFromText(AbstractButton abstractButton, String string) {
        int n = MJUtilities.indexOfMnemonic(string);
        if (n == -1) {
            abstractButton.setMnemonic('\u0000');
        } else {
            char c = string.charAt(n);
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n - 1);
        }
    }

    public static void setMnemonicFromText(JLabel jLabel, String string) {
        int n = MJUtilities.indexOfMnemonic(string);
        if (n == -1) {
            jLabel.setDisplayedMnemonic('\u0000');
        } else {
            char c = string.charAt(n);
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n - 1);
        }
    }

    public static String removeMnemonicText(String string, int n) {
        String string2 = string;
        if (string != null && string.length() >= 3 && (string.endsWith(")") || string.endsWith(")..."))) {
            int n2 = string.lastIndexOf(41);
            if (string.lastIndexOf(40) == n2 - 2 && string.charAt(n2 - 1) == n) {
                string2 = string.substring(0, n2 - 2) + string.substring(n2 + 1);
            }
        }
        return string2;
    }

    public static void updateInputMap(JTextComponent jTextComponent, KeyBindingManager keyBindingManager, String string) {
        assert (keyBindingManager != null) : "KeyBindingManager cannot be null";
        assert (keyBindingManager.containsContext(string)) : "Context specified does not exist in new manager";
        MInputMap mInputMap = MInputMap.createMInputMap(jTextComponent);
        KeyBindingManager keyBindingManager2 = (KeyBindingManager)jTextComponent.getClientProperty("KeyBindingManager");
        String[] stringArray = new String[]{"cut-to-clipboard", "copy-to-clipboard", "paste-from-clipboard", "select-all"};
        if (keyBindingManager2 != null) {
            String object = (String)jTextComponent.getClientProperty("KeyBindingManagerContext");
            assert (object != null) : "No context was stored for the old keybinding manager";
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int string3 = 0; string3 < n; ++string3) {
                String string2 = stringArray2[string3];
                keyBindingManager2.clearKeyBindings(object, string2, mInputMap);
            }
        }
        for (String string3 : stringArray) {
            MJUtilities.doInputMapRegistration(string3, string, mInputMap, keyBindingManager);
        }
        jTextComponent.putClientProperty("KeyBindingManager", keyBindingManager);
        jTextComponent.putClientProperty("KeyBindingManagerContext", string);
    }

    private static void doInputMapRegistration(String string, String string2, MInputMap mInputMap, KeyBindingManager keyBindingManager) {
        assert (keyBindingManager.containsAction(string)) : "Action '" + string + "' is not registered";
        keyBindingManager.addKeyBindings(string2, string, mInputMap);
    }

    public static void registerWithKeyBindingManager(KeyBindingManagerRegistrant keyBindingManagerRegistrant, KeyBindingManager keyBindingManager, String string) {
        keyBindingManagerRegistrant.registerWithKeyBindingManager(keyBindingManager, string);
    }

    public static void dispose(AbstractButton abstractButton) {
        if (abstractButton.getAction() != null) {
            abstractButton.putClientProperty(DISPOSED_BUTTON, "true");
            if (PlatformInfo.isMacintosh() && abstractButton instanceof JMenuItem) {
                abstractButton.setAction(new MJAbstractAction("disposed"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                });
            } else {
                abstractButton.setAction(null);
            }
        }
    }

    public static boolean isPopupPrecursor(MouseEvent mouseEvent) {
        return PlatformInfo.isWindows() && SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public static boolean isMacintoshPopupTrigger(MouseEvent mouseEvent) {
        return MJUtilities.isRightMouseButton(mouseEvent);
    }

    public static boolean isPopupSuccesor(MouseEvent mouseEvent) {
        return PlatformInfo.isXWindows() && SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public static MouseEvent convertMouseEvent(Component component, MouseEvent mouseEvent, Component component2) {
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(component, mouseEvent, component2);
        if (sCopyPrivateDuringMouseEventConversion) {
            try {
                NativeJava.copyPrivateEventData((Object)mouseEvent, (Object)mouseEvent2);
            }
            catch (Throwable throwable) {
                sCopyPrivateDuringMouseEventConversion = false;
            }
        }
        return mouseEvent2;
    }

    public static int getPixelSize(int n) {
        return Sizes.dialogUnitXAsPixel((int)n, (Component)new JPanel());
    }

    public static int getCheckBoxIndent() {
        return UIManager.getIcon("CheckBox.icon").getIconWidth() + UIManager.getInsets((Object)"CheckBox.margin").left + UIManager.getInsets((Object)"CheckBox.margin").right + UIManager.getInt("CheckBox.textIconGap");
    }

    public static int getRadioButtonIndent() {
        return UIManager.getIcon("RadioButton.icon").getIconWidth() + UIManager.getInsets((Object)"RadioButton.margin").left + UIManager.getInsets((Object)"RadioButton.margin").right + UIManager.getInt("RadioButton.textIconGap");
    }

    public static Rectangle getScreenBounds() {
        return WindowUtils.getScreenBounds();
    }

    public static Rectangle getVirtualScreenBounds() {
        return WindowUtils.getVirtualScreenBounds();
    }

    public static boolean hasMultipleMonitors() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length > 1;
    }

    public static Point getPopupLocation(Component component, Dimension dimension, Point point) {
        return WindowUtils.getPopupLocation(component, dimension, point);
    }

    public static Point ensureOnScreen(Point point, Dimension dimension, int n) {
        return WindowUtils.ensureOnScreen(point, dimension, n);
    }

    public static Point ensureOnScreen(Rectangle rectangle, Point point, Dimension dimension, int n) {
        return WindowUtils.ensureOnScreen(rectangle, point, dimension, n);
    }

    public static int getDoubleClickInterval() {
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 500;
    }

    public static int getCaretBlinkRate() {
        return NativeJava.getCaretBlinkRate();
    }

    public static boolean isModifierOnly(int n) {
        return n == 17 || n == 18 || n == 157 || n == 16;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void addFirstMouseListener(Component component, MouseListener mouseListener) {
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        for (int i = mouseListenerArray.length - 1; i >= 0; --i) {
            component.removeMouseListener(mouseListenerArray[i]);
        }
        component.addMouseListener(mouseListener);
        for (MouseListener mouseListener2 : mouseListenerArray) {
            component.addMouseListener(mouseListener2);
        }
    }

    public static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    static void triggerContextMenu(Component component, Component component2, long l) {
        Point point;
        Serializable serializable;
        if (PlatformInfo.isWindows()) {
            if (component instanceof JTextComponent) {
                serializable = (JTextComponent)component;
                try {
                    point = serializable.modelToView(serializable.getCaretPosition()).getLocation();
                }
                catch (BadLocationException badLocationException) {
                    point = serializable.getVisibleRect().getLocation();
                }
            } else {
                point = component instanceof JComponent ? ((JComponent)component).getVisibleRect().getLocation() : new Point();
            }
        } else {
            throw new IllegalStateException("The invokeContextMenu method should only be used on Microsoft Windows platforms.");
        }
        serializable = new MMouseEvent(component2, 501, l, 4, point.x, point.y, 1, false, true);
        MMouseEvent mMouseEvent = new MMouseEvent(component2, 502, l + 10L, 4, point.x, point.y, 1, true, true);
        MMouseEvent mMouseEvent2 = new MMouseEvent(component2, 500, l + 20L, 4, point.x, point.y, 1, false, true);
        component.dispatchEvent((AWTEvent)serializable);
        component.dispatchEvent(mMouseEvent);
        component.dispatchEvent(mMouseEvent2);
    }

    public static void assertEventDispatchThread() {
        Preconditions.checkState((boolean)EventQueue.isDispatchThread(), (Object)"Not Event Dispatch Thread");
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void runOnEventDispatchThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static <T> void runOnEventDispatchThread(final ParameterRunnable<T> parameterRunnable, final T t) {
        MJUtilities.runOnEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                parameterRunnable.run(t);
            }
        });
    }

    public static void invokeLater(final Object object, final Method method, final Object[] objectArray) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    method.invoke(object, objectArray);
                }
                catch (Exception exception) {
                    LOG.warn((Throwable)exception);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static void invokeLater(final Runnable runnable, long l, TimeUnit timeUnit) {
        if (l == 0L) {
            MJUtilities.invokeLater(runnable);
        } else {
            MJUtilities.getExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    MJUtilities.invokeLater(runnable);
                }
            }, l, timeUnit);
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static synchronized ScheduledExecutorService getExecutor() {
        if (sExecutor == null) {
            sExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        return sExecutor;
    }

    public static boolean isAssistiveTechAvailable() {
        if (!sAssistiveTechChecked) {
            if (!PlatformInfo.isWindows()) {
                sAssistiveTechAvailable = false;
            } else {
                String string = System.getProperty("java.home");
                File file = new File(new File(string, "lib"), "accessibility.properties");
                if (file.exists()) {
                    int n;
                    String string2 = null;
                    try {
                        string2 = FileUtils.readFileToString((File)file);
                    }
                    catch (IOException iOException) {
                        Log.logException((Exception)iOException);
                    }
                    String string3 = "assistive_technologies=";
                    String string4 = null;
                    if (string2.indexOf(string3) == 0) {
                        string4 = string2.substring(string3.length());
                    } else {
                        String string5 = "\nassistive_technologies=";
                        String string6 = "\rassistive_technologies=";
                        n = string2.indexOf(string5);
                        int n2 = string2.indexOf(string6);
                        if (n != -1) {
                            string4 = string2.substring(n + string5.length());
                        }
                        if (n2 != -1) {
                            string4 = string2.substring(n2 + string6.length());
                        }
                    }
                    if (string4 != null) {
                        int n3 = string4.indexOf(10);
                        int n4 = string4.indexOf(13);
                        n = string4.length() - 1;
                        if (n3 != -1) {
                            n = n3;
                        }
                        if (n4 != -1) {
                            n = n < n4 ? n : n4;
                        }
                        String string7 = string4.substring(0, n).trim();
                        try {
                            Class<?> clazz = Class.forName(string7);
                            Class<?>[] classArray = clazz.getInterfaces();
                            boolean bl = false;
                            for (Class<?> clazz2 : classArray) {
                                bl = bl || clazz2.equals(Runnable.class);
                            }
                            sAssistiveTechAvailable = bl;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            sAssistiveTechChecked = true;
        }
        return sAssistiveTechAvailable;
    }

    public static boolean isHighContrast() {
        boolean bl = false;
        if (PlatformInfo.isWindows()) {
            Color color = (Color)UIManager.get("Button.foreground");
            Color color2 = (Color)UIManager.get("Button.background");
            bl = Color.black.equals(color) && Color.white.equals(color2) || Color.black.equals(color2);
        }
        return bl;
    }

    public static void setGlobalCursor(Window window, Cursor cursor) {
        GlobalCursor.set(window, cursor);
    }

    public static void clearGlobalCursor(Window window) {
        GlobalCursor.clear(window);
    }

    public static void handleMouseReleased(MouseEvent mouseEvent, int n, ListSelectionModel listSelectionModel) {
        MultiSelectionEventType.getMouseReleasedSelectionType(mouseEvent, listSelectionModel.isSelectedIndex(n)).performOnTable(listSelectionModel, n);
    }

    public static InputMap createCompositeInputMap(InputMap ... inputMapArray) {
        InputMap inputMap = new InputMap();
        InputMap[] inputMapArray2 = inputMapArray;
        int n = inputMapArray2.length;
        for (int i = 0; i < n; ++i) {
            for (InputMap inputMap2 = inputMapArray2[i]; inputMap2 != null; inputMap2 = inputMap2.getParent()) {
                if (inputMap2.keys() == null) continue;
                for (KeyStroke keyStroke : inputMap2.keys()) {
                    Object object = inputMap2.get(keyStroke);
                    if (object == null) continue;
                    inputMap.put(keyStroke, object);
                }
            }
        }
        return inputMap;
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        if (PlatformInfo.isMacintosh()) {
            return SwingUtilities.isLeftMouseButton(mouseEvent) && (mouseEvent.getModifiers() & 2) != 0 || mouseEvent.getButton() == 3;
        }
        return SwingUtilities.isRightMouseButton(mouseEvent);
    }

    public static boolean isShowingContextMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        return menuElementArray != null && menuElementArray.length > 0 && menuElementArray[0] instanceof JPopupMenu;
    }

    private static class ThreadSafetyWarning
    extends Throwable {
        private ThreadSafetyWarning() {
            super(CheckThreadViolationRepaintManager.createViolationMessage());
        }
    }
}

