/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.MJComboBox;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

class MouseWheelRedirector
implements AWTEventListener {
    private static MouseWheelRedirector sInstance;
    private static boolean sIsEnabled;
    private boolean fRedirectIsInProgress;

    private MouseWheelRedirector() {
    }

    static void setEnabled(boolean bl) {
        if (bl != sIsEnabled) {
            sIsEnabled = bl;
            if (sInstance == null) {
                sInstance = new MouseWheelRedirector();
            }
            if (bl) {
                Toolkit.getDefaultToolkit().addAWTEventListener(sInstance, 131072L);
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(sInstance);
            }
        }
    }

    static boolean isEnabled() {
        return sIsEnabled;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 507) {
            Component component;
            if (this.fRedirectIsInProgress) {
                return;
            }
            this.fRedirectIsInProgress = true;
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            Component component2 = mouseWheelEvent.getComponent();
            Container container = component2.getParent();
            Window window = SwingUtilities.windowForComponent(component2);
            if (!(!(window instanceof JFrame) || container instanceof JPopupMenu || component2 instanceof JScrollPane && container instanceof JLayeredPane || (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null || component2 instanceof Window && !component.isLightweight())) {
                MJComboBox mJComboBox = (MJComboBox)SwingUtilities.getAncestorOfClass(MJComboBox.class, component);
                if (mJComboBox != null && mJComboBox.getPopupScrollPane() != null) {
                    component = mJComboBox.getPopupScrollPane();
                }
                if (component != component2) {
                    if (CellViewer.getInstance().isShowing()) {
                        CellViewer.getInstance().hide();
                    }
                    Point point = SwingUtilities.convertPoint(component2, mouseWheelEvent.getX(), mouseWheelEvent.getY(), component);
                    MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent(component, 507, mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                    component.dispatchEvent(mouseWheelEvent2);
                    mouseWheelEvent.consume();
                }
            }
            this.fRedirectIsInProgress = false;
        }
    }
}

