/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JDialog;

public class TransparentWindowFactory {
    private static boolean sTransparencySupported = false;

    private TransparentWindowFactory() {
    }

    public static boolean isTransparencySupported() {
        return sTransparencySupported;
    }

    public static boolean isTransparent(MJDialog mJDialog) {
        return mJDialog instanceof RobotBasedTransparentDialog && RobotBasedTransparentDialog.isTransparencySupported();
    }

    private static void overrideIsTransparencySupported(boolean bl) {
        sTransparencySupported = bl;
    }

    public static JDialog createTransparentDialog(Dialog dialog, boolean bl) {
        MJDialog mJDialog = bl ? new RobotBasedTransparentDialog((Window)dialog) : new MJDialog(dialog);
        TransparentWindowFactory.initWindow(mJDialog);
        return mJDialog;
    }

    public static JDialog createTransparentDialog(Dialog dialog, boolean bl, boolean bl2) {
        MJDialog mJDialog = bl2 ? new RobotBasedTransparentDialog((Window)dialog, bl) : new MJDialog(dialog, bl);
        TransparentWindowFactory.initWindow(mJDialog);
        return mJDialog;
    }

    public static JDialog createTransparentDialog(Frame frame, boolean bl) {
        MJDialog mJDialog = bl ? new RobotBasedTransparentDialog((Window)frame) : new MJDialog(frame);
        TransparentWindowFactory.initWindow(mJDialog);
        return mJDialog;
    }

    public static JDialog createTransparentDialog(Frame frame, boolean bl, boolean bl2) {
        MJDialog mJDialog = bl2 ? new RobotBasedTransparentDialog((Window)frame, bl) : new MJDialog(frame, bl);
        TransparentWindowFactory.initWindow(mJDialog);
        return mJDialog;
    }

    private static void initWindow(JDialog jDialog) {
        jDialog.setUndecorated(true);
        jDialog.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
    }

    private static final class RobotBasedTransparentDialog
    extends MJDialog {
        private TransparentPanel fContentPane;
        private boolean fTransparent = true;
        private Window fOwner;
        private ComponentListener fComponentListener;
        private WindowFocusListener fWindowFocusListener;
        private static Robot sRobot;

        private RobotBasedTransparentDialog(Window window) {
            super((Frame)window.getParent());
            this.fOwner = window;
            this.initialize();
            this.setTransparent(true);
        }

        private RobotBasedTransparentDialog(Window window, boolean bl) {
            this.setAlwaysOnTop(bl);
            this.fOwner = window;
            this.initialize();
            this.setTransparent(true);
        }

        void setTransparent(boolean bl) {
            this.fTransparent = bl;
            if (this.fTransparent && RobotBasedTransparentDialog.isTransparencySupported()) {
                this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            }
        }

        static boolean isTransparencySupported() {
            return PlatformInfo.isIntelMac() || PlatformInfo.isWindows();
        }

        @Override
        public void show() {
            if (PlatformInfo.isWindows() && this.fTransparent && this.fContentPane != null && this.getContentPane() == this.fContentPane) {
                this.fContentPane.takeSnapShot();
            }
            super.show();
            this.paint(this.getGraphics());
        }

        @Override
        public void toFront() {
            this.setFocusableWindowState(false);
            super.toFront();
        }

        void initialize() {
            if (PlatformInfo.isWindows()) {
                try {
                    sRobot = new Robot();
                }
                catch (AWTException aWTException) {
                    Log.logException((Exception)aWTException);
                }
                this.fContentPane = new TransparentPanel();
                this.setContentPane(this.fContentPane);
            } else if (PlatformInfo.isIntelMac()) {
                this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
            }
            this.fComponentListener = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    RobotBasedTransparentDialog.this.fOwner.removeComponentListener(RobotBasedTransparentDialog.this.fComponentListener);
                    RobotBasedTransparentDialog.this.dispose();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    RobotBasedTransparentDialog.this.fOwner.removeComponentListener(RobotBasedTransparentDialog.this.fComponentListener);
                    RobotBasedTransparentDialog.this.dispose();
                }
            };
            this.fOwner.addComponentListener(this.fComponentListener);
            this.fWindowFocusListener = new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    RobotBasedTransparentDialog.this.toFront();
                }

                @Override
                public void windowGainedFocus(WindowEvent windowEvent) {
                    RobotBasedTransparentDialog.this.toFront();
                }
            };
            this.fOwner.addWindowFocusListener(this.fWindowFocusListener);
        }

        void deParent() {
            this.cleanup();
        }

        @Override
        public void dispose() {
            this.cleanup();
            super.dispose();
        }

        void cleanup() {
            if (this.fOwner != null) {
                this.fOwner.removeComponentListener(this.fComponentListener);
                this.fOwner.removeWindowFocusListener(this.fWindowFocusListener);
            }
            this.fComponentListener = null;
            this.fWindowFocusListener = null;
            this.fOwner = null;
        }

        private class TransparentPanel
        extends MJPanel {
            private BufferedImage fImage;

            private TransparentPanel() {
                super(new BorderLayout(5, 5));
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                if (RobotBasedTransparentDialog.this.fTransparent) {
                    graphics.drawImage(this.fImage, this.getBounds().x, this.getBounds().y, null);
                } else {
                    super.paintComponent(graphics);
                }
            }

            private void takeSnapShot() {
                if (sRobot == null) {
                    return;
                }
                Rectangle rectangle = RobotBasedTransparentDialog.this.getBounds();
                if (rectangle.width <= 0 || rectangle.height <= 0) {
                    return;
                }
                Point point = new Point(rectangle.x, rectangle.y);
                this.fImage = sRobot.createScreenCapture(new Rectangle(point.x, point.y, rectangle.width, rectangle.height));
            }
        }
    }
}

