/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.jgoodies.forms.layout.Sizes;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.ScreenInformationProvider;
import com.mathworks.mwswing.SystemGraphicsEnvironment;
import com.mathworks.util.Log;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;

public final class WindowUtils {
    private static final int DEFAULT_MARGIN = 10;
    private static ScreenInformationProvider sGraphicsEnvironment = SystemGraphicsEnvironment.getInstance();

    private WindowUtils() {
    }

    public static void setGraphicsEnvironment(ScreenInformationProvider screenInformationProvider) {
        if (screenInformationProvider == null) {
            throw new IllegalArgumentException("Graphics Environment cannot be null.");
        }
        sGraphicsEnvironment = screenInformationProvider;
    }

    public static void centerWindowOnScreen(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("'window' must not be null");
        }
        window.setLocationRelativeTo(null);
    }

    public static void centerWindowOnParent(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("'window' must not be null");
        }
        window.setLocationRelativeTo(window.getParent());
        WindowUtils.ensureOnScreen(window);
    }

    public static void positionUnderneathParentTitle(Window window, Window window2) {
        if (window == null) {
            window2.setLocationRelativeTo(window);
        } else {
            Rectangle rectangle = window.getBounds();
            Point point = rectangle.getLocation();
            int n = sGraphicsEnvironment.getActiveTitleBarHeight();
            Rectangle rectangle2 = window2.getBounds();
            Rectangle rectangle3 = WindowUtils.getScreenBounds();
            if (rectangle2.height + point.y > rectangle3.height || rectangle2.width + point.x > rectangle3.width) {
                WindowUtils.centerWindowOnParent(window2);
            } else {
                int n2 = point.x;
                int n3 = point.y + n;
                window2.setLocation(n2, n3);
            }
        }
    }

    public static void setChildLocationWithinParent(Window window, Window window2) {
        Dimension dimension = window2.getSize();
        Rectangle rectangle = window != null ? window.getBounds() : WindowUtils.getScreenBounds();
        rectangle.x += (rectangle.width - dimension.width) / 2;
        rectangle.y += (rectangle.height - dimension.height) / 3;
        window2.setLocation(Math.max(0, rectangle.x), Math.max(0, rectangle.y));
    }

    public static void setSizeInDlus(Window window, int n, int n2) {
        Validate.notNull((Object)window, (String)"'window' cannot be null");
        window.setSize(Sizes.dialogUnitXAsPixel((int)n, (Component)window), Sizes.dialogUnitYAsPixel((int)n2, (Component)window));
    }

    public static Rectangle computeTextPopupBounds(Dimension dimension, Dimension dimension2, JTextComponent jTextComponent, TextPopupLocation textPopupLocation) {
        Point point;
        try {
            Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
            point = rectangle == null ? new Point() : rectangle.getLocation();
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            point = new Point();
        }
        SwingUtilities.convertPointToScreen(point, jTextComponent);
        int n = jTextComponent.getFontMetrics(jTextComponent.getFont()).getHeight();
        return WindowUtils.computeTextPopupBounds(dimension, dimension2, point, n, textPopupLocation);
    }

    public static Rectangle computeTextPopupBounds(Dimension dimension, Dimension dimension2, Point point, int n, TextPopupLocation textPopupLocation) {
        Rectangle rectangle = WindowUtils.getScreenBoundsWithOrNearestToPoint(point);
        return WindowUtils.computeTextPopupBounds(rectangle, dimension, dimension2, point, n, textPopupLocation);
    }

    public static boolean isEntirelyOnSingleScreen(Rectangle rectangle) {
        Rectangle rectangle2 = WindowUtils.getScreenBoundsWithOrNearestToPoint(rectangle.getLocation());
        return rectangle2.contains(rectangle);
    }

    public static Rectangle computeTextPopupBounds(Rectangle rectangle, Dimension dimension, Dimension dimension2, Point point, int n, TextPopupLocation textPopupLocation) {
        int n2;
        int n3;
        int n4 = rectangle.y + rectangle.height;
        int n5 = Math.max(rectangle.y, point.y);
        n5 = Math.min(n5, n4);
        int n6 = n5 - dimension.height;
        int n7 = n5 + n + dimension.height;
        int n8 = n5 - dimension2.height;
        int n9 = n5 + n + dimension2.height;
        boolean bl = n6 >= rectangle.y;
        boolean bl2 = n7 <= n4;
        int n10 = n5 + n;
        if (textPopupLocation == TextPopupLocation.BELOW_PREFERRED && !bl2 && !bl && n9 <= n4) {
            n3 = n4 - n5 - n;
            n2 = n10;
        } else if (textPopupLocation == TextPopupLocation.ABOVE_PREFERRED && !bl2 && !bl && n8 >= rectangle.y) {
            n3 = n5 - rectangle.y;
            n2 = n5 - n3;
        } else if (textPopupLocation == TextPopupLocation.BELOW_PREFERRED && bl2 || !bl) {
            n3 = dimension.height;
            n2 = n10;
        } else {
            n3 = dimension.height;
            n2 = n5 - n3;
        }
        int n11 = rectangle.x + rectangle.width;
        int n12 = point.x + dimension.width > n11 ? n11 - dimension.width : (point.x < rectangle.x ? rectangle.x : point.x);
        Rectangle rectangle2 = new Rectangle(n12, n2, dimension.width, n3);
        rectangle2.setLocation(WindowUtils.ensureOnScreen(rectangle, rectangle2.getLocation(), rectangle2.getSize(), 0));
        return rectangle2;
    }

    public static void ensureOnScreen(Window window) {
        Point point = WindowUtils.ensureOnScreen(window.getLocation(), window.getSize(), 10);
        window.setLocation(point.x, point.y);
    }

    public static void ensureOnSingleScreen(Window window) {
        Point point = WindowUtils.ensureOnScreen(WindowUtils.getScreenBoundsWithOrNearestToPoint(window.getLocation()), window.getLocation(), window.getSize(), 10);
        window.setLocation(point.x, point.y);
    }

    public static Point ensureOnScreen(Point point, Dimension dimension, int n) {
        return WindowUtils.ensureOnScreen(WindowUtils.getVirtualScreenBounds(), point, dimension, n);
    }

    public static Point ensureOnScreen(Rectangle rectangle, Point point, Dimension dimension, int n) {
        int n2;
        int n3;
        int n4 = point.x + dimension.width;
        int n5 = rectangle.x + rectangle.width - n;
        if (n4 > n5) {
            point.x = n5 - dimension.width;
        }
        if (point.x < rectangle.x + n) {
            point.x = rectangle.x + n;
        }
        if ((n3 = point.y + dimension.height) > (n2 = rectangle.y + rectangle.height - n)) {
            point.y = n2 - dimension.height;
        }
        if (point.y < rectangle.y + n) {
            point.y = rectangle.y + n;
        }
        return point;
    }

    public static void ensureTitleOnScreen(Window window) {
        Point point = WindowUtils.ensureTitleInBounds(WindowUtils.getVirtualScreenBounds(), window.getLocation(), window.getSize(), null);
        window.setLocation(point);
    }

    public static Point ensureTitleInBounds(Rectangle rectangle, Point point, Dimension dimension, Dimension dimension2) {
        if (dimension2 == null) {
            dimension2 = new Dimension(50, 30);
        }
        if (rectangle.width >= dimension2.width) {
            int n = rectangle.x + rectangle.width;
            if (point.x + dimension2.width > n) {
                point.x = n - dimension2.width;
            } else if (point.x + dimension.width < rectangle.x + dimension2.width) {
                point.x = rectangle.x + dimension2.width - dimension.width;
            }
        }
        if (rectangle.height >= dimension2.height) {
            if (point.y + dimension2.height > rectangle.y + rectangle.height) {
                point.y = rectangle.y + rectangle.height - dimension2.height;
            } else if (point.y < rectangle.y) {
                point.y = rectangle.y;
            }
        }
        return point;
    }

    public static Rectangle getScreenBounds() {
        GraphicsConfiguration graphicsConfiguration;
        Dimension dimension = sGraphicsEnvironment.getScreenSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        GraphicsDevice graphicsDevice = sGraphicsEnvironment.getDefaultScreenDevice();
        if (graphicsDevice != null && (graphicsConfiguration = graphicsDevice.getDefaultConfiguration()) != null) {
            rectangle = WindowUtils.getInsetScreenBounds(graphicsConfiguration);
        }
        return rectangle;
    }

    public static Rectangle getVirtualScreenBounds() {
        if ("true".equalsIgnoreCase(System.getProperty("matlab.desktop.disableVirtualScreenBounds"))) {
            return WindowUtils.getScreenBounds();
        }
        GraphicsDevice[] graphicsDeviceArray = sGraphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray.length == 1) {
            return WindowUtils.getScreenBounds();
        }
        Rectangle rectangle = new Rectangle();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            GraphicsConfiguration[] graphicsConfigurationArray;
            for (GraphicsConfiguration graphicsConfiguration : graphicsConfigurationArray = graphicsDevice.getConfigurations()) {
                rectangle = rectangle.union(WindowUtils.getInsetScreenBounds(graphicsConfiguration));
            }
        }
        return rectangle;
    }

    public static Point getPopupLocation(Component component, Dimension dimension, Point point) {
        SwingUtilities.convertPointToScreen(point, component);
        Rectangle rectangle = WindowUtils.getScreenBoundsWithOrNearestToPoint(point);
        WindowUtils.ensureOnScreen(rectangle, point, dimension, 0);
        return point;
    }

    public static Window getWindowForComponent(Component component) {
        Window window = component == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        return window;
    }

    public static Frame getFrameForComponent(Component component) {
        Window window;
        for (window = WindowUtils.getWindowForComponent(component); window != null && !(window instanceof Frame); window = window.getOwner()) {
        }
        return window instanceof Frame ? (Frame)window : null;
    }

    public static Window getTopmostWindow(Component component) {
        Window window;
        Window window2 = WindowUtils.getWindowForComponent(component);
        while (window2 != null && (window = window2.getOwner()) != null) {
            window2 = window;
        }
        return window2;
    }

    public static Rectangle getScreenBoundsWithOrNearestToPoint(Point point) {
        GraphicsConfiguration graphicsConfiguration = WindowUtils.screenWithPoint(point);
        if (graphicsConfiguration == null) {
            graphicsConfiguration = WindowUtils.nearestScreen(point);
        }
        assert (graphicsConfiguration != null) : "getScreenBounds must return the bounds of a screen.";
        return WindowUtils.getInsetScreenBounds(graphicsConfiguration);
    }

    private static GraphicsConfiguration screenWithPoint(Point point) {
        GraphicsDevice[] graphicsDeviceArray = sGraphicsEnvironment.getScreenDevices();
        GraphicsConfiguration graphicsConfiguration = null;
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDevice.getType() != 0 || !(graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        return graphicsConfiguration;
    }

    private static GraphicsConfiguration nearestScreen(Point point) {
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsDevice[] graphicsDeviceArray = sGraphicsEnvironment.getScreenDevices();
        int n = Integer.MAX_VALUE;
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            if (graphicsDevice.getType() != 0) continue;
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            int n2 = 0;
            int n3 = point.x;
            int n4 = point.y;
            Rectangle rectangle = graphicsConfiguration2.getBounds();
            if (n3 < rectangle.x) {
                n2 = rectangle.x - n3;
            } else if (n3 > rectangle.x + rectangle.width) {
                n2 = n3 - (rectangle.x + rectangle.width);
            }
            if (n4 < rectangle.y) {
                n2 += rectangle.y - n4;
            } else if (n4 > rectangle.y + rectangle.height) {
                n2 += n4 - (rectangle.y + rectangle.height);
            }
            if (n2 >= n) continue;
            graphicsConfiguration = graphicsConfiguration2;
            n = n2;
        }
        return graphicsConfiguration;
    }

    public static Rectangle getInsetScreenBounds(GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = sGraphicsEnvironment.getScreenInsets(graphicsConfiguration);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static MJDialog createDialogToParent(Component component, String string, boolean bl) {
        Window window = component == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        MJDialog mJDialog = window instanceof Frame ? new MJDialog((Frame)window, string, bl) : (window instanceof Dialog ? new MJDialog((Dialog)window, string, bl) : new MJDialog((Frame)null, string, bl));
        return mJDialog;
    }

    public static enum TextPopupLocation {
        BELOW_PREFERRED,
        ABOVE_PREFERRED;

    }
}

