/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.DefaultKeyBindingSetID;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.InitializationHelper;
import com.mathworks.util.InitializeBeforeAccess;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

final class ContextActionData
implements InitializeBeforeAccess {
    private Context fUnspecifiedFollowsContext;
    private final List<KeyStrokeList> fUnspecifiedAdditionalBindings = new LinkedList<KeyStrokeList>();
    private final ActionData fActionData;
    private final Map<String, Context> fFollowsContexts = new HashMap<String, Context>();
    private final Map<String, List<KeyStrokeList>> fAdditionalBindings = new HashMap<String, List<KeyStrokeList>>();
    private final InitializeBeforeAccess fInitializationHelper = new InitializationHelper();

    ContextActionData(ActionData actionData) {
        assert (actionData != null);
        this.fActionData = actionData;
        this.fUnspecifiedFollowsContext = Context.GLOBAL;
        this.fFollowsContexts.put(DefaultKeyBindingSet.EMPTY.getID(), Context.GLOBAL);
        this.fAdditionalBindings.put(DefaultKeyBindingSet.EMPTY.getID(), Collections.unmodifiableList(new LinkedList()));
    }

    ActionData getAction() {
        return this.fActionData;
    }

    void addKeyBinding(DefaultKeyBindingSetID defaultKeyBindingSetID, KeyStrokeList keyStrokeList) throws IllegalStateException {
        assert (defaultKeyBindingSetID != null && keyStrokeList != null);
        this.checkMutable();
        if (this.getFollowsComponentContext(defaultKeyBindingSetID, true)) {
            throw new IllegalStateException(this.fActionData + " is following a context other than global.  No additional key bindings can be defined");
        }
        List<KeyStrokeList> list = this.fAdditionalBindings.get(defaultKeyBindingSetID.getID());
        if (list == null) {
            list = new LinkedList<KeyStrokeList>();
            this.fAdditionalBindings.put(defaultKeyBindingSetID.getID(), list);
        }
        KeyStrokeUtils.addAllBindingVariations(keyStrokeList, list);
    }

    void setFollowsContext(DefaultKeyBindingSetID defaultKeyBindingSetID, Context context) throws IllegalStateException {
        List<KeyStrokeList> list;
        assert (defaultKeyBindingSetID != null && context != null);
        this.checkMutable();
        this.fFollowsContexts.put(defaultKeyBindingSetID.getID(), context);
        if (context.supportsActions() && (list = this.fAdditionalBindings.get(defaultKeyBindingSetID.getID())) != null) {
            list.clear();
        }
    }

    void addUnspecifiedBindings(KeyStrokeList keyStrokeList) throws IllegalStateException {
        assert (keyStrokeList != null);
        this.checkMutable();
        if (this.fUnspecifiedFollowsContext.supportsActions()) {
            throw new IllegalStateException(this.fActionData + " is following a context other than global.  No additional key bindings can be defined");
        }
        KeyStrokeUtils.addAllBindingVariations(keyStrokeList, this.fUnspecifiedAdditionalBindings);
    }

    void setUnspecifiedFollowsContext(Context context) throws IllegalStateException {
        assert (context != null);
        this.checkMutable();
        this.fUnspecifiedFollowsContext = context;
        if (context.supportsActions()) {
            this.fUnspecifiedAdditionalBindings.clear();
        }
    }

    private boolean getFollowsComponentContext(DefaultKeyBindingSetID defaultKeyBindingSetID, boolean bl) {
        assert (defaultKeyBindingSetID != null);
        Context context = this.privateGetFollowsContext(defaultKeyBindingSetID, bl);
        return context != null && context.supportsActions();
    }

    boolean getFollowsComponentContext(DefaultKeyBindingSetID defaultKeyBindingSetID) throws IllegalStateException {
        return this.getFollowsComponentContext(defaultKeyBindingSetID, false);
    }

    List<KeyStrokeList> getNonGlobalKeyBindings(DefaultKeyBindingSetID defaultKeyBindingSetID) throws IllegalStateException {
        List<KeyStrokeList> list;
        assert (defaultKeyBindingSetID != null);
        this.checkImmutable();
        LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>();
        Context context = this.getFollowsContext(defaultKeyBindingSetID);
        if (context == null) {
            context = this.fUnspecifiedFollowsContext;
        }
        if (context.supportsActions()) {
            linkedList.addAll(context.getContextAction(this.getAction()).getNonGlobalKeyBindings(defaultKeyBindingSetID));
        }
        if ((list = this.fAdditionalBindings.get(defaultKeyBindingSetID.getID())) == null) {
            list = this.fUnspecifiedAdditionalBindings;
        }
        linkedList.addAll(list);
        return Collections.unmodifiableList(linkedList);
    }

    List<KeyStrokeList> getKeyBindings(DefaultKeyBindingSetID defaultKeyBindingSetID) throws IllegalStateException {
        assert (defaultKeyBindingSetID != null);
        this.checkImmutable();
        LinkedList<KeyStrokeList> linkedList = new LinkedList<KeyStrokeList>();
        Context context = this.getFollowsContext(defaultKeyBindingSetID);
        if (context == null) {
            context = this.fUnspecifiedFollowsContext;
        }
        if (context.supportsActions()) {
            return context.getContextAction(this.getAction()).getKeyBindings(defaultKeyBindingSetID);
        }
        if (context.equals(Context.GLOBAL)) {
            linkedList.addAll(this.getAction().getBindings(defaultKeyBindingSetID));
        }
        linkedList.addAll(this.getNonGlobalKeyBindings(defaultKeyBindingSetID));
        return Collections.unmodifiableList(linkedList);
    }

    private Context privateGetFollowsContext(DefaultKeyBindingSetID defaultKeyBindingSetID, boolean bl) {
        Context context;
        assert (defaultKeyBindingSetID != null);
        if (!bl) {
            this.checkImmutable();
        }
        if ((context = this.fFollowsContexts.get(defaultKeyBindingSetID.getID())) == null) {
            context = this.fUnspecifiedFollowsContext;
        }
        return context;
    }

    Context getFollowsContext(DefaultKeyBindingSetID defaultKeyBindingSetID) throws IllegalStateException {
        return this.privateGetFollowsContext(defaultKeyBindingSetID, false);
    }

    public void initializationFinished() {
        this.fInitializationHelper.initializationFinished();
    }

    public void checkMutable() throws IllegalStateException {
        this.fInitializationHelper.checkMutable();
    }

    public void checkImmutable() throws IllegalStateException {
        this.fInitializationHelper.checkImmutable();
    }

    static boolean areCompletelyEquivalent(ContextActionData contextActionData, ContextActionData contextActionData2) {
        contextActionData.checkImmutable();
        contextActionData2.checkImmutable();
        return Context.areCompletelyEquivalent(contextActionData.fUnspecifiedFollowsContext, contextActionData2.fUnspecifiedFollowsContext) && ((Object)contextActionData.fUnspecifiedAdditionalBindings).equals(contextActionData2.fUnspecifiedAdditionalBindings) && ActionData.areCompletelyEquivalent(contextActionData.fActionData, contextActionData2.fActionData) && ((Object)contextActionData.fFollowsContexts).equals(contextActionData2.fFollowsContexts) && ((Object)contextActionData.fAdditionalBindings).equals(contextActionData2.fAdditionalBindings);
    }
}

