/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.ContextID;
import com.mathworks.mwswing.binding.CustomActionInfo;
import com.mathworks.mwswing.binding.CustomKeyBindingSet;
import com.mathworks.mwswing.binding.CustomKeyBindingSetReader;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistry;
import com.mathworks.mwswing.binding.KeyBindingReaderUtils;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.ReadWriteException;
import com.mathworks.xml.XMLUtils;
import com.mathworks.xml.XMLValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomKeyBindingSetUtils {
    private CustomKeyBindingSetUtils() {
    }

    public static CustomKeyBindingSet readFromFile(File file, KeyBindingManagerRegistry keyBindingManagerRegistry) throws ReadWriteException, FileNotFoundException {
        return new CustomKeyBindingSetReader(file.getPath(), file.getAbsolutePath(), new FileInputStream(file), keyBindingManagerRegistry).getKeyBindingSet();
    }

    public static void writeToFile(File file, CustomKeyBindingSet customKeyBindingSet) throws ReadWriteException {
        CustomKeyBindingSetUtils.writeToFile(file, customKeyBindingSet, false);
    }

    public static void writeModifiedDefaultToFile(File file, CustomKeyBindingSet customKeyBindingSet) throws ReadWriteException {
        CustomKeyBindingSetUtils.writeToFile(file, customKeyBindingSet, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeToFile(File file, CustomKeyBindingSet customKeyBindingSet, boolean bl) throws ReadWriteException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement("CustomKeySet");
            assert (customKeyBindingSet.getParent() != null) : "CustomKeyBindingSet does not have a parent keybinding set";
            element.setAttribute("derivedfrom", customKeyBindingSet.getParent().getID());
            element.setAttribute("modifieddefault", String.valueOf(bl));
            document.appendChild(element);
            Element element2 = document.createElement("Context");
            element2.setAttribute("id", Context.GLOBAL.getID());
            Map<ActionData, List<KeyStrokeList>> map = customKeyBindingSet.getGlobalMap();
            assert (map != null) : "A global keybinding map should exist";
            element.appendChild(element2);
            for (ActionData actionData : map.keySet()) {
                CustomKeyBindingSetUtils.writeActionToXML(document, element2, actionData, map.get(actionData), false);
            }
            Map<ContextID, Map<ActionDataID, CustomActionInfo>> map2 = customKeyBindingSet.getContextMap();
            for (ContextID contextID : map2.keySet()) {
                Element element3 = document.createElement("Context");
                element3.setAttribute("id", contextID.getID());
                Map map3 = (Map)map2.get(contextID);
                for (ActionDataID actionDataID : map3.keySet()) {
                    CustomActionInfo customActionInfo = (CustomActionInfo)map3.get(actionDataID);
                    CustomKeyBindingSetUtils.writeActionToXML(document, element3, actionDataID, customActionInfo.getLocalBindings(), !customActionInfo.isFollowingGlobal());
                }
                element.appendChild(element3);
            }
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)"utf-8");
            outputStreamWriter.flush();
            assert (CustomKeyBindingSetUtils.isValidCustomSet(file) == !bl) : "Generated custom set has invalid XML-- please create a bug report and attach file: " + file.getPath();
        }
        catch (IOException iOException) {
            try {
                throw new ReadWriteException(iOException, ReadWriteException.IOErrorType.WRITE_FILE_ERROR, "writer.error.genericWritingError", file.getPath());
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new ReadWriteException(parserConfigurationException, ReadWriteException.IOErrorType.SAX_WRITE_ERROR, "writer.error.errorCreatingXML", file.getPath());
                }
                catch (Exception exception) {
                    throw new ReadWriteException(exception, ReadWriteException.IOErrorType.SAX_WRITE_ERROR, "writer.error.genericSerializeError", file.getPath());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
    }

    public static CustomKeyBindingSet transformToSetWithEmptyParent(CustomKeyBindingSet customKeyBindingSet, KeyBindingManager keyBindingManager) {
        if (customKeyBindingSet.getParent() == DefaultKeyBindingSet.EMPTY) {
            return customKeyBindingSet;
        }
        CustomKeyBindingSet customKeyBindingSet2 = new CustomKeyBindingSet(customKeyBindingSet.getID() + "EmptyParent", DefaultKeyBindingSet.EMPTY, customKeyBindingSet.getName());
        for (ActionData actionData : keyBindingManager.getActions()) {
            customKeyBindingSet2.addGlobalBindings(actionData, customKeyBindingSet.getActionGlobalKeyBindings(actionData));
            for (Context context : keyBindingManager.getContextsWithAction(actionData)) {
                CustomKeyBindingSetUtils.writeOutContextActionInfo(context, actionData, customKeyBindingSet, customKeyBindingSet2);
            }
        }
        return customKeyBindingSet2;
    }

    private static void writeOutContextActionInfo(Context context, ActionData actionData, CustomKeyBindingSet customKeyBindingSet, CustomKeyBindingSet customKeyBindingSet2) {
        Context context2;
        Context context3 = context2 = customKeyBindingSet.getFollowsComponentContext(context, actionData) ? customKeyBindingSet.getFollowsContext(context, actionData) : context;
        assert (!customKeyBindingSet.getFollowsComponentContext(context2, actionData)) : "It is currently assumed that a context does not follow a component context which itself is following a component context. This would add considerable complexity, and there is not presently a use case for it.";
        for (KeyStrokeList keyStrokeList : customKeyBindingSet.getNonGlobalKeyBindings(context2, actionData)) {
            customKeyBindingSet2.addCustomKeyBinding(context, actionData, keyStrokeList.toKeyStrokeArray());
        }
        customKeyBindingSet2.changeFollowsGlobal(context, actionData, customKeyBindingSet.getFollowsContext(context2, actionData) == Context.GLOBAL);
    }

    private static void writeActionToXML(Document document, Element element, ActionDataID actionDataID, List<KeyStrokeList> list, boolean bl) {
        Element element2 = document.createElement("Action");
        element2.setAttribute("id", actionDataID.getID());
        if (bl) {
            element2.setAttribute("follows", Context.NONE.getID());
        }
        for (KeyStrokeList keyStrokeList : list) {
            element2.appendChild(CustomKeyBindingSetUtils.createNodeForKeybinding(document, keyStrokeList));
        }
        element.appendChild(element2);
    }

    private static Element createNodeForKeybinding(Document document, KeyStrokeList keyStrokeList) {
        Element element;
        if (!keyStrokeList.isMultiStroke()) {
            KeyStroke keyStroke = keyStrokeList.getKeyStrokes().get(0);
            assert (keyStroke != null) : "KeyStroke cannot be null";
            element = document.createElement("Stroke");
            KeyBindingReaderUtils.addKeyStrokeToElement(element, keyStroke);
        } else {
            element = document.createElement("Sequence");
            for (KeyStroke keyStroke : keyStrokeList.getKeyStrokes()) {
                Element element2 = document.createElement("Stroke");
                KeyBindingReaderUtils.addKeyStrokeToElement(element2, keyStroke);
                element.appendChild(element2);
            }
        }
        return element;
    }

    public static DefaultKeyBindingSet getParentSetFromModifiedDefault(KeyBindingSet keyBindingSet) {
        if (keyBindingSet.isModifiedDefault()) {
            assert (keyBindingSet instanceof CustomKeyBindingSet) : "Only custom keybinding sets can be modified default sets";
        } else {
            throw new IllegalArgumentException("This method should only be called if KeyBindingSet's isModifiedDefault method returns true.");
        }
        DefaultKeyBindingSet defaultKeyBindingSet = ((CustomKeyBindingSet)keyBindingSet).getParent();
        return defaultKeyBindingSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCustomSet(File file) {
        boolean bl;
        if (!file.exists()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bl = CustomKeyBindingSetUtils.isValidCustomSet(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
            return bl2;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return bl;
    }

    public static boolean isValidCustomSet(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        InputStream inputStream2 = CustomKeyBindingSetUtils.class.getResourceAsStream("resources/CustomKeyBindingSetSchema.xsd");
        assert (inputStream2 != null) : "Schema for custom keybinding files could not be found.";
        try {
            return !XMLValidator.validate((InputStream)inputStream, (InputStream)inputStream2).hasErrors();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean startsWithCustomSetElement(InputStream inputStream) {
        try {
            return inputStream != null && XMLUtils.startsWithElement((String)"CustomKeySet", (InputStream)inputStream);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

