/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.InputMapUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.StrokeSequenceListener;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;

public class KeySequenceDispatcher
implements KeyEventDispatcher {
    public static final KeyStroke NUMBER_WILDCARD_STROKE = KeyStroke.getKeyStroke(520, 10);
    public static final String GLOBAL_FRAME_ACTIONS_KEY = "GLOBAL_FRAME_ACTIONS";
    private static KeySequenceDispatcher sInstance;
    private boolean fConsumeTilNextPress;
    private boolean fSequenceInProgress;
    private int fSequenceCount;
    private List<BindingData> fWindowLevelBindings;
    private List<BindingData> fLiveBindings;
    private Component fComponent;
    private List<StrokeSequenceListener> fSequenceListeners;
    private FocusListener fFocusLossListener = new FocusLossListener();
    private StringBuffer fRepeatBuffer = new StringBuffer(10);
    private int fTerminationKeyCode = 27;
    private static final int FIRST_STROKE_MASK = 46;

    private KeySequenceDispatcher() {
    }

    public static synchronized KeySequenceDispatcher getInstance() {
        if (sInstance == null) {
            sInstance = new KeySequenceDispatcher();
        }
        return sInstance;
    }

    public void addSequenceListener(StrokeSequenceListener strokeSequenceListener) {
        if (this.fSequenceListeners == null) {
            this.fSequenceListeners = new ArrayList<StrokeSequenceListener>(2);
        } else if (this.fSequenceListeners.contains(strokeSequenceListener)) {
            return;
        }
        this.fSequenceListeners.add(strokeSequenceListener);
    }

    public void removeSequenceListener(StrokeSequenceListener strokeSequenceListener) {
        if (this.fSequenceListeners != null) {
            this.fSequenceListeners.remove(strokeSequenceListener);
        }
    }

    public void setTerminationKeyCode(int n) {
        this.fTerminationKeyCode = n;
    }

    public int getTerminationKeyCode() {
        return this.fTerminationKeyCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        ListIterator<BindingData> listIterator;
        KeyStroke keyStroke;
        boolean bl;
        block28: {
            Object object;
            Serializable serializable;
            Component component;
            block26: {
                block27: {
                    block25: {
                        if (this.fConsumeTilNextPress) {
                            if (keyEvent.getID() != 401) return true;
                            this.fConsumeTilNextPress = false;
                        }
                        if (keyEvent.getID() != 401) return false;
                        if (this.fSequenceInProgress) break block25;
                        component = keyEvent.getComponent();
                        if (component != this.fComponent) {
                            this.fWindowLevelBindings = null;
                            this.fComponent = component;
                            this.fComponent.addFocusListener(this.fFocusLossListener);
                        }
                        int n = keyEvent.getKeyCode();
                        int n2 = keyEvent.getModifiers();
                        if ((n2 & 0x2E) == 0) {
                            if (n < 112) return false;
                            if (n > 123) {
                                return false;
                            }
                        }
                        if (MJUtilities.isModifierOnly(n)) {
                            return false;
                        }
                        if (this.fWindowLevelBindings == null) {
                            this.fWindowLevelBindings = new ArrayList<BindingData>();
                            serializable = SwingUtilities.windowForComponent(component);
                            KeySequenceDispatcher.getWindowBindings((Window)serializable, this.fWindowLevelBindings);
                            KeySequenceDispatcher.getGlobalBindings(component, this.fWindowLevelBindings);
                        }
                        serializable = KeyStroke.getKeyStroke(n, n2);
                        if (this.fLiveBindings == null) {
                            this.fLiveBindings = new LinkedList<BindingData>();
                        }
                        if (!(component instanceof JComponent)) break block26;
                        object = (JComponent)component;
                        InputMap inputMap = ((JComponent)object).getInputMap(0);
                        if (!(inputMap instanceof ExtendedInputMap)) break block27;
                        KeySequenceDispatcher.getBindingsFromInputMap((ExtendedInputMap)((Object)inputMap), (JComponent)object, (KeyStroke)serializable, this.fLiveBindings);
                        break block27;
                    }
                    this.fConsumeTilNextPress = true;
                    int n = keyEvent.getKeyCode();
                    if (n == this.fTerminationKeyCode) {
                        this.endStrokeSequence();
                        return true;
                    }
                    if (MJUtilities.isModifierOnly(n)) return true;
                    boolean bl2 = bl = n >= 48 && n <= 57;
                    if (bl) {
                        if (this.fRepeatBuffer.length() == this.fRepeatBuffer.capacity()) {
                            this.endStrokeSequence();
                        } else {
                            this.fRepeatBuffer.append(KeyEvent.getKeyText(n));
                        }
                    }
                    keyStroke = KeyStroke.getKeyStroke(n, keyEvent.getModifiers());
                    listIterator = this.fLiveBindings.listIterator();
                    break block28;
                }
                while (object != null) {
                    Container container;
                    InputMap inputMap = ((JComponent)object).getInputMap(1);
                    if (inputMap instanceof ExtendedInputMap) {
                        KeySequenceDispatcher.getBindingsFromInputMap((ExtendedInputMap)((Object)inputMap), object, (KeyStroke)serializable, this.fLiveBindings);
                    }
                    object = (container = ((Component)object).getParent()) instanceof JComponent ? (JComponent)container : null;
                }
            }
            for (BindingData bindingData : this.fWindowLevelBindings) {
                if (bindingData.fStrokes.length <= 1 || !((AWTKeyStroke)serializable).equals(bindingData.fStrokes[0]) || !bindingData.fAction.isEnabled()) continue;
                bindingData.fRepeatInProgress = false;
                this.fLiveBindings.add(bindingData);
            }
            if (this.fLiveBindings.isEmpty()) {
                BindingData bindingData;
                if (InputMapUtils.hasEnabledBinding(component, (KeyStroke)serializable, 0)) return false;
                object = this.fWindowLevelBindings.iterator();
                do {
                    if (!object.hasNext()) return false;
                    bindingData = object.next();
                } while (bindingData.fStrokes.length != 1 || !((AWTKeyStroke)serializable).equals(bindingData.fStrokes[0]) || !bindingData.isActionEnabled());
                this.fConsumeTilNextPress = true;
                KeySequenceDispatcher.fireAction(keyEvent.getSource(), bindingData, 0);
                return true;
            }
            this.fSequenceInProgress = true;
            this.fConsumeTilNextPress = true;
            this.fSequenceCount = 1;
            if (this.fSequenceListeners == null) return true;
            int n = 0;
            int n3 = this.fSequenceListeners.size();
            while (n < n3) {
                this.fSequenceListeners.get(n).strokeAddedToSequence((KeyStroke)serializable, 1);
                ++n;
            }
            return true;
        }
        while (listIterator.hasNext()) {
            BindingData bindingData = listIterator.next();
            if (bindingData.fRepeatInProgress) {
                if (bl) continue;
                int n = this.fSequenceCount - this.fRepeatBuffer.length() + 1;
                if (bindingData.fStrokes[n].equals(keyStroke) && bindingData.isActionEnabled()) {
                    int n4 = this.getRepeats();
                    this.endStrokeSequence();
                    KeySequenceDispatcher.fireAction(keyEvent.getSource(), bindingData, n4);
                    break;
                }
                listIterator.remove();
                continue;
            }
            if (bindingData.fStrokes[this.fSequenceCount].equals(keyStroke)) {
                if (bindingData.fStrokes.length != this.fSequenceCount + 1) continue;
                if (bindingData.isActionEnabled()) {
                    int n = this.getRepeats();
                    this.endStrokeSequence();
                    KeySequenceDispatcher.fireAction(keyEvent.getSource(), bindingData, n);
                    break;
                }
                listIterator.remove();
                continue;
            }
            if (bindingData.fStrokes[this.fSequenceCount] == NUMBER_WILDCARD_STROKE && bl) {
                bindingData.fRepeatInProgress = true;
                continue;
            }
            listIterator.remove();
        }
        if (!this.fSequenceInProgress) return true;
        if (this.fLiveBindings.isEmpty()) {
            this.endStrokeSequence();
            MJUtilities.beep();
            return true;
        }
        ++this.fSequenceCount;
        if (this.fSequenceListeners == null) return true;
        int n = 0;
        int n5 = this.fSequenceListeners.size();
        while (n < n5) {
            this.fSequenceListeners.get(n).strokeAddedToSequence(keyStroke, this.fSequenceCount);
            ++n;
        }
        return true;
    }

    private static void getGlobalBindings(Component component, List<BindingData> list) {
        JRootPane jRootPane = SwingUtilities.getRootPane(component);
        if (jRootPane == null) {
            return;
        }
        Object object = jRootPane.getClientProperty(GLOBAL_FRAME_ACTIONS_KEY);
        if (object instanceof List) {
            List list2 = (List)object;
            for (Action action : list2) {
                KeyStroke[] keyStrokeArray;
                if (!(action instanceof ExtendedAction)) continue;
                KeyStroke keyStroke = ((ExtendedAction)action).getAccelerator();
                if (keyStroke != null) {
                    keyStrokeArray = new KeyStroke[]{keyStroke};
                    list.add(new BindingData(keyStrokeArray, action));
                }
                if ((keyStrokeArray = ((ExtendedAction)action).getAccelerators()) != null) {
                    for (KeyStrokeList keyStrokeList : keyStrokeArray) {
                        list.add(new BindingData(keyStrokeList.toKeyStrokeArray(), action));
                    }
                }
                KeySequenceDispatcher.handleMultiStrokeSequence((ExtendedAction)action, list);
            }
        }
    }

    private static void getWindowBindings(Window window, List<BindingData> list) {
        JMenuBar jMenuBar = null;
        if (window instanceof JFrame) {
            jMenuBar = ((JFrame)window).getJMenuBar();
        } else if (window instanceof JDialog) {
            jMenuBar = ((JDialog)window).getJMenuBar();
        }
        if (jMenuBar != null) {
            KeySequenceDispatcher.getBindingsFromMenu(jMenuBar, list);
        }
    }

    private static void getBindingsFromMenu(MenuElement menuElement, List<BindingData> list) {
        if (menuElement instanceof JMenuItem && !(menuElement instanceof JMenu)) {
            Action action = ((JMenuItem)menuElement).getAction();
            if (action instanceof ExtendedAction) {
                List<KeyStrokeList> list2 = ((ExtendedAction)action).getAccelerators();
                if (list2 != null) {
                    boolean bl = true;
                    for (KeyStrokeList keyStrokeList : list2) {
                        if (!bl || keyStrokeList.isMultiStroke()) {
                            list.add(new BindingData(keyStrokeList.toKeyStrokeArray(), action));
                        }
                        bl = false;
                    }
                }
                KeySequenceDispatcher.handleMultiStrokeSequence((ExtendedAction)action, list);
            }
        } else {
            MenuElement[] menuElementArray = menuElement.getSubElements();
            if (menuElementArray != null) {
                for (MenuElement menuElement2 : menuElementArray) {
                    KeySequenceDispatcher.getBindingsFromMenu(menuElement2, list);
                }
            }
        }
    }

    private static void handleMultiStrokeSequence(ExtendedAction extendedAction, List<BindingData> list) {
        List<KeyStrokeList> list2 = extendedAction.getAccelerators();
        KeyStroke[] keyStrokeArray = extendedAction.getAcceleratorSequence();
        if (!(keyStrokeArray == null || list2 != null && list2.contains(new KeyStrokeList(keyStrokeArray)))) {
            list.add(new BindingData(keyStrokeArray, extendedAction));
        }
    }

    private static void getBindingsFromInputMap(ExtendedInputMap extendedInputMap, JComponent jComponent, KeyStroke keyStroke, List<BindingData> list) {
        List<KeyStroke[]> list2 = extendedInputMap.getSequencesStartingWith(keyStroke);
        if (!list2.isEmpty()) {
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                KeyStroke[] keyStrokeArray = list2.get(i);
                Object object = extendedInputMap.get(keyStrokeArray);
                if (object == null) continue;
                BindingData bindingData = new BindingData(keyStrokeArray, object, jComponent);
                list.add(bindingData);
            }
        }
    }

    private void endStrokeSequence() {
        this.fSequenceInProgress = false;
        this.fSequenceCount = 0;
        this.fLiveBindings.clear();
        if (this.fRepeatBuffer.length() > 0) {
            this.fRepeatBuffer.delete(0, this.fRepeatBuffer.length());
        }
        if (this.fSequenceListeners != null) {
            int n = this.fSequenceListeners.size();
            for (int i = 0; i < n; ++i) {
                this.fSequenceListeners.get(i).strokeSequenceEnded();
            }
        }
    }

    private int getRepeats() {
        if (this.fRepeatBuffer.length() > 0) {
            return Integer.parseInt(this.fRepeatBuffer.toString());
        }
        return 0;
    }

    private static void fireAction(Object object, BindingData bindingData, int n) {
        String string;
        Action action = bindingData.getAction();
        String string2 = string = bindingData.fActionKey != null ? bindingData.fActionKey.toString() : null;
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(object, n, string));
        }
    }

    private class FocusLossListener
    extends FocusAdapter {
        private FocusLossListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (KeySequenceDispatcher.this.fSequenceInProgress) {
                KeySequenceDispatcher.this.endStrokeSequence();
            }
            if (KeySequenceDispatcher.this.fComponent != null) {
                KeySequenceDispatcher.this.fComponent.removeFocusListener(this);
            }
            KeySequenceDispatcher.this.fWindowLevelBindings = null;
            KeySequenceDispatcher.this.fComponent = null;
        }
    }

    private static class BindingData {
        KeyStroke[] fStrokes;
        Action fAction;
        Object fActionKey;
        JComponent fOwner;
        boolean fRepeatInProgress;

        BindingData(KeyStroke[] keyStrokeArray, Action action) {
            this.fStrokes = keyStrokeArray;
            this.fAction = action;
        }

        BindingData(KeyStroke[] keyStrokeArray, Object object, JComponent jComponent) {
            this.fStrokes = keyStrokeArray;
            this.fActionKey = object;
            this.fOwner = jComponent;
        }

        boolean isActionEnabled() {
            Action action = this.getAction();
            return action != null && action.isEnabled();
        }

        Action getAction() {
            ActionMap actionMap;
            if (this.fAction == null && (actionMap = this.fOwner.getActionMap()) != null) {
                this.fAction = actionMap.get(this.fActionKey);
            }
            return this.fAction;
        }
    }
}

