/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.util.PlatformInfo;
import java.util.Arrays;
import java.util.List;
import javax.swing.KeyStroke;

public class MetaBindingUtils {
    private MetaBindingUtils() {
    }

    static boolean hasAltOrMeta(KeyStrokeList keyStrokeList) {
        return MetaBindingUtils.hasAlt(keyStrokeList) || MetaBindingUtils.hasMeta(keyStrokeList);
    }

    private static boolean hasAlt(KeyStrokeList keyStrokeList) {
        return MetaBindingUtils.hasModifier(keyStrokeList, 8);
    }

    public static boolean hasMeta(KeyStrokeList keyStrokeList) {
        return MetaBindingUtils.hasModifier(keyStrokeList, 4);
    }

    private static boolean hasModifier(KeyStrokeList keyStrokeList, int n) {
        for (KeyStroke keyStroke : keyStrokeList.getKeyStrokes()) {
            if (PlatformInfo.isMacintosh() && n == KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK || (keyStroke.getModifiers() & n) == 0) continue;
            return true;
        }
        return false;
    }

    static List<KeyStrokeList> getAllVersions(KeyStrokeList keyStrokeList) {
        assert (MetaBindingUtils.hasAltOrMeta(keyStrokeList)) : "This method should only be called if the binding contains alt or meta modifiers";
        return PlatformInfo.isMacintosh() ? Arrays.asList(keyStrokeList) : Arrays.asList(MetaBindingUtils.getVersionWithAlt(keyStrokeList), MetaBindingUtils.getVersionWithMeta(keyStrokeList));
    }

    private static KeyStrokeList getVersionWithAlt(KeyStrokeList keyStrokeList) {
        assert (!PlatformInfo.isMacintosh()) : "This method should not be called on the Mac.";
        return MetaBindingUtils.hasMeta(keyStrokeList) ? MetaBindingUtils.transformBinding(keyStrokeList, 4, 8) : keyStrokeList;
    }

    private static KeyStrokeList getVersionWithMeta(KeyStrokeList keyStrokeList) {
        assert (!PlatformInfo.isMacintosh()) : "This method should not be called on the Mac.";
        return MetaBindingUtils.hasAlt(keyStrokeList) ? MetaBindingUtils.transformBinding(keyStrokeList, 8, 4) : keyStrokeList;
    }

    private static KeyStrokeList transformBinding(KeyStrokeList keyStrokeList, int n, int n2) {
        KeyStroke[] keyStrokeArray = new KeyStroke[keyStrokeList.getKeyStrokes().size()];
        for (int i = 0; i != keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeList.getKeyStrokes().get(i);
            keyStrokeArray[i] = (keyStroke.getModifiers() & n) != 0 ? KeyStrokeUtils.createKeyStroke(keyStroke.getKeyCode(), MetaBindingUtils.shouldModifierBeUsed(keyStroke, 8, n, n2), MetaBindingUtils.shouldModifierBeUsed(keyStroke, 32, n, n2), MetaBindingUtils.shouldModifierBeUsed(keyStroke, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK, n, n2), MetaBindingUtils.shouldModifierBeUsed(keyStroke, 2, n, n2), MetaBindingUtils.shouldModifierBeUsed(keyStroke, 4, n, n2), MetaBindingUtils.shouldModifierBeUsed(keyStroke, 1, n, n2)) : keyStroke;
        }
        return new KeyStrokeList(keyStrokeArray);
    }

    private static boolean shouldModifierBeUsed(KeyStroke keyStroke, int n, int n2, int n3) {
        return n == n3 || n != n2 && (keyStroke.getModifiers() & n) != 0;
    }
}

