/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.checkboxlist;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.checkboxlist.CheckBoxListCellRenderer;
import com.mathworks.mwswing.checkboxlist.DefaultListCheckModel;
import com.mathworks.mwswing.checkboxlist.ListCheckEvent;
import com.mathworks.mwswing.checkboxlist.ListCheckListener;
import com.mathworks.mwswing.checkboxlist.ListCheckModel;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.MouseInputAdapter;

public class CheckBoxList
extends MJList {
    private ListCheckModel fCheckModel;
    private ListCheckListener fCheckListener;

    public CheckBoxList() {
        this.init();
    }

    public CheckBoxList(List list) {
        super(list.toArray());
        this.init();
    }

    public CheckBoxList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    private void init() {
        this.setCheckModel(this.createCheckModel());
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.setSelectionMode(0);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addKeyListener(new KeyHandler());
    }

    protected ListCheckModel createCheckModel() {
        return new DefaultListCheckModel(this.getModel().getSize());
    }

    public ListCheckModel getCheckModel() {
        return this.fCheckModel;
    }

    public void setCheckModel(ListCheckModel listCheckModel) {
        if (this.fCheckListener == null) {
            this.fCheckListener = new ListCheckListener(){

                @Override
                public void valueChanged(ListCheckEvent listCheckEvent) {
                    int n = listCheckEvent.getIndex();
                    if (n == -1) {
                        CheckBoxList.this.repaint();
                    } else {
                        CheckBoxList.this.repaint(CheckBoxList.this.getCellBounds(n, n));
                    }
                }
            };
        }
        if (this.fCheckModel != null) {
            this.fCheckModel.removeListCheckListener(this.fCheckListener);
            if (this.fCheckModel instanceof DefaultListCheckModel) {
                ((DefaultListCheckModel)this.fCheckModel).setOwner(null);
            }
        }
        this.fCheckModel = listCheckModel;
        if (listCheckModel != null) {
            this.fCheckModel.addListCheckListener(this.fCheckListener);
            if (listCheckModel instanceof DefaultListCheckModel) {
                ((DefaultListCheckModel)listCheckModel).setOwner(this);
            }
        }
    }

    public void checkAll() {
        this.fCheckModel.checkAll();
    }

    public void checkIndex(int n) {
        this.fCheckModel.checkIndex(n);
    }

    public void checkValue(Object object) {
        int n = this.indexOfValue(object);
        if (n != -1) {
            this.checkIndex(n);
        }
    }

    public void uncheckAll() {
        this.fCheckModel.uncheckAll();
    }

    public void uncheckIndex(int n) {
        this.fCheckModel.uncheckIndex(n);
    }

    public final void uncheckValue(Object object) {
        int n = this.indexOfValue(object);
        if (n != -1) {
            this.uncheckIndex(n);
        }
    }

    public int[] getCheckedIndicies() {
        return this.fCheckModel.getCheckedIndicies();
    }

    public List getCheckedValues() {
        int[] nArray = this.getCheckedIndicies();
        ArrayList arrayList = new ArrayList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getModel().getElementAt(nArray[i]));
        }
        return arrayList;
    }

    public int[] getIndiciesInCheckedOrder() {
        if (this.fCheckModel instanceof DefaultListCheckModel) {
            return ((DefaultListCheckModel)this.fCheckModel).getIndiciesInCheckedOrder();
        }
        throw new UnsupportedOperationException("Requires a DefaultListCheckModel");
    }

    public List getValuesInCheckedOrder() {
        int[] nArray = this.getIndiciesInCheckedOrder();
        ArrayList arrayList = new ArrayList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getModel().getElementAt(nArray[i]));
        }
        return arrayList;
    }

    public boolean isIndexChecked(int n) {
        return this.fCheckModel.isIndexChecked(n);
    }

    public boolean isValueChecked(Object object) {
        int n = this.indexOfValue(object);
        if (n != -1) {
            return this.isIndexChecked(n);
        }
        return false;
    }

    public Action getCheckAllAction() {
        return new CheckAllAction();
    }

    public Action getUncheckAllAction() {
        return new UncheckAllAction();
    }

    private int indexOfValue(Object object) {
        ListModel listModel = this.getModel();
        if (listModel instanceof DefaultListModel) {
            return ((DefaultListModel)listModel).indexOf(object);
        }
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (listModel.getElementAt(i) != object) continue;
            return i;
        }
        return -1;
    }

    private class UncheckAllAction
    extends MJAbstractAction {
        UncheckAllAction() {
            super(MJUtilities.intlString("action.SelectNone"));
            this.setComponentName("SelectNone");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CheckBoxList.this.uncheckAll();
        }
    }

    private class CheckAllAction
    extends MJAbstractAction {
        CheckAllAction() {
            super(MJUtilities.intlString("action.SelectAll"));
            this.setComponentName("SelectAll");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CheckBoxList.this.checkAll();
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            if (keyEvent.getKeyCode() == 32 && (n = CheckBoxList.this.getSelectedIndex()) != -1) {
                if (CheckBoxList.this.fCheckModel.isIndexChecked(n)) {
                    CheckBoxList.this.fCheckModel.uncheckIndex(n);
                } else {
                    CheckBoxList.this.fCheckModel.checkIndex(n);
                }
            }
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        int iPressedIndex = -1;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = CheckBoxList.this.locationToIndex(mouseEvent.getPoint());
            if (n != -1) {
                this.iPressedIndex = n;
                if (mouseEvent.getButton() == 1) {
                    if (CheckBoxList.this.isIndexChecked(n)) {
                        CheckBoxList.this.uncheckIndex(n);
                    } else {
                        CheckBoxList.this.checkIndex(n);
                    }
                    if (mouseEvent.isShiftDown() && CheckBoxList.this.isIndexChecked(n)) {
                        int n2 = n;
                        --n2;
                        while (n2 >= 0 && !CheckBoxList.this.isIndexChecked(n2)) {
                            --n2;
                        }
                        if (n2 >= 0) {
                            ++n2;
                            while (n2 < n) {
                                CheckBoxList.this.checkIndex(n2);
                                ++n2;
                            }
                        }
                        int n3 = n;
                        int n4 = CheckBoxList.this.getModel().getSize();
                        ++n3;
                        while (n3 < n4 && !CheckBoxList.this.isIndexChecked(n3)) {
                            ++n3;
                        }
                        if (n3 < n4) {
                            --n3;
                            while (n3 > n) {
                                CheckBoxList.this.checkIndex(n3);
                                --n3;
                            }
                        }
                    }
                } else {
                    CheckBoxList.this.uncheckIndex(n);
                }
                CheckBoxList.this.repaint(CheckBoxList.this.getCellBounds(n, n));
            }
            mouseEvent.consume();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.iPressedIndex = -1;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = CheckBoxList.this.locationToIndex(mouseEvent.getPoint());
            if (n != -1 && n != this.iPressedIndex) {
                this.iPressedIndex = -1;
                if ((mouseEvent.getModifiersEx() & 0x400) != 0) {
                    if (!CheckBoxList.this.isIndexChecked(n)) {
                        CheckBoxList.this.checkIndex(n);
                    }
                } else {
                    CheckBoxList.this.uncheckIndex(n);
                }
                CheckBoxList.this.repaint(CheckBoxList.this.getCellBounds(n, n));
            }
            mouseEvent.consume();
        }
    }
}

