/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class HorizontalLinePainter
extends LayeredHighlighter.LayerPainter {
    private Color fColor;
    private float fPos;

    public HorizontalLinePainter(float f) {
        this(f, null);
    }

    public HorizontalLinePainter(float f, Color color) {
        this.fPos = f < 0.0f ? 0.0f : f;
        this.fColor = color;
    }

    @Override
    public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
    }

    @Override
    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        Object object;
        Rectangle rectangle = null;
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        } else {
            try {
                object = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                rectangle = object instanceof Rectangle ? (Rectangle)object : object.getBounds();
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        object = view.getElement();
        AttributeSet attributeSet = object.getAttributes();
        Color color = null;
        if (this.fColor != null) {
            color = this.fColor;
        } else {
            color = StyleConstants.getForeground(attributeSet);
            if (color == null) {
                color = jTextComponent.getForeground();
            }
        }
        int n3 = rectangle.y + Math.min((int)(this.fPos * (float)rectangle.height), rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, n3, rectangle.x + rectangle.width - 1, n3);
        return rectangle;
    }
}

