/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import [Lcom.sun.jini.start.ServiceDescriptor;;
import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.config.Config;
import com.sun.jini.start.ServiceDescriptor;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationSystem;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class ServiceStarter {
    static final String START_PACKAGE = "com.sun.jini.start";
    static Logger logger = null;
    private static ArrayList transient_service_refs;
    static /* synthetic */ Class class$com$sun$jini$start$NonActivatableServiceDescriptor;

    private ServiceStarter() {
    }

    /*
     * Loose catch block
     */
    private static Result[] createWithLogin(final ServiceDescriptor[] serviceDescriptorArray, final Configuration configuration, LoginContext loginContext) throws Exception {
        Result[] resultArray;
        block7: {
            logger.entering(ServiceStarter.class.getName(), "createWithLogin", new Object[]{serviceDescriptorArray, configuration, loginContext});
            loginContext.login();
            resultArray = null;
            resultArray = (Result[])Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ServiceStarter.create(serviceDescriptorArray, configuration);
                }
            }, null);
            Object var6_4 = null;
            try {
                loginContext.logout();
            }
            catch (LoginException loginException) {
                logger.log(Level.FINE, "service.logout.exception", loginException);
            }
            break block7;
            {
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    loginContext.logout();
                }
                catch (LoginException loginException) {
                    logger.log(Level.FINE, "service.logout.exception", loginException);
                }
                throw throwable;
            }
        }
        logger.exiting(ServiceStarter.class.getName(), "createWithLogin", resultArray);
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Result[] create(ServiceDescriptor[] serviceDescriptorArray, Configuration configuration) throws Exception {
        logger.entering(ServiceStarter.class.getName(), "create", new Object[]{serviceDescriptorArray, configuration});
        ArrayList<Result> arrayList = new ArrayList<Result>();
        Object object = null;
        Exception exception = null;
        ServiceDescriptor serviceDescriptor = null;
        for (int i = 0; i < serviceDescriptorArray.length; ++i) {
            Object var9_8;
            serviceDescriptor = serviceDescriptorArray[i];
            object = null;
            exception = null;
            try {
                block5: {
                    try {
                        if (serviceDescriptor == null) break block5;
                        object = serviceDescriptor.create(configuration);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        var9_8 = null;
                        arrayList.add(new Result(serviceDescriptor, object, exception));
                        continue;
                    }
                }
                var9_8 = null;
                arrayList.add(new Result(serviceDescriptor, object, exception));
                continue;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                arrayList.add(new Result(serviceDescriptor, object, exception));
                throw throwable;
            }
        }
        logger.exiting(ServiceStarter.class.getName(), "create", arrayList);
        return arrayList.toArray(new Result[arrayList.size()]);
    }

    static synchronized void ensureSecurityManager() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
    }

    static ActivationSystem getActivationSystem(String string, int n, Configuration configuration) throws ActivationException, ConfigurationException {
        if (configuration == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        ActivationSystem activationSystem = null;
        String string2 = string == null ? "" : string;
        int n2 = n <= 0 ? ServiceStarter.getActivationSystemPort() : n;
        try {
            activationSystem = (ActivationSystem)Naming.lookup("//" + string2 + ":" + n2 + "/java.rmi.activation.ActivationSystem");
            ProxyPreparer proxyPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, START_PACKAGE, "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            activationSystem = (ActivationSystem)proxyPreparer.prepareProxy(activationSystem);
        }
        catch (Exception exception) {
            throw new ActivationException("ActivationSystem @ " + string + ":" + n + " could not be obtained", (Throwable)exception);
        }
        return activationSystem;
    }

    static int getActivationSystemPort() {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction("java.rmi.activation.port", 1098));
    }

    private static void maintainNonActivatableReferences(Result[] resultArray) {
        logger.entering(ServiceStarter.class.getName(), "maintainNonActivatableReferences", resultArray);
        if (resultArray.length == 0) {
            return;
        }
        transient_service_refs = new ArrayList();
        for (int i = 0; i < resultArray.length; ++i) {
            if (resultArray[i] == null || resultArray[i].result == null || !(class$com$sun$jini$start$NonActivatableServiceDescriptor == null ? ServiceStarter.class$("com.sun.jini.start.NonActivatableServiceDescriptor") : class$com$sun$jini$start$NonActivatableServiceDescriptor).equals(resultArray[i].descriptor.getClass())) continue;
            logger.log(Level.FINEST, "Storing ref to: {0}", resultArray[i].result);
            transient_service_refs.add(resultArray[i].result);
        }
        logger.exiting(ServiceStarter.class.getName(), "maintainNonActivatableReferences");
    }

    private static void checkResultFailures(Result[] resultArray) {
        logger.entering(ServiceStarter.class.getName(), "checkResultFailures", resultArray);
        if (resultArray.length == 0) {
            return;
        }
        for (int i = 0; i < resultArray.length; ++i) {
            if (resultArray[i].exception != null) {
                logger.log(Level.WARNING, "service.creation.unknown", resultArray[i].exception);
                logger.log(Level.WARNING, "service.creation.unknown.detail", new Object[]{new Integer(i), resultArray[i].descriptor});
                continue;
            }
            if (resultArray[i].descriptor != null) continue;
            logger.log(Level.WARNING, "service.creation.null", new Integer(i));
        }
        logger.exiting(ServiceStarter.class.getName(), "checkResultFailures");
    }

    public static void main(String[] stringArray) {
        ServiceStarter.ensureSecurityManager();
        try {
            logger.entering(ServiceStarter.class.getName(), "main", stringArray);
            Configuration configuration = ConfigurationProvider.getInstance(stringArray);
            ServiceDescriptor[] serviceDescriptorArray = (ServiceDescriptor[])configuration.getEntry(START_PACKAGE, "serviceDescriptors", ServiceDescriptor;.class, null);
            if (serviceDescriptorArray == null || serviceDescriptorArray.length == 0) {
                logger.warning("service.config.empty");
                return;
            }
            LoginContext loginContext = (LoginContext)configuration.getEntry(START_PACKAGE, "loginContext", LoginContext.class, null);
            Result[] resultArray = null;
            resultArray = loginContext != null ? ServiceStarter.createWithLogin(serviceDescriptorArray, configuration, loginContext) : ServiceStarter.create(serviceDescriptorArray, configuration);
            ServiceStarter.checkResultFailures(resultArray);
            ServiceStarter.maintainNonActivatableReferences(resultArray);
        }
        catch (ConfigurationException configurationException) {
            logger.log(Level.SEVERE, "service.config.exception", configurationException);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "service.creation.exception", exception);
        }
        logger.exiting(ServiceStarter.class.getName(), "main");
    }

    static {
        try {
            logger = Logger.getLogger("com.sun.jini.start.service.starter", "com.sun.jini.start.resources.service");
        }
        catch (Exception exception) {
            logger = Logger.getLogger("com.sun.jini.start.service.starter");
            if (exception instanceof MissingResourceException) {
                logger.info("Could not load logger's ResourceBundle: " + exception);
            } else if (exception instanceof IllegalArgumentException) {
                logger.info("Logger exists and uses another resource bundle: " + exception);
            }
            logger.info("Defaulting to existing logger");
        }
    }

    private static class Result {
        public final Object result;
        public final Exception exception;
        public final ServiceDescriptor descriptor;

        Result(ServiceDescriptor serviceDescriptor, Object object, Exception exception) {
            this.descriptor = serviceDescriptor;
            this.result = object;
            this.exception = exception;
        }

        public String toString() {
            return this.getClass() + ":[descriptor=" + this.descriptor + ", " + "result=" + this.result + ", exception=" + this.exception + "]";
        }
    }
}

