/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.BasicFontPicker;
import com.mathworks.beans.editors.FontPicker;
import com.mathworks.mwswing.MJComponent;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

class EnhancedFontPicker
extends MJPanel {
    private FontPicker fOwner;
    private BasicFontPicker fBasicPicker;
    private MJPanel fGroup;
    private FontSample fSample;

    EnhancedFontPicker(FontPicker fontPicker) {
        this.fOwner = fontPicker;
        this.setLayout(new BorderLayout(0, 4));
        this.fBasicPicker = new BasicFontPicker(fontPicker);
        this.fGroup = new MJPanel();
        this.fGroup.setBorder((Border)BorderFactory.createTitledBorder(FontPicker.sRes.getString("font.SampleLabel")));
        this.fGroup.setName("SampleLabel");
        this.fGroup.setLayout((LayoutManager)new BorderLayout());
        this.fSample = new FontSample();
        this.fSample.setFont(fontPicker.getSelectedFont());
        this.fGroup.add((Component)((Object)this.fSample), (Object)"Center");
        this.add((Component)this.fGroup, "Center");
        this.add((Component)((Object)this.fBasicPicker), "North");
        this.updateControls();
    }

    protected void updateControls() {
        this.fBasicPicker.updateControls();
        this.fSample.setEnabled(this.fOwner.isEnabled());
        this.fGroup.setEnabled(this.fOwner.isEnabled());
        this.fSample.setFont(this.fOwner.getSelectedFont());
        this.fSample.repaint();
    }

    private class FontSample
    extends MJComponent {
        FontSample() {
            this.setPreferredSize(new Dimension(120, 60));
        }

        public void paint(Graphics graphics) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = fontMetrics.getHeight();
            int n4 = fontMetrics.getAscent();
            int n5 = fontMetrics.stringWidth(" ");
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
            graphics.setFont(this.getFont());
            graphics.setColor(this.getForeground());
            int n6 = 0;
            int n7 = n4;
            StringTokenizer stringTokenizer = new StringTokenizer(FontPicker.sRes.getString("font.SampleString"), " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                int n8 = fontMetrics.stringWidth(string);
                if (n6 > 0 && n6 + n8 >= n) {
                    n6 = 0;
                    n7 += n3;
                }
                graphics.drawString(string, n6, n7);
                n6 += n8 + n5;
            }
        }
    }
}

