/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.BasicFontPicker;
import com.mathworks.beans.editors.EnhancedFontPicker;
import com.mathworks.mwswing.MJPanel;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.UIManager;

public class FontPicker
extends MJPanel
implements ItemSelectable {
    protected static final String[] SIZES = new String[]{"9", "10", "12", "14", "18", "24", "36", "48"};
    protected static final String[] STYLES = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    protected static final String[] NAMES = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private Font fSelectedFont;
    private Component fPicker;
    private ItemListener fItemListener;
    protected static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.beans.editors.resources.RES_Editors");

    public FontPicker(Font font, boolean bl) {
        this.setLayout(new BorderLayout());
        this.fSelectedFont = font == null ? UIManager.getFont("Label.font") : font;
        this.fPicker = bl ? new EnhancedFontPicker(this) : new BasicFontPicker(this);
        this.add(this.fPicker, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
    }

    public FontPicker(Font font) {
        this(font, false);
    }

    public FontPicker() {
        this(null, false);
    }

    public Font getSelectedFont() {
        return this.fSelectedFont;
    }

    public void setSelectedFont(Font font) {
        this.fSelectedFont = font;
        this.updateControls();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateControls();
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedFont()};
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.add(this.fItemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemListener = AWTEventMulticaster.remove(this.fItemListener, itemListener);
    }

    private void updateControls() {
        if (this.fPicker instanceof BasicFontPicker) {
            ((BasicFontPicker)((Object)this.fPicker)).updateControls();
        } else if (this.fPicker instanceof EnhancedFontPicker) {
            ((EnhancedFontPicker)((Object)this.fPicker)).updateControls();
        }
    }

    protected void fireItemEvent() {
        if (this.fItemListener != null) {
            ItemEvent itemEvent = new ItemEvent(this, 701, this.getSelectedFont(), 1);
            this.fItemListener.itemStateChanged(itemEvent);
        }
    }
}

