/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.glue;

import com.mathworks.beans.glue.ActionGlue;
import com.mathworks.beans.glue.AdjustmentGlue;
import com.mathworks.beans.glue.DataGlue;
import com.mathworks.beans.glue.ItemGlue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.EventObject;

public abstract class EventGlue
implements Serializable {
    private static final int kVoidType = 1;
    private static final int kIntegerType = 2;
    private static final int kEventType = 3;
    private static final int kBooleanType = 4;
    private static final int kDoubleType = 5;
    protected static final int kActionGlue = 1;
    protected static final int kAdjustmentGlue = 2;
    protected static final int kDataGlue = 3;
    protected static final int kItemGlue = 4;
    private Object fSource;
    private Object fTarget;
    private String fMethodName;
    private int fParameterType;
    private Class fParameterClass;
    private transient Method fMethod;

    protected EventGlue() {
    }

    public EventGlue(Method method) {
        if (method.getReturnType() != Void.TYPE) {
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 0) {
            this.fParameterType = 1;
        } else if (classArray.length == 1) {
            if (classArray[0] == Integer.TYPE) {
                this.fParameterType = 2;
            } else if (classArray[0] == Boolean.TYPE) {
                this.fParameterType = 4;
            } else if (classArray[0] == Double.TYPE) {
                this.fParameterType = 5;
            } else {
                this.fParameterType = 3;
                this.fParameterClass = classArray[0];
            }
        } else {
            return;
        }
        this.fMethodName = method.getName();
    }

    public final void setTarget(Object object) {
        this.fTarget = object;
    }

    public final Object getTarget() {
        return this.fTarget;
    }

    public final void setSource(Object object) {
        this.fSource = object;
    }

    public final Object getSource() {
        return this.fSource;
    }

    public final String getMethodName() {
        return this.fMethodName;
    }

    public final int getParameterType() {
        return this.fParameterType;
    }

    public final Class getParameterClass() {
        return this.fParameterClass;
    }

    private void findMethod() {
        if (this.fMethod == null && this.fMethodName != null) {
            Class<?> clazz = this.fTarget.getClass();
            Class[] classArray = this.fParameterType == 1 ? new Class[]{} : (this.fParameterType == 2 ? new Class[]{Integer.TYPE} : (this.fParameterType == 4 ? new Class[]{Boolean.TYPE} : (this.fParameterType == 5 ? new Class[]{Double.TYPE} : new Class[]{this.fParameterClass})));
            try {
                this.fMethod = clazz.getMethod(this.fMethodName, classArray);
            }
            catch (Exception exception) {
                this.fMethodName = null;
                System.err.println("Can't locate method " + this.fMethodName + " in class " + clazz.getName() + ":");
                System.err.println("    " + exception);
            }
        }
    }

    protected final void invokeMethod(EventObject eventObject) {
        this.findMethod();
        if (this.fMethod != null) {
            try {
                Object[] objectArray = null;
                objectArray = this.fParameterType == 1 ? new Object[]{} : (this.fParameterType == 2 ? new Object[]{this.getInteger(eventObject)} : (this.fParameterType == 4 ? new Object[]{this.getBoolean(eventObject)} : (this.fParameterType == 5 ? new Object[]{this.getDouble(eventObject)} : new Object[]{eventObject})));
                this.fMethod.invoke(this.fTarget, objectArray);
            }
            catch (Exception exception) {
                System.err.println("Can't invoke method " + this.fMethod.getName() + " on object " + this.fTarget + ":");
                System.err.println("    " + exception);
            }
        }
    }

    protected Boolean getBoolean(EventObject eventObject) {
        return new Boolean(this.getInteger(eventObject) != 0);
    }

    protected Double getDouble(EventObject eventObject) {
        return new Double(this.getInteger(eventObject).intValue());
    }

    public final void reconnect() {
        try {
            Class[] classArray = new Class[]{this.getListenerClass()};
            Method method = this.fSource.getClass().getMethod("add" + this.getListenerName(), classArray);
            Object[] objectArray = new Object[]{this};
            method.invoke(this.fSource, objectArray);
        }
        catch (Exception exception) {
            System.err.println("    " + exception);
        }
    }

    public final void disconnect() {
        try {
            Class[] classArray = new Class[]{this.getListenerClass()};
            Method method = this.fSource.getClass().getMethod("remove" + this.getListenerName(), classArray);
            Object[] objectArray = new Object[]{this};
            method.invoke(this.fSource, objectArray);
        }
        catch (Exception exception) {
            System.err.println("    " + exception);
        }
    }

    public abstract int getGlueType();

    protected abstract Integer getInteger(EventObject var1);

    protected abstract String getListenerName();

    protected abstract Class getListenerClass();

    public static EventGlue buildGlue(int n, String string, int n2, Class clazz) {
        EventGlue eventGlue = null;
        switch (n) {
            case 1: {
                eventGlue = new ActionGlue();
                break;
            }
            case 2: {
                eventGlue = new AdjustmentGlue();
                break;
            }
            case 3: {
                eventGlue = new DataGlue();
                break;
            }
            case 4: {
                eventGlue = new ItemGlue();
            }
        }
        if (eventGlue != null) {
            eventGlue.fMethodName = string;
            eventGlue.fParameterType = n2;
            eventGlue.fParameterClass = clazz;
        }
        return eventGlue;
    }
}

