/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Viewport;
import ice.util.Defs;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class DOMEvent
extends DynamicObject
implements Event {
    public static final int CLICK = 1;
    public static final int DBLCLICK = 2;
    public static final int MOUSEDOWN = 3;
    public static final int MOUSEUP = 4;
    public static final int MOUSEOVER = 5;
    public static final int MOUSEMOVE = 6;
    public static final int MOUSEOUT = 7;
    public static final int KEYPRESS = 8;
    public static final int KEYDOWN = 9;
    public static final int KEYUP = 10;
    public static final int RESIZE = 11;
    public static final int SCROLL = 12;
    public static final int LOAD = 13;
    public static final int UNLOAD = 14;
    public static final int ABORT = 15;
    public static final int ERROR = 16;
    public static final int SELECT = 17;
    public static final int CHANGE = 18;
    public static final int SUBMIT = 19;
    public static final int RESET = 20;
    public static final int FOCUS = 21;
    public static final int BLUR = 22;
    public static final int HELP = 23;
    public static final int CONTEXTMENU = 24;
    public static final int DOMSubtreeModified = 25;
    public static final int DOMNodeInserted = 26;
    public static final int DOMNodeRemoved = 27;
    public static final int DOMAttrModified = 28;
    public static final int CSSModified = 29;
    public static final int GOTO = 30;
    public static final int NUM_EVENTS = 31;
    protected DDocument doc;
    int typeId;
    long timestamp;
    DNode target;
    DNode currentNode;
    DNode nodeAfterMap;
    short eventPhase;
    boolean cancel = false;
    private boolean append;
    protected DNode defaultActionTarget;
    int posX;
    int posY;
    DNode relatedNode;
    private EventListener badArg;
    private boolean canBubbleEvent;
    private Object canCancelEvent;

    static int mapEventTypeToId(String string) {
        boolean bl = true;
        int n = 2;
        int n2 = 3;
        int n3 = 4;
        int n4 = 5;
        int n5 = 6;
        int n6 = 7;
        int n7 = 8;
        int n8 = 9;
        int n9 = 10;
        int n10 = 11;
        int n11 = 12;
        int n12 = 13;
        int n13 = 14;
        int n14 = 15;
        int n15 = 16;
        int n16 = 17;
        int n17 = 18;
        int n18 = 19;
        int n19 = 20;
        int n20 = 21;
        int n21 = 22;
        int n22 = 23;
        int n23 = 24;
        int n24 = 25;
        int n25 = 26;
        int n26 = 27;
        int n27 = 28;
        int n28 = 29;
        int n29 = 30;
        int n30 = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 4: {
                char c = string.charAt(0);
                if (c == 'b') {
                    string2 = "blur";
                    n30 = 22;
                    break;
                }
                if (c == 'h') {
                    string2 = "help";
                    n30 = 23;
                    break;
                }
                if (c == 'l') {
                    string2 = "load";
                    n30 = 13;
                    break;
                }
                if (c != 'g') break;
                string2 = "goto";
                n30 = 30;
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "abort";
                        n30 = 15;
                        break block0;
                    }
                    case 'c': {
                        string2 = "click";
                        n30 = 1;
                        break block0;
                    }
                    case 'e': {
                        string2 = "error";
                        n30 = 16;
                        break block0;
                    }
                    case 'f': {
                        string2 = "focus";
                        n30 = 21;
                        break block0;
                    }
                    case 'k': {
                        string2 = "keyup";
                        n30 = 10;
                        break block0;
                    }
                    case 'r': {
                        string2 = "reset";
                        n30 = 20;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(4)) {
                    case 'a': {
                        string2 = "unload";
                        n30 = 14;
                        break block0;
                    }
                    case 'c': {
                        string2 = "select";
                        n30 = 17;
                        break block0;
                    }
                    case 'g': {
                        string2 = "change";
                        n30 = 18;
                        break block0;
                    }
                    case 'i': {
                        string2 = "submit";
                        n30 = 19;
                        break block0;
                    }
                    case 'l': {
                        string2 = "scroll";
                        n30 = 12;
                        break block0;
                    }
                    case 'z': {
                        string2 = "resize";
                        n30 = 11;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'k') {
                    string2 = "keydown";
                    n30 = 9;
                    break;
                }
                if (c != 'm') break;
                string2 = "mouseup";
                n30 = 4;
                break;
            }
            case 8: {
                char c = string.charAt(0);
                if (c == 'd') {
                    string2 = "dblclick";
                    n30 = 2;
                    break;
                }
                if (c == 'k') {
                    string2 = "keypress";
                    n30 = 8;
                    break;
                }
                if (c != 'm') break;
                string2 = "mouseout";
                n30 = 7;
                break;
            }
            case 9: {
                char c = string.charAt(5);
                if (c == 'd') {
                    string2 = "mousedown";
                    n30 = 3;
                    break;
                }
                if (c == 'm') {
                    string2 = "mousemove";
                    n30 = 6;
                    break;
                }
                if (c != 'o') break;
                string2 = "mouseover";
                n30 = 5;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'C') {
                    string2 = "CSSModified";
                    n30 = 29;
                    break;
                }
                if (c != 'c') break;
                string2 = "contextmenu";
                n30 = 24;
                break;
            }
            case 14: {
                string2 = "DOMNodeRemoved";
                n30 = 27;
                break;
            }
            case 15: {
                char c = string.charAt(3);
                if (c == 'A') {
                    string2 = "DOMAttrModified";
                    n30 = 28;
                    break;
                }
                if (c != 'N') break;
                string2 = "DOMNodeInserted";
                n30 = 26;
                break;
            }
            case 18: {
                string2 = "DOMSubtreeModified";
                n30 = 25;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n30 = 0;
        }
        if (n30 == 0) {
            n30 = -1;
        }
        return n30;
    }

    static String mapEventIdToType(int n) {
        switch (n) {
            case 1: {
                return "click";
            }
            case 2: {
                return "dblclick";
            }
            case 3: {
                return "mousedown";
            }
            case 4: {
                return "mouseup";
            }
            case 5: {
                return "mouseover";
            }
            case 6: {
                return "mousemove";
            }
            case 7: {
                return "mouseout";
            }
            case 8: {
                return "keypress";
            }
            case 9: {
                return "keydown";
            }
            case 10: {
                return "keyup";
            }
            case 11: {
                return "resize";
            }
            case 12: {
                return "scroll";
            }
            case 13: {
                return "load";
            }
            case 14: {
                return "unload";
            }
            case 15: {
                return "abort";
            }
            case 16: {
                return "error";
            }
            case 17: {
                return "select";
            }
            case 18: {
                return "change";
            }
            case 19: {
                return "submit";
            }
            case 20: {
                return "reset";
            }
            case 21: {
                return "focus";
            }
            case 22: {
                return "blur";
            }
            case 23: {
                return "help";
            }
            case 24: {
                return "contextmenu";
            }
            case 25: {
                return "DOMSubtreeModified";
            }
            case 26: {
                return "DOMNodeInserted";
            }
            case 27: {
                return "DOMNodeRemoved";
            }
            case 28: {
                return "DOMAttrModified";
            }
            case 29: {
                return "CSSModified";
            }
            case 30: {
                return "goto";
            }
        }
        return null;
    }

    static String internType(String string) {
        return DOMEvent.mapEventIdToType(DOMEvent.mapEventTypeToId(string));
    }

    static boolean canBubbleEvent(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                return true;
            }
            case 18: {
                return true;
            }
            case 19: {
                return true;
            }
            case 20: {
                return true;
            }
            case 21: {
                return false;
            }
            case 22: {
                return false;
            }
            case 23: {
                return false;
            }
            case 24: {
                return false;
            }
            case 30: {
                return false;
            }
        }
        return false;
    }

    static boolean canCancelEvent(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return false;
            }
            case 16: {
                return false;
            }
            case 17: {
                return false;
            }
            case 18: {
                return false;
            }
            case 19: {
                return true;
            }
            case 20: {
                return false;
            }
            case 21: {
                return false;
            }
            case 22: {
                return false;
            }
            case 23: {
                return true;
            }
            case 24: {
                return true;
            }
            case 30: {
                return false;
            }
        }
        return false;
    }

    protected DOMEvent(DDocument dDocument, int n) {
        this.doc = dDocument;
        this.typeId = n;
        this.timestamp = System.currentTimeMillis();
    }

    public final DDocument getDDocument() {
        return this.doc;
    }

    public final Viewport getViewport() {
        return this.doc.pilot.getPilotViewport();
    }

    protected void copyUIDataFrom(DOMEvent dOMEvent) {
        this.target = dOMEvent.target;
        this.currentNode = dOMEvent.currentNode;
        this.nodeAfterMap = dOMEvent.nodeAfterMap;
        this.defaultActionTarget = dOMEvent.defaultActionTarget;
        this.posX = dOMEvent.posX;
        this.posY = dOMEvent.posY;
        this.relatedNode = dOMEvent.relatedNode;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getType() {
        return DOMEvent.mapEventIdToType(this.typeId);
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public EventTarget getCurrentTarget() {
        return this.currentNode;
    }

    public short getEventPhase() {
        return this.eventPhase;
    }

    public boolean getBubbles() {
        return DOMEvent.canBubbleEvent(this.typeId);
    }

    public boolean getCancelable() {
        return DOMEvent.canCancelEvent(this.typeId);
    }

    public void stopPropagation() {
        this.cancel = true;
    }

    public void preventDefault() {
        if (!this.append && this.getCancelable()) {
            this.append = true;
        }
    }

    public void initEvent(String string, boolean bl, boolean bl2) {
    }

    void setTarget(DNode dNode) {
        this.target = dNode;
    }

    void setCurrentNode(Node node) {
        this.currentNode = (DNode)node;
    }

    void setEventPhase(short s) {
        this.eventPhase = s;
    }

    public boolean isDefaultCancelled() {
        return this.append;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String toString() {
        return "[event " + this.getType() + "]";
    }

    private DNode OEAB() {
        DNode dNode = this.target;
        while (dNode != null && !(dNode instanceof DElement)) {
            dNode = dNode.getParentDNode();
        }
        return dNode;
    }

    private DNode append() {
        DNode dNode = this.target;
        if (this.typeId == 7) {
            dNode = this.relatedNode;
        }
        return dNode;
    }

    private DNode badArg() {
        DNode dNode = this.target;
        if (this.typeId == 5) {
            dNode = this.relatedNode;
        }
        return dNode;
    }

    private void canBubbleEvent(boolean bl) {
        this.cancel = bl;
    }

    private boolean canCancelEvent() {
        return this.cancel;
    }

    EventListener getAction() {
        return this.badArg;
    }

    void setAction(EventListener eventListener) {
        if (eventListener == null) {
            Defs.badArg();
        }
        if (this.badArg != null) {
            Defs.badArg();
        }
        this.badArg = eventListener;
    }

    public boolean isDefaultDone() {
        return this.canBubbleEvent;
    }

    public void setDefaultDone() {
        this.canBubbleEvent = true;
    }

    public Object getSystemEvent() {
        return this.canCancelEvent;
    }

    public void setSystemEvent(Object object) {
        if (object == null) {
            Defs.badArg();
        }
        if (this.canCancelEvent != null) {
            Defs.badArg();
        }
        this.canCancelEvent = object;
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = DOMEvent.currentTimeMillis(string);
        if (n < 0) {
            return dynEnv.wrapMethod(this, string);
        }
        if (n > 0) {
            return this.cancel(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = DOMEvent.currentTimeMillis(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.charAt(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    public Object execDynamicMethod(String string, Object[] objectArray, DynEnv dynEnv) {
        int n = DOMEvent.currentTimeMillis(string);
        if (n < 0) {
            return this.currentNode(n, objectArray, dynEnv);
        }
        return super.execDynamicMethod(string, objectArray, dynEnv);
    }

    private Object cancel(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return dynEnv.wrapBoolean(this.getBubbles());
            }
            case 2: {
                return dynEnv.wrapBoolean(this.getCancelable());
            }
            case 3: {
                return dynEnv.wrapBoolean(this.canCancelEvent());
            }
            case 4: {
                return this.getCurrentNode();
            }
            case 5: {
                return this.getCurrentTarget();
            }
            case 6: {
                return dynEnv.wrapInt(this.getEventPhase());
            }
            case 7: {
                return this.badArg();
            }
            case 8: {
                return this.OEAB();
            }
            case 9: {
                return this.getTarget();
            }
            case 10: {
                return dynEnv.wrapLong(this.getTimeStamp());
            }
            case 11: {
                return this.append();
            }
            case 12: {
                return this.getType();
            }
        }
        return null;
    }

    private int charAt(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 3: {
                this.canBubbleEvent(dynEnv.toBoolean(object));
                return 1;
            }
            case 6: {
                this.setEventPhase(dynEnv.toShort(object));
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                this.setTarget((DNode)dynEnv.toNative(object));
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 1;
            }
        }
        return 2;
    }

    private Object currentNode(int n, Object[] objectArray, DynEnv dynEnv) {
        switch (n) {
            case -1: {
                String string = dynEnv.toStr(objectArray, 0);
                boolean bl = dynEnv.toBoolean(objectArray, 1);
                boolean bl2 = dynEnv.toBoolean(objectArray, 2);
                this.initEvent(string, bl, bl2);
                break;
            }
            case -2: {
                return dynEnv.wrapBoolean(this.isDefaultCancelled());
            }
            case -3: {
                this.preventDefault();
                break;
            }
            case -4: {
                this.stopPropagation();
            }
        }
        return dynEnv.wrapVoid();
    }

    private static int currentTimeMillis(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "type";
                n = 12;
                break;
            }
            case 6: {
                string2 = "target";
                n = 9;
                break;
            }
            case 7: {
                string2 = "bubbles";
                n = 1;
                break;
            }
            case 9: {
                char c = string.charAt(1);
                if (c == 'i') {
                    string2 = "timeStamp";
                    n = 10;
                    break;
                }
                if (c == 'n') {
                    string2 = "initEvent";
                    n = -1;
                    break;
                }
                if (c != 'o') break;
                string2 = "toElement";
                n = 11;
                break;
            }
            case 10: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "cancelable";
                    n = 2;
                    break;
                }
                if (c == 'e') {
                    string2 = "eventPhase";
                    n = 6;
                    break;
                }
                if (c != 's') break;
                string2 = "srcElement";
                n = 8;
                break;
            }
            case 11: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "currentNode";
                    n = 4;
                    break;
                }
                if (c != 'f') break;
                string2 = "fromElement";
                n = 7;
                break;
            }
            case 12: {
                string2 = "cancelBubble";
                n = 3;
                break;
            }
            case 13: {
                string2 = "currentTarget";
                n = 5;
                break;
            }
            case 14: {
                string2 = "preventDefault";
                n = -3;
                break;
            }
            case 15: {
                string2 = "stopPropagation";
                n = -4;
                break;
            }
            case 18: {
                string2 = "isDefaultCancelled";
                n = -2;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

