/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.FontProvider;
import ice.pilots.html4.JavaFontProvider;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FontCache {
    private static String OEAB = "Serif";
    private static int TYPE = 10;
    static int minFontSize = 4;
    private Font addElement;
    private float append = 120.0f;
    private boolean charAt;
    private int clear;
    private int elementAt;
    private int endsWith;
    private final int[] equals = new int[]{256, 307, 369, 442, 531, 637, 764, 850};
    private Hashtable equalsIgnoreCase = new Hashtable();
    private int font_family = 5;
    private Font[] font_size = new Font[this.font_family];
    private boolean font_style = Debug.trace && Defs.sysPropertyBoolean((String)"ice.pilots.html4.traceFonts");
    private FontProvider[] forName;

    public FontCache() {
        this.init();
    }

    private void OEAB(FontMetrics fontMetrics) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tfont: ");
        stringBuffer.append(fontMetrics.getFont().toString());
        stringBuffer.append("\n\tascent: ");
        stringBuffer.append(fontMetrics.getAscent());
        stringBuffer.append(", descent: ");
        stringBuffer.append(fontMetrics.getDescent());
        stringBuffer.append(", height: ");
        stringBuffer.append(fontMetrics.getHeight());
        stringBuffer.append(", max-ascent: ");
        stringBuffer.append(fontMetrics.getMaxAscent());
        stringBuffer.append(", max-descent: ");
        stringBuffer.append(fontMetrics.getMaxDescent());
        stringBuffer.append("\n\tmax-advance: ");
        stringBuffer.append(fontMetrics.getMaxAdvance());
        stringBuffer.append(", test-width: ");
        stringBuffer.append(fontMetrics.stringWidth("Hello, world!"));
        if (Debug.trace) {
            Debug.trace((String)stringBuffer.toString());
        }
    }

    void init() {
        FontProvider fontProvider;
        try {
            int n = Toolkit.getDefaultToolkit().getScreenResolution();
            this.append = n;
        }
        catch (Exception exception) {
            this.append = 120.0f;
        }
        String string = Defs.sysProperty((String)"ice.pilots.html4.addonFontProviders", (String)"JavaVM");
        boolean bl = false;
        Vector<JavaFontProvider> vector = new Vector<JavaFontProvider>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if ("JavaVM".equalsIgnoreCase(string)) {
                    fontProvider = new JavaFontProvider();
                    vector.addElement((JavaFontProvider)fontProvider);
                    bl = true;
                    continue;
                }
                try {
                    fontProvider = (FontProvider)Class.forName(string).newInstance();
                    if (Debug.trace) {
                        Debug.trace((String)("FontProvider instance loaded: " + string));
                    }
                    vector.addElement((JavaFontProvider)fontProvider);
                }
                catch (Exception exception) {
                    if (!Debug.trace) continue;
                    Debug.trace((String)("Exception loading FontProvider: " + string + ", ex: " + exception));
                }
            }
        }
        if (!bl) {
            fontProvider = new JavaFontProvider();
            vector.addElement((JavaFontProvider)fontProvider);
        }
        this.forName = new FontProvider[vector.size()];
        int n = 0;
        while (n < this.forName.length) {
            this.forName[n] = (FontProvider)vector.elementAt(n);
            ++n;
        }
    }

    public Font getTestedFont(char[] cArray, int n, int n2, CSSAttribs cSSAttribs) {
        Font font = null;
        FontMetrics fontMetrics = null;
        if (cSSAttribs != null && this.TYPE(font = (fontMetrics = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size)).getFont(), cArray, n, n2)) {
            return font;
        }
        int n3 = 0;
        while (n3 < this.font_size.length) {
            font = this.font_size[n3];
            if (font != null && this.TYPE(font, cArray, n, n2)) {
                cSSAttribs.font_family = font.getFamily();
                font = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size).getFont();
                return font;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.forName.length) {
            String[] stringArray = this.forName[n4].getFontFamilies();
            int n5 = 0;
            while (n5 < stringArray.length) {
                font = this.forName[n4].getFont(stringArray[n5], cSSAttribs.font_style, cSSAttribs.font_size);
                if (font != null && this.TYPE(font, cArray, n, n2)) {
                    fontMetrics = this.forName[n4].getFontMetrics(font);
                    this.elementAt(stringArray[n5], cSSAttribs.font_style, cSSAttribs.font_size, fontMetrics);
                    this.append(font);
                    cSSAttribs.font_family = stringArray[n5];
                    return font;
                }
                ++n5;
            }
            ++n4;
        }
        font = this.addElement;
        if (Debug.trace) {
            // empty if block
        }
        cSSAttribs.font_family = OEAB;
        return font;
    }

    public Font getTestedFont(String string, CSSAttribs cSSAttribs) {
        Font font = null;
        FontMetrics fontMetrics = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size);
        font = fontMetrics.getFont();
        if (this.addElement(font, string)) {
            return font;
        }
        int n = 0;
        while (n < this.font_size.length) {
            font = this.font_size[n];
            if (font != null && this.addElement(font, string)) {
                cSSAttribs.font_family = this.getSupportedFontFamily(font.getFamily());
                font = this.getFontMetrics(cSSAttribs.font_family, cSSAttribs.font_style, cSSAttribs.font_size).getFont();
                return font;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.forName.length) {
            String[] stringArray = this.forName[n2].getFontFamilies();
            int n3 = 0;
            while (n3 < stringArray.length) {
                font = this.forName[n2].getFont(stringArray[n3], cSSAttribs.font_style, cSSAttribs.font_size);
                if (font != null && this.addElement(font, string)) {
                    fontMetrics = this.forName[n2].getFontMetrics(font);
                    this.elementAt(stringArray[n3], cSSAttribs.font_style, cSSAttribs.font_size, fontMetrics);
                    this.append(font);
                    cSSAttribs.font_family = stringArray[n3];
                    return font;
                }
                ++n3;
            }
            ++n2;
        }
        font = this.addElement;
        if (Debug.trace) {
            // empty if block
        }
        cSSAttribs.font_family = OEAB;
        return font;
    }

    private boolean TYPE(Font font, char[] cArray, int n, int n2) {
        try {
            Class<?> clazz = font.getClass();
            Class[] classArray = new Class[]{cArray.getClass(), Integer.TYPE, Integer.TYPE};
            Method method = clazz.getMethod("canDisplayUpTo", classArray);
            Object[] objectArray = new Object[]{cArray, new Integer(n), new Integer(n2)};
            Object object = method.invoke((Object)font, objectArray);
            int n3 = (Integer)object;
            if (n3 == -1) {
                return true;
            }
            if (n3 == n2 - n) {
                return true;
            }
            int n4 = n3;
            while (n4 < n2) {
                if (cArray[n4] > '\u00ff') {
                    return false;
                }
                ++n4;
            }
            return true;
        }
        catch (Throwable throwable) {
            if (Debug.trace && !this.charAt) {
                Debug.p((String)"canDisplay Exception in char[] Introspection test, One warning only, continuing... ");
                this.charAt = true;
            }
            return true;
        }
    }

    private boolean addElement(Font font, String string) {
        try {
            Class<?> clazz = font.getClass();
            Class[] classArray = new Class[]{string.getClass()};
            Method method = clazz.getMethod("canDisplayUpTo", classArray);
            Object[] objectArray = new Object[]{string};
            Object object = method.invoke((Object)font, objectArray);
            int n = (Integer)object;
            if (n == -1) {
                return true;
            }
            if (n == string.length()) {
                return true;
            }
            int n2 = n;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (c > '\u00ff') {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        catch (Throwable throwable) {
            if (Debug.trace && !this.charAt) {
                Debug.p((String)"canDisplay Exception in String introspection test, One warning only, continuing...  ");
                this.charAt = true;
            }
            return true;
        }
    }

    private void append(Font font) {
        String string = font.getFamily();
        int n = 0;
        while (n < this.font_size.length) {
            if (this.font_size[n] != null) {
                if (string.equals(this.font_size[n].getFamily())) {
                    return;
                }
            } else {
                this.font_size[n] = font;
                return;
            }
            ++n;
        }
        ++this.endsWith;
        this.font_size = new Font[this.font_family];
        this.font_size[0] = font;
    }

    float getScreenResolution() {
        return this.append;
    }

    public String getDefaultFontFamily() {
        return OEAB;
    }

    String getSupportedFontFamily(String string) {
        if (string.equals("")) {
            return OEAB;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith("\"") || string2.startsWith("'")) {
                string2 = string2.substring(1, string2.length());
            }
            if (string2.endsWith("\"") || string2.endsWith("'")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!this.charAt(string2 = string2.trim())) continue;
            return string2;
        }
        return OEAB;
    }

    private boolean charAt(String string) {
        int n = 0;
        while (n < this.forName.length) {
            if (this.forName[n].isFamilySupported(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    FontMetrics getFontMetrics(String string, int n, int n2) {
        FontMetrics fontMetrics = null;
        String string2 = this.equals(string, n, n2);
        fontMetrics = (FontMetrics)this.equalsIgnoreCase.get(string2);
        if (fontMetrics == null) {
            ++this.elementAt;
            this.clear(string, n, n2);
            fontMetrics = (FontMetrics)this.equalsIgnoreCase.get(string2);
            ++this.clear;
        } else {
            ++this.elementAt;
        }
        return fontMetrics;
    }

    private Font clear(String string, int n, int n2) {
        Font font = null;
        FontMetrics fontMetrics = null;
        int n3 = 0;
        while (n3 < this.forName.length) {
            if (this.forName[n3].isFamilySupported(string) && (font = this.forName[n3].getFont(string, n, n2)) != null) {
                fontMetrics = this.forName[n3].getFontMetrics(font);
                if (this.font_style) {
                    this.OEAB(fontMetrics);
                }
                this.elementAt(string, n, n2, fontMetrics);
                return font;
            }
            ++n3;
        }
        return this.addElement;
    }

    private void elementAt(String string, int n, int n2, FontMetrics fontMetrics) {
        String string2 = this.equals(string, n, n2);
        this.equalsIgnoreCase.put(string2, fontMetrics);
    }

    public void clear() {
        this.equalsIgnoreCase.clear();
    }

    void setBaseFontFamily(String string) {
        OEAB = new String(string);
        this.endsWith();
    }

    void setBaseFontSize(int n) {
        TYPE = n;
        this.endsWith();
    }

    void setMinFontSize(int n) {
        minFontSize = n;
        this.endsWith();
    }

    private void endsWith() {
        this.addElement = new Font(OEAB, 0, TYPE);
    }

    int getFontSizeAbs(int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n > 7) {
            n = 7;
        }
        n = TYPE * this.equals[n] >> 8;
        if (n2 != 256 && (n = n * n2 >> 8) < minFontSize) {
            n = minFontSize;
        }
        return n;
    }

    int getFontSizeRel(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        if (n < 0) {
            while (n < 0) {
                n2 = n2 * 256 / 307;
                ++n;
            }
        } else if (n > 0) {
            while (n > 0) {
                n2 = n2 * 307 >> 8;
                --n;
            }
        }
        if (n2 < minFontSize) {
            n2 = minFontSize;
        }
        return n2;
    }

    private String equals(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(CharKit.toLowerCase((String)string)).append("_").append(n).append("_").append(n2);
        return stringBuffer.toString();
    }
}

