/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.text;

import ice.pilots.text.ThePrinter;
import ice.pilots.text.VisualComponent;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class ThePilot
extends Pilot {
    private static final Cursor OEAB = new Cursor(3);
    private static final Cursor addElement = new Cursor(0);
    private VisualComponent append = null;
    private Vector close = null;
    private int equals = 256;
    private static Font firePropertyChange;
    public static int DEFAULT_FONT_SIZE;

    public static Font getDefaultFont() {
        Font font = firePropertyChange;
        if (font == null) {
            firePropertyChange = font = new Font("SansSarif", 0, DEFAULT_FONT_SIZE);
        }
        return font;
    }

    public static void setDefaultFont(Font font) {
        firePropertyChange = font;
    }

    public void init(String string) {
        super.init(string);
        String string2 = "ice.pilots.text." + string + ".TextArea";
        try {
            Object obj = Class.forName(string2).newInstance();
            this.append = (VisualComponent)obj;
            this.append.setTheFont(ThePilot.getDefaultFont());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Component createComponent() {
        return (Component)((Object)this.append);
    }

    public Vector getLines() {
        return this.close;
    }

    public void clear(String string) {
        this.append.setTheText("");
    }

    public void parse(ContentLoader contentLoader) throws IOException {
        try {
            this.DEFAULT_FONT_SIZE(OEAB);
            this.close = new Vector();
            this.firePropertyChange("location", null, contentLoader.getLocation());
            this.firePropertyChange("title", null, contentLoader.getLocation());
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(contentLoader.getInputStream()));
            String string = bufferedReader.readLine();
            try {
                while (string != null) {
                    this.close.addElement(string);
                    stringBuffer.append(string);
                    stringBuffer.append('\n');
                    string = bufferedReader.readLine();
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                stringBuffer = null;
                throw new OutOfMemoryError();
            }
            bufferedReader.close();
            this.append.setTheText(stringBuffer.toString());
            Object var7_6 = null;
            this.DEFAULT_FONT_SIZE(addElement);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.DEFAULT_FONT_SIZE(addElement);
            throw throwable;
        }
    }

    public void setZoom(int n) {
        if (n != this.equals) {
            this.equals = n;
            Font font = firePropertyChange;
            if (font != null) {
                int n2 = DEFAULT_FONT_SIZE;
                int n3 = n2 * n >> 8;
                if (n3 < 4) {
                    n3 = 4;
                }
                if (n2 != n3) {
                    this.append.setTheFont(new Font(font.getName(), font.getStyle(), n3));
                }
                firePropertyChange = new Font(font.getName(), font.getStyle(), n3);
            }
        }
    }

    public void setFont(Font font) {
        int n = font.getSize() * this.equals >> 8;
        if (n < 4) {
            n = 4;
        }
        if (!(font = new Font(font.getName(), font.getStyle(), n)).equals(this.append.getTheFont())) {
            this.append.setTheFont(font);
        }
    }

    public StormPrinter createPrinter() {
        ThePrinter thePrinter = new ThePrinter(this);
        return thePrinter;
    }

    private void DEFAULT_FONT_SIZE(Cursor cursor) {
        if (this.append != null) {
            this.append.setTheCursor(cursor);
        }
    }

    static {
        DEFAULT_FONT_SIZE = 12;
    }
}

