/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DocumentProxy;
import ice.storm.DynamicObject;
import ice.storm.LoadSession;
import ice.storm.LoadThread;
import ice.storm.Pilot;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.ViewportGuiParams;
import ice.storm.ViewportVisitor;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.alg.Listeners;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class Viewport {
    private static final String TRUE = new String("view");
    private static final Object Z = new Object();
    private static long add = 0L;
    private static final Method addElement = Viewport.TRUE();
    private StormBase addOnloadBlocker;
    private final Object bug = new Object();
    private String class$;
    private String clearHistoryForViewport;
    protected Viewport parent = null;
    private Viewport clearWindowObj;
    private Viewport contextViewportImpl;
    private Viewport create;
    private Viewport createComponent;
    private final Object currentThread = new Object();
    private LoadSession dispose;
    private LoadThread do_render_content;
    volatile String stateString = "empty";
    protected Container container = null;
    protected Pilot pilot = null;
    private Component equals = null;
    private final HashArray ex = new HashArray();
    private ViewportGuiParams findViewportByHistoryId;
    private Object findViewportByName;
    private int forName = 256;
    private DynamicObject get;
    private String getBaseUrl = null;
    private String getContentLoader;
    private String getDocPane;
    private volatile int getDocumentId = 1;
    private boolean getDocumentObject;
    static Class class$ice$storm$StormBase;
    static Class class$ice$storm$Viewport;

    private static String OEAB(String string) {
        long l;
        Object object = Z;
        synchronized (object) {
            l = add++;
        }
        return '_' + string + '_' + l;
    }

    private static Method TRUE() {
        Class[] classArray = new Class[]{class$ice$storm$StormBase == null ? (class$ice$storm$StormBase = Viewport.class$("ice.storm.StormBase")) : class$ice$storm$StormBase, class$ice$storm$Viewport == null ? (class$ice$storm$Viewport = Viewport.class$("ice.storm.Viewport")) : class$ice$storm$Viewport};
        Method method = Defs.getMethod((String)"ice.scripters.WindowObj", (String)"create", (Class[])classArray);
        if (method == null && Debug.trace) {
            Debug.trace((String)"No scripting support");
        }
        return method;
    }

    public Viewport(StormBase stormBase) {
        this(stormBase, null);
    }

    public Viewport(StormBase stormBase, String string) {
        if (stormBase == null) {
            throw new IllegalArgumentException("StormBase can not be null");
        }
        this.addOnloadBlocker = stormBase;
        this.clearHistoryForViewport = string != null ? string : TRUE;
        this.class$ = Viewport.OEAB(this.clearHistoryForViewport);
    }

    final StormBase getStormBase() {
        return this.addOnloadBlocker;
    }

    public String toString() {
        return "{Viewport id=" + this.class$ + " name=" + this.clearHistoryForViewport + "}";
    }

    public final String getId() {
        return this.class$;
    }

    public final String getName() {
        return this.clearHistoryForViewport;
    }

    public final boolean isSyntheticName() {
        if (this.clearHistoryForViewport == TRUE) {
            return true;
        }
        return this.clearHistoryForViewport == this.addOnloadBlocker.initialViewportName;
    }

    public void setName(String string) {
        if (string != null && string.length() != 0) {
            this.addOnloadBlocker.sendViewportMessage(this, "nameChange", this.clearHistoryForViewport, string);
            this.clearHistoryForViewport = string;
        }
    }

    public int getDocumentId() {
        return this.getDocumentId;
    }

    final void increseDocumentId() {
        Object object = this.bug;
        synchronized (object) {
            ++this.getDocumentId;
        }
    }

    public void setZoom(int n) {
        Object object;
        if (n <= 0) {
            throw new IllegalArgumentException("Zoom factor must be positive");
        }
        if (this.forName != n) {
            this.forName = n;
            object = this.getPilot();
            if (object != null) {
                ((Pilot)object).setZoom(n);
            }
        }
        object = this.clearWindowObj;
        while (object != null) {
            ((Viewport)object).setZoom(this.forName);
            object = ((Viewport)object).getNextSibling();
        }
    }

    public int getZoom() {
        return this.forName;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.bug;
        synchronized (object) {
            this.findViewportByName = Listeners.add((Object)this.findViewportByName, (Object)propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = this.bug;
        synchronized (object) {
            this.findViewportByName = Listeners.remove((Object)this.findViewportByName, (Object)propertyChangeListener);
        }
    }

    final Object getPropertyListeners() {
        return this.findViewportByName;
    }

    public Container getContainer() {
        return this.container;
    }

    public Container getTopLevelContainer() {
        Container container = this.container;
        if (container != null) {
            Container container2;
            while ((container2 = container.getParent()) != null) {
                container = container2;
            }
        }
        return container;
    }

    public void setContainer(Container container) {
        if (Debug.trace && this.container != null) {
            Debug.trace((String)("Replacing AWT container in " + this));
        }
        this.container = container;
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            viewport.setContainer(container);
            viewport = viewport.getNextSibling();
        }
    }

    public void setProperty(Object object, Object object2) {
        this.ex.put(object, object2);
    }

    public void removeProperty(Object object) {
        this.ex.remove(object);
    }

    public Object getProperty(Object object) {
        return this.ex.get(object);
    }

    public ViewportGuiParams getGuiParams() {
        return this.findViewportByHistoryId;
    }

    public void setGuiParams(ViewportGuiParams viewportGuiParams) {
        this.findViewportByHistoryId = viewportGuiParams;
    }

    public boolean isStopRequested() {
        Thread thread = Thread.currentThread();
        return thread instanceof LoadThread && ((LoadThread)((Object)thread)).isStopRequested();
    }

    void stopLoading() {
        Object object = this.currentThread;
        synchronized (object) {
            this.Z();
        }
        Pilot pilot = this.pilot;
        if (pilot != null) {
            pilot.stopLoading();
        }
    }

    private void Z() {
        if (this.do_render_content != null) {
            this.do_render_content.shouldStop();
            ((Thread)((Object)this.do_render_content)).interrupt();
            this.do_render_content = null;
        }
        if (this.dispose != null) {
            if (this.dispose.onloadParent != null) {
                this.dispose.onloadParent.removeOnloadBlocker(this.dispose.parentSessionTag, this.currentThread);
            }
            this.dispose = null;
        }
    }

    void queueRenderContent(ContentLoader contentLoader) {
        Object object = this.currentThread;
        synchronized (object) {
            this.Z();
            this.dispose = new LoadSession(contentLoader);
            this.dispose.onloadParent = this.parent;
            this.dispose.selfSessionTag = this.addOnloadBlocker(this.currentThread);
            if (this.dispose.selfSessionTag != this.dispose) {
                throw new IllegalArgumentException("BAD SESSION CODE");
            }
            if (this.dispose.onloadParent != null) {
                this.dispose.parentSessionTag = this.dispose.onloadParent.addOnloadBlocker(this.currentThread);
            }
            this.do_render_content = LoadThread.create(this);
            this.do_render_content.loadSession = this.dispose;
            ((Thread)((Object)this.do_render_content)).start();
        }
    }

    void runAsynchronousLoad(LoadSession loadSession) {
        try {
            this.stateString = "busy";
            this.addOnloadBlocker.do_render_content(loadSession.getContentLoader(), this);
            Object var3_2 = null;
            this.stateString = "ready";
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stateString = "ready";
            Thread thread = Thread.currentThread();
            Object object = this.currentThread;
            synchronized (object) {
                if (thread == this.do_render_content) {
                    this.do_render_content = null;
                }
            }
            this.removeOnloadBlocker(loadSession.selfSessionTag, this.currentThread);
            throw throwable;
        }
        Thread thread = Thread.currentThread();
        Object object = this.currentThread;
        synchronized (object) {
            if (thread == this.do_render_content) {
                this.do_render_content = null;
            }
        }
        this.removeOnloadBlocker(loadSession.selfSessionTag, this.currentThread);
    }

    public Viewport getNextSibling() {
        return this.create;
    }

    public Viewport getFirstChild() {
        return this.clearWindowObj;
    }

    public void addChild(Viewport viewport) {
        viewport.setParent(this);
        viewport.createComponent = this.contextViewportImpl;
        viewport.create = null;
        if (this.contextViewportImpl != null) {
            this.contextViewportImpl.create = viewport;
        } else {
            this.clearWindowObj = viewport;
        }
        this.contextViewportImpl = viewport;
        viewport.setZoom(this.forName);
    }

    public Enumeration getChildren() {
        if (this.clearWindowObj == null) {
            return null;
        }
        return new ChildrenEnumerator(this.clearWindowObj);
    }

    public int getChildrenCount() {
        int n = 0;
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            ++n;
            viewport = viewport.getNextSibling();
        }
        return n;
    }

    public Viewport getChildByIndex(int n) {
        Viewport viewport = this.clearWindowObj;
        while (n > 0 && viewport != null) {
            --n;
            viewport = viewport.getNextSibling();
        }
        return viewport;
    }

    String getHistoryId() {
        if (this.getBaseUrl != null) {
            return this.getBaseUrl;
        }
        Viewport viewport = this.getParent();
        if (viewport == null) {
            return this.class$;
        }
        this.getBaseUrl = "";
        Viewport viewport2 = viewport;
        while (viewport2 != null) {
            this.getBaseUrl = this.getBaseUrl + "_" + viewport2.add(this);
            viewport2 = viewport2.getParent();
        }
        this.getBaseUrl = this.getBaseUrl + "_" + viewport.getLocation();
        return this.getBaseUrl;
    }

    private int add(Viewport viewport) {
        int n = 0;
        Viewport viewport2 = this.clearWindowObj;
        while (viewport2 != null && viewport2 != viewport) {
            ++n;
            viewport2 = viewport2.getNextSibling();
        }
        if (viewport2 == null) {
            return -1;
        }
        return n;
    }

    public Viewport getParent() {
        return this.parent;
    }

    public Viewport getTopParent() {
        Viewport viewport;
        Viewport viewport2 = this;
        while ((viewport = viewport2.getParent()) != null) {
            viewport2 = viewport;
        }
        return viewport2;
    }

    void setParent(Viewport viewport) {
        if (this.parent != null) {
            return;
        }
        this.parent = viewport;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public void iterate(ViewportVisitor viewportVisitor) {
        if (viewportVisitor == null) {
            return;
        }
        viewportVisitor.visit(this);
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            viewport.iterate(viewportVisitor);
            viewport = viewport.getNextSibling();
        }
    }

    public void getViewAndAllChildren(Vector vector) {
        vector.addElement(this);
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            viewport.getViewAndAllChildren(vector);
            viewport = viewport.getNextSibling();
        }
    }

    public Viewport findViewportByName(String string) {
        if (string.equals(this.class$) || string.equals(this.clearHistoryForViewport)) {
            return this;
        }
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            Viewport viewport2 = viewport.findViewportByName(string);
            if (viewport2 != null) {
                return viewport2;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    Viewport findViewportByHistoryId(String string) {
        if (string.equals(this.getHistoryId())) {
            return this;
        }
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            Viewport viewport2 = viewport.findViewportByHistoryId(string);
            if (viewport2 != null) {
                return viewport2;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    public Viewport findImmediateChild(String string) {
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            if (string.equals(viewport.class$) || string.equals(viewport.clearHistoryForViewport)) {
                return viewport;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    public Viewport getImmediateChildWithProperty(Object object, Object object2) {
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            if (viewport.getProperty(object) == object2) {
                return viewport;
            }
            viewport = viewport.getNextSibling();
        }
        return null;
    }

    public Viewport findViewportInTreeByName(String string) {
        switch (string.length()) {
            case 4: {
                if (!"_top".equals(string)) break;
                return this.getTopParent();
            }
            case 5: {
                if (!"_self".equals(string)) break;
                return this;
            }
            case 7: {
                if (!"_parent".equals(string)) break;
                Viewport viewport = this.getParent();
                if (viewport == null) {
                    viewport = this;
                }
                return viewport;
            }
        }
        Viewport viewport = this;
        do {
            Viewport viewport2;
            if ((viewport2 = viewport.findViewportByName(string)) == null) continue;
            return viewport2;
        } while ((viewport = viewport.getParent()) != null);
        return this.addOnloadBlocker.findViewportByName(string);
    }

    public Component getPilotComponent() {
        return this.equals;
    }

    public Pilot getPilot() {
        return this.pilot;
    }

    public Pilot getParentChainPilot() {
        Viewport viewport = this;
        do {
            Pilot pilot;
            if ((pilot = viewport.getPilot()) == null) continue;
            return pilot;
        } while ((viewport = viewport.getParent()) != null);
        return null;
    }

    protected void setPilot(Pilot pilot) {
        this.removePilot();
        this.pilot = pilot;
        this.pilot.setZoom(this.forName);
        if (this.clearWindowObj == null) {
            this.equals = this.pilot.createComponent();
            if (this.equals != null && this.container != null) {
                this.equals.setSize(this.container.getSize());
                this.container.add(this.equals);
                this.scheduleValidate(this.container);
            }
        }
    }

    protected void scheduleValidate(Component component) {
        this.addOnloadBlocker.runOnEventThreadLater(new Runnable(this, component){
            private final Component val$c;
            private final Viewport this$0;
            {
                this.this$0 = viewport;
                this.val$c = component;
            }

            public void run() {
                this.val$c.validate();
            }
        }, 0L);
    }

    protected void removePilot() {
        this.increseDocumentId();
        if (this.pilot == null) {
            return;
        }
        this.pilot.dispose();
        if (this.equals != null) {
            if (this.container != null) {
                this.container.remove(this.equals);
            }
            this.equals = null;
        }
        this.pilot = null;
    }

    protected void dispose() {
        this.removePilot();
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            viewport.dispose();
            viewport = viewport.getNextSibling();
        }
        this.contextViewportImpl = null;
        this.clearWindowObj = null;
        this.addOnloadBlocker.getHistoryManager().clearHistoryForViewport(this);
        this.clearWindowObj();
        this.container = null;
        this.parent = null;
    }

    void clearContent() {
        this.increseDocumentId();
        Viewport viewport = this.clearWindowObj;
        while (viewport != null) {
            viewport.dispose();
            viewport = viewport.getNextSibling();
        }
        this.contextViewportImpl = null;
        this.clearWindowObj = null;
        if (this.pilot != null && this.equals == null) {
            this.equals = this.pilot.createComponent();
            if (this.equals != null && this.container != null) {
                this.equals.setSize(this.container.getSize());
                this.container.add(this.equals);
                this.scheduleValidate(this.container);
            }
        }
    }

    public void removePilotComponent() {
        if (this.equals != null) {
            if (this.container != null) {
                this.container.remove(this.equals);
            }
            this.equals = null;
        }
    }

    public void viewportLayout(int n, int n2, int n3, int n4) {
        Pilot pilot = this.pilot;
        if (pilot != null) {
            DocPane docPane = pilot.getDocPane();
            if (docPane != null) {
                docPane.revalidate(n, n2, n3, n4);
            } else {
                Component component = this.equals;
                if (component != null) {
                    component.setBounds(n, n2, n3, n4);
                    this.scheduleValidate(component);
                }
            }
        }
    }

    public String getLocation() {
        return this.getContentLoader;
    }

    public void setLocationUrl(String string) {
        this.getContentLoader = string;
        this.getDocPane = null;
    }

    public URL getBaseURL() {
        String string = this.getBaseUrl();
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getBaseUrl() {
        String string = this.getDocPane;
        if (string == null) {
            if (this.getContentLoader != null) {
                string = this.getContentLoader;
            } else if (this.parent != null) {
                string = this.parent.getBaseUrl();
            }
        }
        return string;
    }

    public void setBaseUrl(String string) {
        if (string == null) {
            Debug.bug();
        }
        this.getDocPane = string;
    }

    public DynamicObject getDynamicWrapper() {
        return this.getWindowObj();
    }

    public final DynamicObject getWindowObj() {
        DynamicObject dynamicObject = this.get;
        if (dynamicObject == null && addElement != null) {
            Object[] objectArray = new Object[]{this.addOnloadBlocker, this};
            Object object = this.bug;
            synchronized (object) {
                block9: {
                    dynamicObject = this.get;
                    if (dynamicObject == null) {
                        try {
                            dynamicObject = this.get = (DynamicObject)addElement.invoke(null, objectArray);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (Debug.ex) {
                                Debug.ex((Throwable)illegalAccessException);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (!Debug.ex) break block9;
                            Debug.ex((Throwable)invocationTargetException.getTargetException());
                        }
                    }
                }
            }
        }
        return dynamicObject;
    }

    final void removeWindowVariables() {
        DynamicObject dynamicObject = this.get;
        if (dynamicObject != null) {
            dynamicObject.unlinkAllSlots();
        }
    }

    final void clearWindowObj() {
        DynamicObject dynamicObject = this.get;
        if (dynamicObject != null) {
            dynamicObject.unlinkAllSlots();
        }
        this.get = null;
    }

    public Viewport getContextViewport() {
        return Scripter.contextViewportImpl();
    }

    public DynamicObject getDocumentObject() {
        DynamicObject dynamicObject = null;
        Pilot pilot = this.getPilot();
        if (pilot != null) {
            dynamicObject = pilot.getDocumentObject();
        }
        if (dynamicObject == null) {
            dynamicObject = new DocumentProxy(this);
        }
        return dynamicObject;
    }

    public boolean isFrameArrayMember() {
        return this.getDocumentObject;
    }

    public void setFrameArrayMember() {
        this.getDocumentObject = true;
    }

    public final Object addOnloadBlocker(Object object) {
        LoadSession loadSession;
        Object object2 = this.currentThread;
        synchronized (object2) {
            loadSession = this.dispose;
            if (loadSession != null) {
                loadSession.onloadBlockers.put(object, (Object)Boolean.TRUE);
            }
        }
        return loadSession;
    }

    public final void removeOnloadBlocker(Object object, Object object2) {
        LoadSession loadSession = (LoadSession)object;
        LoadSession loadSession2 = null;
        Object object3 = this.currentThread;
        synchronized (object3) {
            if (this.dispose != null && loadSession == this.dispose) {
                this.dispose.onloadBlockers.remove(object2);
                if (this.dispose.onloadBlockers.size() == 0) {
                    loadSession2 = this.dispose;
                    this.dispose = null;
                }
            }
        }
        if (loadSession2 != null) {
            try {
                Pilot pilot = this.pilot;
                int n = this.getDocumentId();
                if (pilot != null) {
                    this.addOnloadBlocker.runOnEventThreadLater(new Runnable(this, n, pilot){
                        private final int val$currentId;
                        private final Pilot val$p;
                        private final Viewport this$0;
                        {
                            this.this$0 = viewport;
                            this.val$currentId = n;
                            this.val$p = pilot;
                        }

                        public void run() {
                            if (this.val$currentId == this.this$0.getDocumentId()) {
                                this.val$p.onLoadingDone();
                            }
                        }
                    }, 0L);
                }
                Object var9_9 = null;
                if (loadSession2.onloadParent != null) {
                    loadSession2.onloadParent.removeOnloadBlocker(loadSession2.parentSessionTag, this.currentThread);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (loadSession2.onloadParent != null) {
                    loadSession2.onloadParent.removeOnloadBlocker(loadSession2.parentSessionTag, this.currentThread);
                }
                throw throwable;
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ChildrenEnumerator
    implements Enumeration {
        private Viewport OEAB;

        ChildrenEnumerator(Viewport viewport) {
            this.OEAB = viewport;
        }

        public boolean hasMoreElements() {
            return this.OEAB != null;
        }

        public Object nextElement() {
            Viewport viewport = this.OEAB;
            this.OEAB = this.OEAB.getNextSibling();
            return viewport;
        }
    }
}

