/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.ExtendedIterable;
import com.mathworks.util.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LazyFilter<T>
implements ExtendedIterable<T> {
    private final Collection<T> fCollection;
    private final Predicate<T> fPredicate;

    public LazyFilter(Collection<T> collection, Predicate<T> predicate) {
        this.fCollection = collection;
        this.fPredicate = predicate;
    }

    @Override
    public boolean isEmpty() {
        return this.isSizeEqualTo(0);
    }

    @Override
    public boolean isSizeGreaterThan(int n) {
        Iterator<T> iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
        }
        return iterator.hasNext();
    }

    @Override
    public boolean isSizeEqualTo(int n) {
        Iterator<T> iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
        }
        return !iterator.hasNext();
    }

    @Override
    public boolean isSizeLessThanOrEqualTo(int n) {
        Iterator<T> iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            if (!iterator.hasNext()) {
                return true;
            }
            iterator.next();
        }
        return !iterator.hasNext();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<T> iRealIterator;
            private T iNext;
            {
                this.iRealIterator = LazyFilter.this.fCollection.iterator();
            }

            @Override
            public synchronized boolean hasNext() {
                if (this.iNext != null) {
                    return true;
                }
                while (this.iRealIterator.hasNext()) {
                    this.iNext = this.iRealIterator.next();
                    if (LazyFilter.this.fPredicate.accept(this.iNext)) break;
                    this.iNext = null;
                }
                return this.iNext != null;
            }

            @Override
            public synchronized T next() {
                if (this.hasNext()) {
                    Object t = this.iNext;
                    this.iNext = null;
                    return t;
                }
                throw new NoSuchElementException();
            }

            @Override
            public synchronized void remove() {
                this.iRealIterator.remove();
            }
        };
    }
}

