/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.Combiner;
import com.mathworks.util.RequestAggregator;
import java.util.List;

public class RequestFilter {
    private final RequestAggregator<Request> fAggregator;
    private final Runnable fCode;

    public RequestFilter(Runnable runnable) {
        this(runnable, 100);
    }

    public RequestFilter(Runnable runnable, int n) {
        this.fCode = runnable;
        this.fAggregator = new RequestAggregator<Request>(new Combiner<Request, Runnable>(){

            @Override
            public Runnable combine(final List<Request> list) {
                return new Runnable(){

                    @Override
                    public void run() {
                        if (!list.isEmpty()) {
                            ((Request)list.get(list.size() - 1)).run();
                        }
                        for (int i = 0; i < list.size() - 1; ++i) {
                            ((Request)list.get(i)).finished();
                        }
                    }
                };
            }
        }, n);
    }

    public void cancelPendingRequests() {
        this.fAggregator.cancelPendingRequests();
    }

    public void setName(String string) {
        this.fAggregator.setName(string);
    }

    public String getName() {
        return this.fAggregator.getName();
    }

    public void request() {
        this.request(null);
    }

    public void request(Runnable runnable) {
        this.fAggregator.request(new Request(runnable));
    }

    private class Request
    implements Runnable {
        private final Runnable fCodeToRunAfter;

        Request(Runnable runnable) {
            this.fCodeToRunAfter = runnable;
        }

        @Override
        public void run() {
            RequestFilter.this.fCode.run();
            this.finished();
        }

        public void finished() {
            if (this.fCodeToRunAfter != null) {
                this.fCodeToRunAfter.run();
            }
        }
    }
}

