/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.osgi;

import com.mathworks.util.FactoryUtils;
import com.mathworks.util.Log;
import com.mathworks.util.osgi.BundleProvider;
import com.mathworks.util.osgi.OSGiUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;

public final class ClasspathBundleProvider
implements BundleProvider {
    private static final String MATHWORKS_BUNDLE_ATTRIBUTE = "MathWorks-Bundle";

    @Override
    public Collection<File> getBundleJarFiles(Bundle bundle) {
        String string = FactoryUtils.getMatlabStaticClasspath();
        String[] stringArray = string.split(File.pathSeparator);
        HashSet<File> hashSet = new HashSet<File>();
        for (String string2 : stringArray) {
            if (string2.endsWith("\\")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (FilenameUtils.isExtension((String)string2, (String)"jar") && ClasspathBundleProvider.hasBundleAttribute(string2)) {
                OSGiUtils.log("Added " + string2);
                hashSet.add(new File(string2));
                continue;
            }
            OSGiUtils.log("Skipped " + string2);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean hasBundleAttribute(String string) {
        JarInputStream jarInputStream;
        boolean bl;
        block6: {
            bl = false;
            jarInputStream = null;
            try {
                jarInputStream = new JarInputStream(new FileInputStream(string));
                Manifest manifest = jarInputStream.getManifest();
                if (manifest == null) break block6;
                Attributes attributes = manifest.getMainAttributes();
                bl = "true".equals(attributes.getValue(MATHWORKS_BUNDLE_ATTRIBUTE));
            }
            catch (FileNotFoundException fileNotFoundException) {
                IOUtils.closeQuietly(jarInputStream);
            }
            catch (IOException iOException) {
                OSGiUtils.log("Error loading " + string);
                Log.logException(iOException);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(jarInputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)jarInputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)jarInputStream);
        return bl;
    }
}

