/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.StringTokenizer;
import net.jini.loader.ClassLoading;

class ServiceType
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected String name;
    protected ServiceType superclass;
    protected ServiceType[] interfaces;
    protected transient ServiceType replacement;
    protected transient ServiceType[] concreteClasses;
    private transient boolean integrity = false;
    private static final ServiceType[] empty = new ServiceType[0];

    public ServiceType(Class clazz, ServiceType serviceType, ServiceType[] serviceTypeArray) {
        if (!Proxy.isProxyClass(clazz)) {
            this.name = clazz.getName();
        } else if (serviceTypeArray.length == 0) {
            this.name = ";";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < serviceTypeArray.length; ++i) {
                stringBuffer.append(';');
                stringBuffer.append(serviceTypeArray[i].getName());
            }
            this.name = stringBuffer.toString();
        }
        this.superclass = serviceType;
        if (clazz != Object.class) {
            this.interfaces = serviceTypeArray;
        }
    }

    private ServiceType(ServiceType serviceType) {
        this.name = serviceType.name;
    }

    public String getName() {
        return this.name;
    }

    public ServiceType getSuperclass() {
        return this.superclass;
    }

    public ServiceType[] getInterfaces() {
        if (this.interfaces != null) {
            return this.interfaces;
        }
        return empty;
    }

    public ServiceType getReplacement() {
        return this.replacement;
    }

    public boolean isAssignableFrom(ServiceType serviceType) {
        if (this == serviceType) {
            return true;
        }
        if (this.isInterface()) {
            if (this.isAssignableFrom(serviceType.interfaces)) {
                return true;
            }
            ServiceType serviceType2 = serviceType.superclass;
            while (serviceType2 != null && serviceType2.interfaces != null) {
                if (this.isAssignableFrom(serviceType2.interfaces)) {
                    return true;
                }
                serviceType2 = serviceType2.superclass;
            }
        } else {
            ServiceType serviceType3 = serviceType.superclass;
            while (serviceType3 != null) {
                if (this == serviceType3) {
                    return true;
                }
                serviceType3 = serviceType3.superclass;
            }
        }
        return false;
    }

    private boolean isAssignableFrom(ServiceType[] serviceTypeArray) {
        int n = serviceTypeArray.length;
        while (--n >= 0) {
            if (this != serviceTypeArray[n] && !this.isAssignableFrom(serviceTypeArray[n].interfaces)) continue;
            return true;
        }
        return false;
    }

    public boolean isInterface() {
        return this.superclass == null && this.interfaces != null;
    }

    public Class toClass(String string) throws IOException, ClassNotFoundException {
        if (this.name.charAt(0) != ';') {
            return ClassLoading.loadClass((String)string, (String)this.name, null, (boolean)this.integrity, null);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.name, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return ClassLoading.loadProxyClass((String)string, (String[])stringArray, null, (boolean)this.integrity, null);
    }

    public void canonical(ServiceType serviceType) {
        this.superclass = serviceType;
        this.replacement = new ServiceType(this);
        this.concreteClasses = empty;
    }

    public ServiceType[] getConcreteClasses() {
        return this.concreteClasses;
    }

    public void setConcreteClasses(ServiceType[] serviceTypeArray) {
        if (serviceTypeArray.length == 0) {
            serviceTypeArray = empty;
        }
        this.concreteClasses = serviceTypeArray;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.integrity = MarshalledWrapper.integrityEnforced(objectInputStream);
    }
}

